(function() {
  var TagsURL, fetch, filterExcerpt, fs, mdnHTMLURL, mdnJSONAPI, path, request;

  path = require('path');

  fs = require('fs');

  request = require('request');

  mdnHTMLURL = 'https://developer.mozilla.org/en-US/docs/Web/HTML/Element';

  mdnJSONAPI = 'https://developer.mozilla.org/en-US/search.json?topic=html&highlight=false';

  TagsURL = 'https://raw.githubusercontent.com/adobe/brackets/master/src/extensions/default/HTMLCodeHints/HtmlTags.json';

  fetch = function() {
    var tagsPromise;
    tagsPromise = new Promise(function(resolve) {
      return request({
        json: true,
        url: TagsURL
      }, function(error, response, tags) {
        if (error != null) {
          console.error(error.message);
          resolve(null);
        }
        if (response.statusCode !== 200) {
          console.error("Request for HtmlTags.json failed: " + response.statusCode);
          resolve(null);
        }
        return resolve(tags);
      });
    });
    return tagsPromise.then(function(tags) {
      var MAX, docs, queue, running;
      if (tags == null) {
        return;
      }
      MAX = 10;
      queue = Object.keys(tags);
      running = [];
      docs = {};
      return new Promise(function(resolve) {
        var checkEnd, handleRequest, i, ref, removeRunning, run, runNext;
        checkEnd = function() {
          if (queue.length === 0 && running.length === 0) {
            return resolve(docs);
          }
        };
        removeRunning = function(tagName) {
          var index;
          index = running.indexOf(tagName);
          if (index > -1) {
            return running.splice(index, 1);
          }
        };
        runNext = function() {
          var tagName;
          checkEnd();
          if (queue.length !== 0) {
            tagName = queue.pop();
            running.push(tagName);
            return run(tagName);
          }
        };
        run = function(tagName) {
          var url;
          url = mdnJSONAPI + "&q=" + tagName;
          return request({
            json: true,
            url: url
          }, function(error, response, searchResults) {
            if ((error == null) && response.statusCode === 200) {
              handleRequest(tagName, searchResults);
            } else {
              console.error("Req failed " + url + "; " + response.statusCode + ", " + error);
            }
            removeRunning(tagName);
            return runNext();
          });
        };
        handleRequest = function(tagName, searchResults) {
          var doc, i, len, ref;
          if (searchResults.documents != null) {
            ref = searchResults.documents;
            for (i = 0, len = ref.length; i < len; i++) {
              doc = ref[i];
              if (doc.url === (mdnHTMLURL + "/" + tagName) || (/^h\d$/.test(tagName) && doc.url === (mdnHTMLURL + "/Heading_Elements"))) {
                if (doc.tags.includes('Obsolete')) {
                  docs[tagName] = "The " + tagName + " element is obsolete. Avoid using it and update existing code if possible.";
                } else if (doc.tags.includes('Deprecated')) {
                  docs[tagName] = "The " + tagName + " element is deprecated. Avoid using it and update existing code if possible.";
                } else {
                  docs[tagName] = filterExcerpt(tagName, doc.excerpt);
                }
                return;
              }
            }
          }
          return console.log("Could not find documentation for " + tagName);
        };
        for (i = 0, ref = MAX; 0 <= ref ? i <= ref : i >= ref; 0 <= ref ? i++ : i--) {
          runNext();
        }
      });
    });
  };

  filterExcerpt = function(tagName, excerpt) {
    var beginningPattern, periodIndex;
    beginningPattern = /^the html [a-z-]+ element (\([^)]+\) )?(is )?(\w+)/i;
    excerpt = excerpt.replace(beginningPattern, function(match) {
      var firstWord, matches;
      matches = beginningPattern.exec(match);
      firstWord = matches[3];
      return firstWord[0].toUpperCase() + firstWord.slice(1);
    });
    periodIndex = excerpt.indexOf('.');
    if (periodIndex > -1) {
      excerpt = excerpt.slice(0, periodIndex + 1);
    }
    return excerpt;
  };

  if (require.main === module) {
    fetch().then(function(docs) {
      if (docs != null) {
        return fs.writeFileSync(path.join(__dirname, 'tag-docs.json'), (JSON.stringify(docs, null, '  ')) + "\n");
      } else {
        return console.error('No docs');
      }
    });
  }

  module.exports = fetch;

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
