(function() {
  var COMPLETIONS, cssDocsURL, firstCharsEqual, firstInlinePropertyNameWithColonPattern, hasScope, importantPrefixPattern, inlinePropertyNameWithColonPattern, lineEndsWithSemicolon, path, propertyNamePrefixPattern, propertyNameWithColonPattern, pseudoSelectorPrefixPattern, tagSelectorPrefixPattern;

  path = require('path');

  COMPLETIONS = require('../completions.json');

  firstInlinePropertyNameWithColonPattern = /{\s*(\S+)\s*:/;

  inlinePropertyNameWithColonPattern = /(?:;.+?)*;\s*(\S+)\s*:/;

  propertyNameWithColonPattern = /^\s*(\S+)\s*:/;

  propertyNamePrefixPattern = /[a-zA-Z]+[-a-zA-Z]*$/;

  pseudoSelectorPrefixPattern = /:(:)?([a-z]+[a-z-]*)?$/;

  tagSelectorPrefixPattern = /(^|\s|,)([a-z]+)?$/;

  importantPrefixPattern = /(![a-z]+)$/;

  cssDocsURL = "https://developer.mozilla.org/en-US/docs/Web/CSS";

  module.exports = {
    selector: '.source.css, .source.sass',
    disableForSelector: '.source.css .comment, .source.css .string, .source.sass .comment, .source.sass .string',
    properties: COMPLETIONS.properties,
    pseudoSelectors: COMPLETIONS.pseudoSelectors,
    tags: COMPLETIONS.tags,
    filterSuggestions: true,
    getSuggestions: function(request) {
      var completions, isSass, scopes, tagCompletions;
      completions = null;
      scopes = request.scopeDescriptor.getScopesArray();
      isSass = hasScope(scopes, 'source.sass');
      if (this.isCompletingValue(request)) {
        completions = this.getPropertyValueCompletions(request);
      } else if (this.isCompletingPseudoSelector(request)) {
        completions = this.getPseudoSelectorCompletions(request);
      } else {
        if (isSass && this.isCompletingNameOrTag(request)) {
          completions = this.getPropertyNameCompletions(request).concat(this.getTagCompletions(request));
        } else if (!isSass && this.isCompletingName(request)) {
          completions = this.getPropertyNameCompletions(request);
        }
      }
      if (!isSass && this.isCompletingTagSelector(request)) {
        tagCompletions = this.getTagCompletions(request);
        if (tagCompletions != null ? tagCompletions.length : void 0) {
          if (completions == null) {
            completions = [];
          }
          completions = completions.concat(tagCompletions);
        }
      }
      return completions;
    },
    onDidInsertSuggestion: function(arg) {
      var editor, suggestion;
      editor = arg.editor, suggestion = arg.suggestion;
      if (suggestion.type === 'property') {
        return setTimeout(this.triggerAutocomplete.bind(this, editor), 1);
      }
    },
    triggerAutocomplete: function(editor) {
      return atom.commands.dispatch(atom.views.getView(editor), 'autocomplete-plus:activate', {
        activatedManually: false
      });
    },
    isCompletingValue: function(arg) {
      var beforePrefixBufferPosition, beforePrefixScopes, beforePrefixScopesArray, bufferPosition, editor, prefix, previousBufferPosition, previousScopes, previousScopesArray, scopeDescriptor, scopes;
      scopeDescriptor = arg.scopeDescriptor, bufferPosition = arg.bufferPosition, prefix = arg.prefix, editor = arg.editor;
      scopes = scopeDescriptor.getScopesArray();
      beforePrefixBufferPosition = [bufferPosition.row, Math.max(0, bufferPosition.column - prefix.length - 1)];
      beforePrefixScopes = editor.scopeDescriptorForBufferPosition(beforePrefixBufferPosition);
      beforePrefixScopesArray = beforePrefixScopes.getScopesArray();
      previousBufferPosition = [bufferPosition.row, Math.max(0, bufferPosition.column - 1)];
      previousScopes = editor.scopeDescriptorForBufferPosition(previousBufferPosition);
      previousScopesArray = previousScopes.getScopesArray();
      return (hasScope(scopes, 'meta.property-list.css') && prefix.trim() === ":") || (hasScope(previousScopesArray, 'meta.property-value.css')) || (hasScope(scopes, 'meta.property-list.scss') && prefix.trim() === ":") || (hasScope(previousScopesArray, 'meta.property-value.scss')) || (hasScope(scopes, 'source.sass') && (hasScope(scopes, 'meta.property-value.sass') || (!hasScope(beforePrefixScopesArray, 'entity.name.tag.css') && !hasScope(beforePrefixScopesArray, 'entity.name.tag.css.sass') && prefix.trim() === ":")));
    },
    isCompletingName: function(arg) {
      var bufferPosition, editor, isAtBeginScopePunctuation, isAtEndScopePunctuation, isAtParentSymbol, isAtTerminator, isInPropertyList, prefix, previousBufferPosition, previousScopes, previousScopesArray, scopeDescriptor, scopes;
      scopeDescriptor = arg.scopeDescriptor, bufferPosition = arg.bufferPosition, prefix = arg.prefix, editor = arg.editor;
      scopes = scopeDescriptor.getScopesArray();
      isAtTerminator = prefix.endsWith(';');
      isAtParentSymbol = prefix.endsWith('&');
      isInPropertyList = !isAtTerminator && (hasScope(scopes, 'meta.property-list.css') || hasScope(scopes, 'meta.property-list.scss'));
      if (!isInPropertyList) {
        return false;
      }
      if (isAtParentSymbol) {
        return false;
      }
      previousBufferPosition = [bufferPosition.row, Math.max(0, bufferPosition.column - prefix.length - 1)];
      previousScopes = editor.scopeDescriptorForBufferPosition(previousBufferPosition);
      previousScopesArray = previousScopes.getScopesArray();
      if (hasScope(previousScopesArray, 'entity.other.attribute-name.class.css') || hasScope(previousScopesArray, 'entity.other.attribute-name.id.css') || hasScope(previousScopesArray, 'entity.other.attribute-name.id') || hasScope(previousScopesArray, 'entity.other.attribute-name.parent-selector.css') || hasScope(previousScopesArray, 'entity.name.tag.reference.scss') || hasScope(previousScopesArray, 'entity.name.tag.scss')) {
        return false;
      }
      isAtBeginScopePunctuation = hasScope(scopes, 'punctuation.section.property-list.begin.bracket.curly.css') || hasScope(scopes, 'punctuation.section.property-list.begin.bracket.curly.scss');
      isAtEndScopePunctuation = hasScope(scopes, 'punctuation.section.property-list.end.bracket.curly.css') || hasScope(scopes, 'punctuation.section.property-list.end.bracket.curly.scss');
      if (isAtBeginScopePunctuation) {
        return prefix.endsWith('{');
      } else if (isAtEndScopePunctuation) {
        return !prefix.endsWith('}');
      } else {
        return true;
      }
    },
    isCompletingNameOrTag: function(arg) {
      var bufferPosition, editor, prefix, scopeDescriptor, scopes;
      scopeDescriptor = arg.scopeDescriptor, bufferPosition = arg.bufferPosition, editor = arg.editor;
      scopes = scopeDescriptor.getScopesArray();
      prefix = this.getPropertyNamePrefix(bufferPosition, editor);
      return this.isPropertyNamePrefix(prefix) && hasScope(scopes, 'meta.selector.css') && !hasScope(scopes, 'entity.other.attribute-name.id.css.sass') && !hasScope(scopes, 'entity.other.attribute-name.class.sass');
    },
    isCompletingTagSelector: function(arg) {
      var bufferPosition, editor, previousBufferPosition, previousScopes, previousScopesArray, scopeDescriptor, scopes, tagSelectorPrefix;
      editor = arg.editor, scopeDescriptor = arg.scopeDescriptor, bufferPosition = arg.bufferPosition;
      scopes = scopeDescriptor.getScopesArray();
      tagSelectorPrefix = this.getTagSelectorPrefix(editor, bufferPosition);
      if (!(tagSelectorPrefix != null ? tagSelectorPrefix.length : void 0)) {
        return false;
      }
      previousBufferPosition = [bufferPosition.row, Math.max(0, bufferPosition.column - 1)];
      previousScopes = editor.scopeDescriptorForBufferPosition(previousBufferPosition);
      previousScopesArray = previousScopes.getScopesArray();
      if (hasScope(scopes, 'meta.selector.css') || hasScope(previousScopesArray, 'meta.selector.css')) {
        return true;
      } else if (hasScope(scopes, 'source.css.scss') || hasScope(scopes, 'source.css.less')) {
        return !hasScope(previousScopesArray, 'meta.property-value.scss') && !hasScope(previousScopesArray, 'meta.property-value.css') && !hasScope(previousScopesArray, 'support.type.property-value.css');
      } else {
        return false;
      }
    },
    isCompletingPseudoSelector: function(arg) {
      var bufferPosition, editor, prefix, previousBufferPosition, previousScopes, previousScopesArray, scopeDescriptor, scopes;
      editor = arg.editor, scopeDescriptor = arg.scopeDescriptor, bufferPosition = arg.bufferPosition;
      scopes = scopeDescriptor.getScopesArray();
      previousBufferPosition = [bufferPosition.row, Math.max(0, bufferPosition.column - 1)];
      previousScopes = editor.scopeDescriptorForBufferPosition(previousBufferPosition);
      previousScopesArray = previousScopes.getScopesArray();
      if ((hasScope(scopes, 'meta.selector.css') || hasScope(previousScopesArray, 'meta.selector.css')) && !hasScope(scopes, 'source.sass')) {
        return true;
      } else if (hasScope(scopes, 'source.css.scss') || hasScope(scopes, 'source.css.less') || hasScope(scopes, 'source.sass')) {
        prefix = this.getPseudoSelectorPrefix(editor, bufferPosition);
        if (prefix) {
          previousBufferPosition = [bufferPosition.row, Math.max(0, bufferPosition.column - prefix.length - 1)];
          previousScopes = editor.scopeDescriptorForBufferPosition(previousBufferPosition);
          previousScopesArray = previousScopes.getScopesArray();
          return !hasScope(previousScopesArray, 'meta.property-name.scss') && !hasScope(previousScopesArray, 'meta.property-value.scss') && !hasScope(previousScopesArray, 'support.type.property-name.css') && !hasScope(previousScopesArray, 'support.type.property-value.css');
        } else {
          return false;
        }
      } else {
        return false;
      }
    },
    isPropertyValuePrefix: function(prefix) {
      prefix = prefix.trim();
      return prefix.length > 0 && prefix !== ':';
    },
    isPropertyNamePrefix: function(prefix) {
      if (prefix == null) {
        return false;
      }
      prefix = prefix.trim();
      return prefix.length > 0 && prefix.match(/^[a-zA-Z-]+$/);
    },
    getImportantPrefix: function(editor, bufferPosition) {
      var line, ref;
      line = editor.getTextInRange([[bufferPosition.row, 0], bufferPosition]);
      return (ref = importantPrefixPattern.exec(line)) != null ? ref[1] : void 0;
    },
    getPreviousPropertyName: function(bufferPosition, editor) {
      var column, line, propertyName, ref, ref1, ref2, row;
      row = bufferPosition.row, column = bufferPosition.column;
      while (row >= 0) {
        line = editor.lineTextForBufferRow(row);
        if (row === bufferPosition.row) {
          line = line.substr(0, column);
        }
        propertyName = (ref = inlinePropertyNameWithColonPattern.exec(line)) != null ? ref[1] : void 0;
        if (propertyName == null) {
          propertyName = (ref1 = firstInlinePropertyNameWithColonPattern.exec(line)) != null ? ref1[1] : void 0;
        }
        if (propertyName == null) {
          propertyName = (ref2 = propertyNameWithColonPattern.exec(line)) != null ? ref2[1] : void 0;
        }
        if (propertyName) {
          return propertyName;
        }
        row--;
      }
    },
    getPropertyValueCompletions: function(arg) {
      var addSemicolon, bufferPosition, completions, editor, i, importantPrefix, j, len, len1, prefix, property, ref, scopeDescriptor, scopes, value, values;
      bufferPosition = arg.bufferPosition, editor = arg.editor, prefix = arg.prefix, scopeDescriptor = arg.scopeDescriptor;
      property = this.getPreviousPropertyName(bufferPosition, editor);
      values = (ref = this.properties[property]) != null ? ref.values : void 0;
      if (values == null) {
        return null;
      }
      scopes = scopeDescriptor.getScopesArray();
      addSemicolon = !lineEndsWithSemicolon(bufferPosition, editor) && !hasScope(scopes, 'source.sass');
      completions = [];
      if (this.isPropertyValuePrefix(prefix)) {
        for (i = 0, len = values.length; i < len; i++) {
          value = values[i];
          if (firstCharsEqual(value, prefix)) {
            completions.push(this.buildPropertyValueCompletion(value, property, addSemicolon));
          }
        }
      } else {
        for (j = 0, len1 = values.length; j < len1; j++) {
          value = values[j];
          completions.push(this.buildPropertyValueCompletion(value, property, addSemicolon));
        }
      }
      if (importantPrefix = this.getImportantPrefix(editor, bufferPosition)) {
        completions.push({
          type: 'keyword',
          text: '!important',
          displayText: '!important',
          replacementPrefix: importantPrefix,
          description: "Forces this property to override any other declaration of the same property. Use with caution.",
          descriptionMoreURL: cssDocsURL + "/Specificity#The_!important_exception"
        });
      }
      return completions;
    },
    buildPropertyValueCompletion: function(value, propertyName, addSemicolon) {
      var text;
      text = value;
      if (addSemicolon) {
        text += ';';
      }
      return {
        type: 'value',
        text: text,
        displayText: value,
        description: value + " value for the " + propertyName + " property",
        descriptionMoreURL: cssDocsURL + "/" + propertyName + "#Values"
      };
    },
    getPropertyNamePrefix: function(bufferPosition, editor) {
      var line, ref;
      line = editor.getTextInRange([[bufferPosition.row, 0], bufferPosition]);
      return (ref = propertyNamePrefixPattern.exec(line)) != null ? ref[0] : void 0;
    },
    getPropertyNameCompletions: function(arg) {
      var activatedManually, bufferPosition, completions, editor, line, options, prefix, property, ref, scopeDescriptor, scopes;
      bufferPosition = arg.bufferPosition, editor = arg.editor, scopeDescriptor = arg.scopeDescriptor, activatedManually = arg.activatedManually;
      scopes = scopeDescriptor.getScopesArray();
      line = editor.getTextInRange([[bufferPosition.row, 0], bufferPosition]);
      if (hasScope(scopes, 'source.sass') && !line.match(/^(\s|\t)/)) {
        return [];
      }
      prefix = this.getPropertyNamePrefix(bufferPosition, editor);
      if (!(activatedManually || prefix)) {
        return [];
      }
      completions = [];
      ref = this.properties;
      for (property in ref) {
        options = ref[property];
        if (!prefix || firstCharsEqual(property, prefix)) {
          completions.push(this.buildPropertyNameCompletion(property, prefix, options));
        }
      }
      return completions;
    },
    buildPropertyNameCompletion: function(propertyName, prefix, arg) {
      var description;
      description = arg.description;
      return {
        type: 'property',
        text: propertyName + ": ",
        displayText: propertyName,
        replacementPrefix: prefix,
        description: description,
        descriptionMoreURL: cssDocsURL + "/" + propertyName
      };
    },
    getPseudoSelectorPrefix: function(editor, bufferPosition) {
      var line, ref;
      line = editor.getTextInRange([[bufferPosition.row, 0], bufferPosition]);
      return (ref = line.match(pseudoSelectorPrefixPattern)) != null ? ref[0] : void 0;
    },
    getPseudoSelectorCompletions: function(arg) {
      var bufferPosition, completions, editor, options, prefix, pseudoSelector, ref;
      bufferPosition = arg.bufferPosition, editor = arg.editor;
      prefix = this.getPseudoSelectorPrefix(editor, bufferPosition);
      if (!prefix) {
        return null;
      }
      completions = [];
      ref = this.pseudoSelectors;
      for (pseudoSelector in ref) {
        options = ref[pseudoSelector];
        if (firstCharsEqual(pseudoSelector, prefix)) {
          completions.push(this.buildPseudoSelectorCompletion(pseudoSelector, prefix, options));
        }
      }
      return completions;
    },
    buildPseudoSelectorCompletion: function(pseudoSelector, prefix, arg) {
      var argument, completion, description;
      argument = arg.argument, description = arg.description;
      completion = {
        type: 'pseudo-selector',
        replacementPrefix: prefix,
        description: description,
        descriptionMoreURL: cssDocsURL + "/" + pseudoSelector
      };
      if (argument != null) {
        completion.snippet = pseudoSelector + "(${1:" + argument + "})";
      } else {
        completion.text = pseudoSelector;
      }
      return completion;
    },
    getTagSelectorPrefix: function(editor, bufferPosition) {
      var line, ref;
      line = editor.getTextInRange([[bufferPosition.row, 0], bufferPosition]);
      return (ref = tagSelectorPrefixPattern.exec(line)) != null ? ref[2] : void 0;
    },
    getTagCompletions: function(arg) {
      var bufferPosition, completions, editor, i, len, prefix, ref, tag;
      bufferPosition = arg.bufferPosition, editor = arg.editor, prefix = arg.prefix;
      completions = [];
      if (prefix) {
        ref = this.tags;
        for (i = 0, len = ref.length; i < len; i++) {
          tag = ref[i];
          if (firstCharsEqual(tag, prefix)) {
            completions.push(this.buildTagCompletion(tag));
          }
        }
      }
      return completions;
    },
    buildTagCompletion: function(tag) {
      return {
        type: 'tag',
        text: tag,
        description: "Selector for <" + tag + "> elements"
      };
    }
  };

  lineEndsWithSemicolon = function(bufferPosition, editor) {
    var line, row;
    row = bufferPosition.row;
    line = editor.lineTextForBufferRow(row);
    return /;\s*$/.test(line);
  };

  hasScope = function(scopesArray, scope) {
    return scopesArray.indexOf(scope) !== -1;
  };

  firstCharsEqual = function(str1, str2) {
    return str1[0].toLowerCase() === str2[0].toLowerCase();
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
