Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

/*
  Public: Abstract class for handling the initialization
  boilerplate of an Etch component.
*/

var EtchComponent = (function () {
  function EtchComponent(props) {
    _classCallCheck(this, EtchComponent);

    this.props = props;

    _etch2['default'].initialize(this);
    EtchComponent.setScheduler(atom.views);
  }

  /*
    Public: Gets the scheduler Etch uses for coordinating DOM updates.
     Returns a {Scheduler}
  */

  _createClass(EtchComponent, [{
    key: 'update',

    /*
      Public: Updates the component's properties and re-renders it. Only the
      properties you specify in this object will update – any other properties
      the component stores will be unaffected.
       * `props` an {Object} representing the properties you want to update
    */
    value: function update(props) {
      var oldProps = this.props;
      this.props = Object.assign({}, oldProps, props);
      return _etch2['default'].update(this);
    }

    /*
      Public: Destroys the component, removing it from the DOM.
    */
  }, {
    key: 'destroy',
    value: function destroy() {
      _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      throw new Error('Etch components must implement a `render` method');
    }
  }], [{
    key: 'getScheduler',
    value: function getScheduler() {
      return _etch2['default'].getScheduler();
    }

    /*
      Public: Sets the scheduler Etch uses for coordinating DOM updates.
       * `scheduler` {Scheduler}
    */
  }, {
    key: 'setScheduler',
    value: function setScheduler(scheduler) {
      _etch2['default'].setScheduler(scheduler);
    }
  }]);

  return EtchComponent;
})();

exports['default'] = EtchComponent;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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