(function() {
  var CommentScopeRegex, Token, TokenizedLine, idCounter;

  Token = require('./token');

  CommentScopeRegex = /(\b|\.)comment/;

  idCounter = 1;

  module.exports = TokenizedLine = (function() {
    function TokenizedLine(properties) {
      this.id = idCounter++;
      if (properties == null) {
        return;
      }
      this.openScopes = properties.openScopes, this.text = properties.text, this.tags = properties.tags, this.ruleStack = properties.ruleStack, this.tokenIterator = properties.tokenIterator, this.grammar = properties.grammar;
    }

    TokenizedLine.prototype.getTokenIterator = function() {
      return this.tokenIterator.reset(this);
    };

    Object.defineProperty(TokenizedLine.prototype, 'tokens', {
      get: function() {
        var iterator, tokens;
        iterator = this.getTokenIterator();
        tokens = [];
        while (iterator.next()) {
          tokens.push(new Token({
            value: iterator.getText(),
            scopes: iterator.getScopes().slice()
          }));
        }
        return tokens;
      }
    });

    TokenizedLine.prototype.tokenAtBufferColumn = function(bufferColumn) {
      return this.tokens[this.tokenIndexAtBufferColumn(bufferColumn)];
    };

    TokenizedLine.prototype.tokenIndexAtBufferColumn = function(bufferColumn) {
      var column, i, index, len, ref, token;
      column = 0;
      ref = this.tokens;
      for (index = i = 0, len = ref.length; i < len; index = ++i) {
        token = ref[index];
        column += token.value.length;
        if (column > bufferColumn) {
          return index;
        }
      }
      return index - 1;
    };

    TokenizedLine.prototype.tokenStartColumnForBufferColumn = function(bufferColumn) {
      var delta, i, len, nextDelta, ref, token;
      delta = 0;
      ref = this.tokens;
      for (i = 0, len = ref.length; i < len; i++) {
        token = ref[i];
        nextDelta = delta + token.bufferDelta;
        if (nextDelta > bufferColumn) {
          break;
        }
        delta = nextDelta;
      }
      return delta;
    };

    TokenizedLine.prototype.isComment = function() {
      var i, j, len, len1, ref, ref1, tag;
      if (this.isCommentLine != null) {
        return this.isCommentLine;
      }
      this.isCommentLine = false;
      ref = this.openScopes;
      for (i = 0, len = ref.length; i < len; i++) {
        tag = ref[i];
        if (this.isCommentOpenTag(tag)) {
          this.isCommentLine = true;
          return this.isCommentLine;
        }
      }
      ref1 = this.tags;
      for (j = 0, len1 = ref1.length; j < len1; j++) {
        tag = ref1[j];
        if (this.isCommentOpenTag(tag)) {
          this.isCommentLine = true;
          return this.isCommentLine;
        }
      }
      return this.isCommentLine;
    };

    TokenizedLine.prototype.isCommentOpenTag = function(tag) {
      var scope;
      if (tag < 0 && (tag & 1) === 1) {
        scope = this.grammar.scopeForId(tag);
        if (CommentScopeRegex.test(scope)) {
          return true;
        }
      }
      return false;
    };

    TokenizedLine.prototype.tokenAtIndex = function(index) {
      return this.tokens[index];
    };

    TokenizedLine.prototype.getTokenCount = function() {
      var count, i, len, ref, tag;
      count = 0;
      ref = this.tags;
      for (i = 0, len = ref.length; i < len; i++) {
        tag = ref[i];
        if (tag >= 0) {
          count++;
        }
      }
      return count;
    };

    return TokenizedLine;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
