(function() {
  var CompositeDisposable, Emitter, Model, NullGrammar, Point, Range, ScopeDescriptor, TokenIterator, TokenizedBuffer, TokenizedBufferIterator, TokenizedLine, _, prefixedScopes, ref, ref1, selectorMatchesAnyScope, toFirstMateScopeId,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  _ = require('underscore-plus');

  ref = require('event-kit'), CompositeDisposable = ref.CompositeDisposable, Emitter = ref.Emitter;

  ref1 = require('text-buffer'), Point = ref1.Point, Range = ref1.Range;

  Model = require('./model');

  TokenizedLine = require('./tokenized-line');

  TokenIterator = require('./token-iterator');

  ScopeDescriptor = require('./scope-descriptor');

  TokenizedBufferIterator = require('./tokenized-buffer-iterator');

  NullGrammar = require('./null-grammar');

  toFirstMateScopeId = require('./first-mate-helpers').toFirstMateScopeId;

  prefixedScopes = new Map();

  module.exports = TokenizedBuffer = (function(superClass) {
    extend(TokenizedBuffer, superClass);

    TokenizedBuffer.prototype.grammar = null;

    TokenizedBuffer.prototype.buffer = null;

    TokenizedBuffer.prototype.tabLength = null;

    TokenizedBuffer.prototype.tokenizedLines = null;

    TokenizedBuffer.prototype.chunkSize = 50;

    TokenizedBuffer.prototype.invalidRows = null;

    TokenizedBuffer.prototype.visible = false;

    TokenizedBuffer.prototype.changeCount = 0;

    TokenizedBuffer.deserialize = function(state, atomEnvironment) {
      if (state.bufferId) {
        state.buffer = atomEnvironment.project.bufferForIdSync(state.bufferId);
      } else {
        state.buffer = atomEnvironment.project.bufferForPathSync(state.bufferPath);
      }
      state.assert = atomEnvironment.assert;
      return new this(state);
    };

    function TokenizedBuffer(params) {
      var grammar;
      grammar = params.grammar, this.buffer = params.buffer, this.tabLength = params.tabLength, this.largeFileMode = params.largeFileMode, this.assert = params.assert;
      this.emitter = new Emitter;
      this.disposables = new CompositeDisposable;
      this.tokenIterator = new TokenIterator(this);
      this.disposables.add(this.buffer.registerTextDecorationLayer(this));
      this.setGrammar(grammar != null ? grammar : NullGrammar);
    }

    TokenizedBuffer.prototype.destroyed = function() {
      this.disposables.dispose();
      return this.tokenizedLines.length = 0;
    };

    TokenizedBuffer.prototype.buildIterator = function() {
      return new TokenizedBufferIterator(this);
    };

    TokenizedBuffer.prototype.classNameForScopeId = function(id) {
      var prefixedScope, scope;
      scope = this.grammar.scopeForId(toFirstMateScopeId(id));
      if (scope) {
        prefixedScope = prefixedScopes.get(scope);
        if (prefixedScope) {
          return prefixedScope;
        } else {
          prefixedScope = "syntax--" + (scope.replace(/\./g, ' syntax--'));
          prefixedScopes.set(scope, prefixedScope);
          return prefixedScope;
        }
      } else {
        return null;
      }
    };

    TokenizedBuffer.prototype.getInvalidatedRanges = function() {
      return [];
    };

    TokenizedBuffer.prototype.onDidInvalidateRange = function(fn) {
      return this.emitter.on('did-invalidate-range', fn);
    };

    TokenizedBuffer.prototype.serialize = function() {
      return {
        deserializer: 'TokenizedBuffer',
        bufferPath: this.buffer.getPath(),
        bufferId: this.buffer.getId(),
        tabLength: this.tabLength,
        largeFileMode: this.largeFileMode
      };
    };

    TokenizedBuffer.prototype.observeGrammar = function(callback) {
      callback(this.grammar);
      return this.onDidChangeGrammar(callback);
    };

    TokenizedBuffer.prototype.onDidChangeGrammar = function(callback) {
      return this.emitter.on('did-change-grammar', callback);
    };

    TokenizedBuffer.prototype.onDidTokenize = function(callback) {
      return this.emitter.on('did-tokenize', callback);
    };

    TokenizedBuffer.prototype.setGrammar = function(grammar) {
      var ref2;
      if (!((grammar != null) && grammar !== this.grammar)) {
        return;
      }
      this.grammar = grammar;
      this.rootScopeDescriptor = new ScopeDescriptor({
        scopes: [this.grammar.scopeName]
      });
      if ((ref2 = this.grammarUpdateDisposable) != null) {
        ref2.dispose();
      }
      this.grammarUpdateDisposable = this.grammar.onDidUpdate((function(_this) {
        return function() {
          return _this.retokenizeLines();
        };
      })(this));
      this.disposables.add(this.grammarUpdateDisposable);
      this.retokenizeLines();
      return this.emitter.emit('did-change-grammar', grammar);
    };

    TokenizedBuffer.prototype.getGrammarSelectionContent = function() {
      return this.buffer.getTextInRange([[0, 0], [10, 0]]);
    };

    TokenizedBuffer.prototype.hasTokenForSelector = function(selector) {
      var i, j, len, len1, ref2, ref3, token, tokenizedLine;
      ref2 = this.tokenizedLines;
      for (i = 0, len = ref2.length; i < len; i++) {
        tokenizedLine = ref2[i];
        if (tokenizedLine != null) {
          ref3 = tokenizedLine.tokens;
          for (j = 0, len1 = ref3.length; j < len1; j++) {
            token = ref3[j];
            if (selector.matches(token.scopes)) {
              return true;
            }
          }
        }
      }
      return false;
    };

    TokenizedBuffer.prototype.retokenizeLines = function() {
      if (!this.alive) {
        return;
      }
      this.fullyTokenized = false;
      this.tokenizedLines = new Array(this.buffer.getLineCount());
      this.invalidRows = [];
      if (this.largeFileMode || this.grammar.name === 'Null Grammar') {
        return this.markTokenizationComplete();
      } else {
        return this.invalidateRow(0);
      }
    };

    TokenizedBuffer.prototype.setVisible = function(visible) {
      this.visible = visible;
      if (this.visible && this.grammar.name !== 'Null Grammar' && !this.largeFileMode) {
        return this.tokenizeInBackground();
      }
    };

    TokenizedBuffer.prototype.getTabLength = function() {
      return this.tabLength;
    };

    TokenizedBuffer.prototype.setTabLength = function(tabLength) {
      this.tabLength = tabLength;
    };

    TokenizedBuffer.prototype.tokenizeInBackground = function() {
      if (!this.visible || this.pendingChunk || !this.isAlive()) {
        return;
      }
      this.pendingChunk = true;
      return _.defer((function(_this) {
        return function() {
          _this.pendingChunk = false;
          if (_this.isAlive() && _this.buffer.isAlive()) {
            return _this.tokenizeNextChunk();
          }
        };
      })(this));
    };

    TokenizedBuffer.prototype.tokenizeNextChunk = function() {
      var endRow, filledRegion, lastRow, previousStack, row, rowsRemaining, startRow;
      rowsRemaining = this.chunkSize;
      while ((this.firstInvalidRow() != null) && rowsRemaining > 0) {
        startRow = this.invalidRows.shift();
        lastRow = this.getLastRow();
        if (startRow > lastRow) {
          continue;
        }
        row = startRow;
        while (true) {
          previousStack = this.stackForRow(row);
          this.tokenizedLines[row] = this.buildTokenizedLineForRow(row, this.stackForRow(row - 1), this.openScopesForRow(row));
          if (--rowsRemaining === 0) {
            filledRegion = false;
            endRow = row;
            break;
          }
          if (row === lastRow || _.isEqual(this.stackForRow(row), previousStack)) {
            filledRegion = true;
            endRow = row;
            break;
          }
          row++;
        }
        this.validateRow(endRow);
        if (!filledRegion) {
          this.invalidateRow(endRow + 1);
        }
        this.emitter.emit('did-invalidate-range', Range(Point(startRow, 0), Point(endRow + 1, 0)));
      }
      if (this.firstInvalidRow() != null) {
        return this.tokenizeInBackground();
      } else {
        return this.markTokenizationComplete();
      }
    };

    TokenizedBuffer.prototype.markTokenizationComplete = function() {
      if (!this.fullyTokenized) {
        this.emitter.emit('did-tokenize');
      }
      return this.fullyTokenized = true;
    };

    TokenizedBuffer.prototype.firstInvalidRow = function() {
      return this.invalidRows[0];
    };

    TokenizedBuffer.prototype.validateRow = function(row) {
      while (this.invalidRows[0] <= row) {
        this.invalidRows.shift();
      }
    };

    TokenizedBuffer.prototype.invalidateRow = function(row) {
      this.invalidRows.push(row);
      this.invalidRows.sort(function(a, b) {
        return a - b;
      });
      return this.tokenizeInBackground();
    };

    TokenizedBuffer.prototype.updateInvalidRows = function(start, end, delta) {
      return this.invalidRows = this.invalidRows.map(function(row) {
        if (row < start) {
          return row;
        } else if ((start <= row && row <= end)) {
          return end + delta + 1;
        } else if (row > end) {
          return row + delta;
        }
      });
    };

    TokenizedBuffer.prototype.bufferDidChange = function(e) {
      var delta, end, newEndStack, newLineCount, newRange, newTokenizedLines, oldLineCount, oldRange, previousEndStack, start;
      this.changeCount = this.buffer.changeCount;
      oldRange = e.oldRange, newRange = e.newRange;
      start = oldRange.start.row;
      end = oldRange.end.row;
      delta = newRange.end.row - oldRange.end.row;
      oldLineCount = oldRange.end.row - oldRange.start.row + 1;
      newLineCount = newRange.end.row - newRange.start.row + 1;
      this.updateInvalidRows(start, end, delta);
      previousEndStack = this.stackForRow(end);
      if (this.largeFileMode || this.grammar.name === 'Null Grammar') {
        return _.spliceWithArray(this.tokenizedLines, start, oldLineCount, new Array(newLineCount));
      } else {
        newTokenizedLines = this.buildTokenizedLinesForRows(start, end + delta, this.stackForRow(start - 1), this.openScopesForRow(start));
        _.spliceWithArray(this.tokenizedLines, start, oldLineCount, newTokenizedLines);
        newEndStack = this.stackForRow(end + delta);
        if (newEndStack && !_.isEqual(newEndStack, previousEndStack)) {
          return this.invalidateRow(end + delta + 1);
        }
      }
    };

    TokenizedBuffer.prototype.isFoldableAtRow = function(row) {
      return this.isFoldableCodeAtRow(row) || this.isFoldableCommentAtRow(row);
    };

    TokenizedBuffer.prototype.isFoldableCodeAtRow = function(row) {
      var nextRow, tokenizedLine;
      if ((0 <= row && row <= this.buffer.getLastRow())) {
        nextRow = this.buffer.nextNonBlankRow(row);
        tokenizedLine = this.tokenizedLines[row];
        if (this.buffer.isRowBlank(row) || (tokenizedLine != null ? tokenizedLine.isComment() : void 0) || (nextRow == null)) {
          return false;
        } else {
          return this.indentLevelForRow(nextRow) > this.indentLevelForRow(row);
        }
      } else {
        return false;
      }
    };

    TokenizedBuffer.prototype.isFoldableCommentAtRow = function(row) {
      var nextRow, previousRow, ref2, ref3, ref4;
      previousRow = row - 1;
      nextRow = row + 1;
      if (nextRow > this.buffer.getLastRow()) {
        return false;
      } else {
        return Boolean(!((ref2 = this.tokenizedLines[previousRow]) != null ? ref2.isComment() : void 0) && ((ref3 = this.tokenizedLines[row]) != null ? ref3.isComment() : void 0) && ((ref4 = this.tokenizedLines[nextRow]) != null ? ref4.isComment() : void 0));
      }
    };

    TokenizedBuffer.prototype.buildTokenizedLinesForRows = function(startRow, endRow, startingStack, startingopenScopes) {
      var openScopes, row, ruleStack, stopTokenizingAt, tokenizedLine, tokenizedLines;
      ruleStack = startingStack;
      openScopes = startingopenScopes;
      stopTokenizingAt = startRow + this.chunkSize;
      tokenizedLines = (function() {
        var i, ref2, ref3, results;
        results = [];
        for (row = i = ref2 = startRow, ref3 = endRow; i <= ref3; row = i += 1) {
          if ((ruleStack || row === 0) && row < stopTokenizingAt) {
            tokenizedLine = this.buildTokenizedLineForRow(row, ruleStack, openScopes);
            ruleStack = tokenizedLine.ruleStack;
            openScopes = this.scopesFromTags(openScopes, tokenizedLine.tags);
          } else {
            tokenizedLine = void 0;
          }
          results.push(tokenizedLine);
        }
        return results;
      }).call(this);
      if (endRow >= stopTokenizingAt) {
        this.invalidateRow(stopTokenizingAt);
        this.tokenizeInBackground();
      }
      return tokenizedLines;
    };

    TokenizedBuffer.prototype.buildTokenizedLineForRow = function(row, ruleStack, openScopes) {
      return this.buildTokenizedLineForRowWithText(row, this.buffer.lineForRow(row), ruleStack, openScopes);
    };

    TokenizedBuffer.prototype.buildTokenizedLineForRowWithText = function(row, text, ruleStack, openScopes) {
      var lineEnding, ref2, tags;
      if (ruleStack == null) {
        ruleStack = this.stackForRow(row - 1);
      }
      if (openScopes == null) {
        openScopes = this.openScopesForRow(row);
      }
      lineEnding = this.buffer.lineEndingForRow(row);
      ref2 = this.grammar.tokenizeLine(text, ruleStack, row === 0, false), tags = ref2.tags, ruleStack = ref2.ruleStack;
      return new TokenizedLine({
        openScopes: openScopes,
        text: text,
        tags: tags,
        ruleStack: ruleStack,
        lineEnding: lineEnding,
        tokenIterator: this.tokenIterator,
        grammar: this.grammar
      });
    };

    TokenizedBuffer.prototype.tokenizedLineForRow = function(bufferRow) {
      var lineEnding, tags, text, tokenizedLine;
      if ((0 <= bufferRow && bufferRow <= this.buffer.getLastRow())) {
        if (tokenizedLine = this.tokenizedLines[bufferRow]) {
          return tokenizedLine;
        } else {
          text = this.buffer.lineForRow(bufferRow);
          lineEnding = this.buffer.lineEndingForRow(bufferRow);
          tags = [this.grammar.startIdForScope(this.grammar.scopeName), text.length, this.grammar.endIdForScope(this.grammar.scopeName)];
          return this.tokenizedLines[bufferRow] = new TokenizedLine({
            openScopes: [],
            text: text,
            tags: tags,
            lineEnding: lineEnding,
            tokenIterator: this.tokenIterator,
            grammar: this.grammar
          });
        }
      }
    };

    TokenizedBuffer.prototype.tokenizedLinesForRows = function(startRow, endRow) {
      var i, ref2, ref3, results, row;
      results = [];
      for (row = i = ref2 = startRow, ref3 = endRow; i <= ref3; row = i += 1) {
        results.push(this.tokenizedLineForRow(row));
      }
      return results;
    };

    TokenizedBuffer.prototype.stackForRow = function(bufferRow) {
      var ref2;
      return (ref2 = this.tokenizedLines[bufferRow]) != null ? ref2.ruleStack : void 0;
    };

    TokenizedBuffer.prototype.openScopesForRow = function(bufferRow) {
      var precedingLine;
      if (precedingLine = this.tokenizedLines[bufferRow - 1]) {
        return this.scopesFromTags(precedingLine.openScopes, precedingLine.tags);
      } else {
        return [];
      }
    };

    TokenizedBuffer.prototype.scopesFromTags = function(startingScopes, tags) {
      var i, len, matchingStartTag, scopes, tag;
      scopes = startingScopes.slice();
      for (i = 0, len = tags.length; i < len; i++) {
        tag = tags[i];
        if (tag < 0) {
          if ((tag % 2) === -1) {
            scopes.push(tag);
          } else {
            matchingStartTag = tag + 1;
            while (true) {
              if (scopes.pop() === matchingStartTag) {
                break;
              }
              if (scopes.length === 0) {
                this.assert(false, "Encountered an unmatched scope end tag.", (function(_this) {
                  return function(error) {
                    var path;
                    error.metadata = {
                      grammarScopeName: _this.grammar.scopeName,
                      unmatchedEndTag: _this.grammar.scopeForId(tag)
                    };
                    path = require('path');
                    error.privateMetadataDescription = "The contents of `" + (path.basename(_this.buffer.getPath())) + "`";
                    return error.privateMetadata = {
                      filePath: _this.buffer.getPath(),
                      fileContents: _this.buffer.getText()
                    };
                  };
                })(this));
                break;
              }
            }
          }
        }
      }
      return scopes;
    };

    TokenizedBuffer.prototype.indentLevelForRow = function(bufferRow) {
      var indentLevel, line, lineCount, nextLine, nextRow, previousLine, previousRow;
      line = this.buffer.lineForRow(bufferRow);
      indentLevel = 0;
      if (line === '') {
        nextRow = bufferRow + 1;
        lineCount = this.getLineCount();
        while (nextRow < lineCount) {
          nextLine = this.buffer.lineForRow(nextRow);
          if (nextLine !== '') {
            indentLevel = Math.ceil(this.indentLevelForLine(nextLine));
            break;
          }
          nextRow++;
        }
        previousRow = bufferRow - 1;
        while (previousRow >= 0) {
          previousLine = this.buffer.lineForRow(previousRow);
          if (previousLine !== '') {
            indentLevel = Math.max(Math.ceil(this.indentLevelForLine(previousLine)), indentLevel);
            break;
          }
          previousRow--;
        }
        return indentLevel;
      } else {
        return this.indentLevelForLine(line);
      }
    };

    TokenizedBuffer.prototype.indentLevelForLine = function(line) {
      var char, i, indentLength, len;
      indentLength = 0;
      for (i = 0, len = line.length; i < len; i++) {
        char = line[i];
        if (char === '\t') {
          indentLength += this.getTabLength() - (indentLength % this.getTabLength());
        } else if (char === ' ') {
          indentLength++;
        } else {
          break;
        }
      }
      return indentLength / this.getTabLength();
    };

    TokenizedBuffer.prototype.scopeDescriptorForPosition = function(position) {
      var column, iterator, ref2, row, scopes;
      ref2 = this.buffer.clipPosition(Point.fromObject(position)), row = ref2.row, column = ref2.column;
      iterator = this.tokenizedLineForRow(row).getTokenIterator();
      while (iterator.next()) {
        if (iterator.getBufferEnd() > column) {
          scopes = iterator.getScopes();
          break;
        }
      }
      if (scopes == null) {
        scopes = iterator.getScopes();
        scopes.push.apply(scopes, iterator.getScopeEnds().reverse());
      }
      return new ScopeDescriptor({
        scopes: scopes
      });
    };

    TokenizedBuffer.prototype.tokenForPosition = function(position) {
      var column, ref2, row;
      ref2 = Point.fromObject(position), row = ref2.row, column = ref2.column;
      return this.tokenizedLineForRow(row).tokenAtBufferColumn(column);
    };

    TokenizedBuffer.prototype.tokenStartPositionForPosition = function(position) {
      var column, ref2, row;
      ref2 = Point.fromObject(position), row = ref2.row, column = ref2.column;
      column = this.tokenizedLineForRow(row).tokenStartColumnForBufferColumn(column);
      return new Point(row, column);
    };

    TokenizedBuffer.prototype.bufferRangeForScopeAtPosition = function(selector, position) {
      var endColumn, endScopes, endTokenIndex, i, j, k, len, openScopes, ref2, ref3, ref4, ref5, scopes, startColumn, startScopes, startTokenIndex, tag, tags, tokenIndex;
      position = Point.fromObject(position);
      ref2 = this.tokenizedLineForRow(position.row), openScopes = ref2.openScopes, tags = ref2.tags;
      scopes = openScopes.map((function(_this) {
        return function(tag) {
          return _this.grammar.scopeForId(tag);
        };
      })(this));
      startColumn = 0;
      for (tokenIndex = i = 0, len = tags.length; i < len; tokenIndex = ++i) {
        tag = tags[tokenIndex];
        if (tag < 0) {
          if (tag % 2 === -1) {
            scopes.push(this.grammar.scopeForId(tag));
          } else {
            scopes.pop();
          }
        } else {
          endColumn = startColumn + tag;
          if (endColumn >= position.column) {
            break;
          } else {
            startColumn = endColumn;
          }
        }
      }
      if (!selectorMatchesAnyScope(selector, scopes)) {
        return;
      }
      startScopes = scopes.slice();
      for (startTokenIndex = j = ref3 = tokenIndex - 1; j >= 0; startTokenIndex = j += -1) {
        tag = tags[startTokenIndex];
        if (tag < 0) {
          if (tag % 2 === -1) {
            startScopes.pop();
          } else {
            startScopes.push(this.grammar.scopeForId(tag));
          }
        } else {
          if (!selectorMatchesAnyScope(selector, startScopes)) {
            break;
          }
          startColumn -= tag;
        }
      }
      endScopes = scopes.slice();
      for (endTokenIndex = k = ref4 = tokenIndex + 1, ref5 = tags.length; k < ref5; endTokenIndex = k += 1) {
        tag = tags[endTokenIndex];
        if (tag < 0) {
          if (tag % 2 === -1) {
            endScopes.push(this.grammar.scopeForId(tag));
          } else {
            endScopes.pop();
          }
        } else {
          if (!selectorMatchesAnyScope(selector, endScopes)) {
            break;
          }
          endColumn += tag;
        }
      }
      return new Range(new Point(position.row, startColumn), new Point(position.row, endColumn));
    };

    TokenizedBuffer.prototype.getLastRow = function() {
      return this.buffer.getLastRow();
    };

    TokenizedBuffer.prototype.getLineCount = function() {
      return this.buffer.getLineCount();
    };

    TokenizedBuffer.prototype.logLines = function(start, end) {
      var i, line, ref2, ref3, row;
      if (start == null) {
        start = 0;
      }
      if (end == null) {
        end = this.buffer.getLastRow();
      }
      for (row = i = ref2 = start, ref3 = end; ref2 <= ref3 ? i <= ref3 : i >= ref3; row = ref2 <= ref3 ? ++i : --i) {
        line = this.tokenizedLines[row].text;
        console.log(row, line, line.length);
      }
    };

    return TokenizedBuffer;

  })(Model);

  selectorMatchesAnyScope = function(selector, scopes) {
    var targetClasses;
    targetClasses = selector.replace(/^\./, '').split('.');
    return _.any(scopes, function(scope) {
      var scopeClasses;
      scopeClasses = scope.split('.');
      return _.isSubset(targetClasses, scopeClasses);
    });
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
