(function() {
  var CompositeDisposable, PaneElement, path,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  path = require('path');

  CompositeDisposable = require('event-kit').CompositeDisposable;

  PaneElement = (function(superClass) {
    extend(PaneElement, superClass);

    function PaneElement() {
      return PaneElement.__super__.constructor.apply(this, arguments);
    }

    PaneElement.prototype.attached = false;

    PaneElement.prototype.createdCallback = function() {
      this.attached = false;
      this.subscriptions = new CompositeDisposable;
      this.inlineDisplayStyles = new WeakMap;
      this.initializeContent();
      return this.subscribeToDOMEvents();
    };

    PaneElement.prototype.attachedCallback = function() {
      this.attached = true;
      if (this.model.isFocused()) {
        return this.focus();
      }
    };

    PaneElement.prototype.detachedCallback = function() {
      return this.attached = false;
    };

    PaneElement.prototype.initializeContent = function() {
      this.setAttribute('class', 'pane');
      this.setAttribute('tabindex', -1);
      this.appendChild(this.itemViews = document.createElement('div'));
      return this.itemViews.setAttribute('class', 'item-views');
    };

    PaneElement.prototype.subscribeToDOMEvents = function() {
      var handleBlur, handleDragOver, handleDrop, handleFocus;
      handleFocus = (function(_this) {
        return function(event) {
          var view;
          if (!(_this.isActivating || _this.model.isDestroyed() || _this.contains(event.relatedTarget))) {
            _this.model.focus();
          }
          if (event.target === _this && (view = _this.getActiveView())) {
            view.focus();
            return event.stopPropagation();
          }
        };
      })(this);
      handleBlur = (function(_this) {
        return function(event) {
          if (!_this.contains(event.relatedTarget)) {
            return _this.model.blur();
          }
        };
      })(this);
      handleDragOver = function(event) {
        event.preventDefault();
        return event.stopPropagation();
      };
      handleDrop = (function(_this) {
        return function(event) {
          var pathsToOpen;
          event.preventDefault();
          event.stopPropagation();
          _this.getModel().activate();
          pathsToOpen = Array.prototype.map.call(event.dataTransfer.files, function(file) {
            return file.path;
          });
          if (pathsToOpen.length > 0) {
            return _this.applicationDelegate.open({
              pathsToOpen: pathsToOpen
            });
          }
        };
      })(this);
      this.addEventListener('focus', handleFocus, true);
      this.addEventListener('blur', handleBlur, true);
      this.addEventListener('dragover', handleDragOver);
      return this.addEventListener('drop', handleDrop);
    };

    PaneElement.prototype.initialize = function(model, arg) {
      this.model = model;
      this.views = arg.views, this.applicationDelegate = arg.applicationDelegate;
      if (this.views == null) {
        throw new Error("Must pass a views parameter when initializing PaneElements");
      }
      if (this.applicationDelegate == null) {
        throw new Error("Must pass an applicationDelegate parameter when initializing PaneElements");
      }
      this.subscriptions.add(this.model.onDidActivate(this.activated.bind(this)));
      this.subscriptions.add(this.model.observeActive(this.activeStatusChanged.bind(this)));
      this.subscriptions.add(this.model.observeActiveItem(this.activeItemChanged.bind(this)));
      this.subscriptions.add(this.model.onDidRemoveItem(this.itemRemoved.bind(this)));
      this.subscriptions.add(this.model.onDidDestroy(this.paneDestroyed.bind(this)));
      this.subscriptions.add(this.model.observeFlexScale(this.flexScaleChanged.bind(this)));
      return this;
    };

    PaneElement.prototype.getModel = function() {
      return this.model;
    };

    PaneElement.prototype.activated = function() {
      this.isActivating = true;
      if (!this.hasFocus()) {
        this.focus();
      }
      return this.isActivating = false;
    };

    PaneElement.prototype.activeStatusChanged = function(active) {
      if (active) {
        return this.classList.add('active');
      } else {
        return this.classList.remove('active');
      }
    };

    PaneElement.prototype.activeItemChanged = function(item) {
      var child, hasFocus, i, itemPath, itemView, len, ref;
      delete this.dataset.activeItemName;
      delete this.dataset.activeItemPath;
      if (item == null) {
        return;
      }
      hasFocus = this.hasFocus();
      itemView = this.views.getView(item);
      if (itemPath = typeof item.getPath === "function" ? item.getPath() : void 0) {
        this.dataset.activeItemName = path.basename(itemPath);
        this.dataset.activeItemPath = itemPath;
      }
      if (!this.itemViews.contains(itemView)) {
        this.itemViews.appendChild(itemView);
      }
      ref = this.itemViews.children;
      for (i = 0, len = ref.length; i < len; i++) {
        child = ref[i];
        if (child === itemView) {
          if (this.attached) {
            this.showItemView(child);
          }
        } else {
          this.hideItemView(child);
        }
      }
      if (hasFocus) {
        return itemView.focus();
      }
    };

    PaneElement.prototype.showItemView = function(itemView) {
      var inlineDisplayStyle;
      inlineDisplayStyle = this.inlineDisplayStyles.get(itemView);
      if (inlineDisplayStyle != null) {
        return itemView.style.display = inlineDisplayStyle;
      } else {
        return itemView.style.display = '';
      }
    };

    PaneElement.prototype.hideItemView = function(itemView) {
      var inlineDisplayStyle;
      inlineDisplayStyle = itemView.style.display;
      if (inlineDisplayStyle !== 'none') {
        if (inlineDisplayStyle != null) {
          this.inlineDisplayStyles.set(itemView, inlineDisplayStyle);
        }
        return itemView.style.display = 'none';
      }
    };

    PaneElement.prototype.itemRemoved = function(arg) {
      var destroyed, index, item, viewToRemove;
      item = arg.item, index = arg.index, destroyed = arg.destroyed;
      if (viewToRemove = this.views.getView(item)) {
        return viewToRemove.remove();
      }
    };

    PaneElement.prototype.paneDestroyed = function() {
      return this.subscriptions.dispose();
    };

    PaneElement.prototype.flexScaleChanged = function(flexScale) {
      return this.style.flexGrow = flexScale;
    };

    PaneElement.prototype.getActiveView = function() {
      return this.views.getView(this.model.getActiveItem());
    };

    PaneElement.prototype.hasFocus = function() {
      return this === document.activeElement || this.contains(document.activeElement);
    };

    return PaneElement;

  })(HTMLElement);

  module.exports = PaneElement = document.registerElement('atom-pane', {
    prototype: PaneElement.prototype
  });

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
