(function() {
  var CompositeDisposable, Emitter, Model, PaneAxis, PaneAxisElement, flatten, ref,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  ref = require('event-kit'), Emitter = ref.Emitter, CompositeDisposable = ref.CompositeDisposable;

  flatten = require('underscore-plus').flatten;

  Model = require('./model');

  PaneAxisElement = require('./pane-axis-element');

  module.exports = PaneAxis = (function(superClass) {
    extend(PaneAxis, superClass);

    PaneAxis.prototype.parent = null;

    PaneAxis.prototype.container = null;

    PaneAxis.prototype.orientation = null;

    PaneAxis.deserialize = function(state, arg) {
      var deserializers, views;
      deserializers = arg.deserializers, views = arg.views;
      state.children = state.children.map(function(childState) {
        return deserializers.deserialize(childState);
      });
      return new this(state, views);
    };

    function PaneAxis(arg, viewRegistry) {
      var child, children, flexScale, i, len;
      this.orientation = arg.orientation, children = arg.children, flexScale = arg.flexScale;
      this.viewRegistry = viewRegistry;
      this.emitter = new Emitter;
      this.subscriptionsByChild = new WeakMap;
      this.subscriptions = new CompositeDisposable;
      this.children = [];
      if (children != null) {
        for (i = 0, len = children.length; i < len; i++) {
          child = children[i];
          this.addChild(child);
        }
      }
      this.flexScale = flexScale != null ? flexScale : 1;
    }

    PaneAxis.prototype.serialize = function() {
      return {
        deserializer: 'PaneAxis',
        children: this.children.map(function(child) {
          return child.serialize();
        }),
        orientation: this.orientation,
        flexScale: this.flexScale
      };
    };

    PaneAxis.prototype.getElement = function() {
      return this.element != null ? this.element : this.element = new PaneAxisElement().initialize(this, this.viewRegistry);
    };

    PaneAxis.prototype.getFlexScale = function() {
      return this.flexScale;
    };

    PaneAxis.prototype.setFlexScale = function(flexScale1) {
      this.flexScale = flexScale1;
      this.emitter.emit('did-change-flex-scale', this.flexScale);
      return this.flexScale;
    };

    PaneAxis.prototype.getParent = function() {
      return this.parent;
    };

    PaneAxis.prototype.setParent = function(parent) {
      this.parent = parent;
      return this.parent;
    };

    PaneAxis.prototype.getContainer = function() {
      return this.container;
    };

    PaneAxis.prototype.setContainer = function(container) {
      var child, i, len, ref1, results;
      if (container && container !== this.container) {
        this.container = container;
        ref1 = this.children;
        results = [];
        for (i = 0, len = ref1.length; i < len; i++) {
          child = ref1[i];
          results.push(child.setContainer(container));
        }
        return results;
      }
    };

    PaneAxis.prototype.getOrientation = function() {
      return this.orientation;
    };

    PaneAxis.prototype.getChildren = function() {
      return this.children.slice();
    };

    PaneAxis.prototype.getPanes = function() {
      return flatten(this.children.map(function(child) {
        return child.getPanes();
      }));
    };

    PaneAxis.prototype.getItems = function() {
      return flatten(this.children.map(function(child) {
        return child.getItems();
      }));
    };

    PaneAxis.prototype.onDidAddChild = function(fn) {
      return this.emitter.on('did-add-child', fn);
    };

    PaneAxis.prototype.onDidRemoveChild = function(fn) {
      return this.emitter.on('did-remove-child', fn);
    };

    PaneAxis.prototype.onDidReplaceChild = function(fn) {
      return this.emitter.on('did-replace-child', fn);
    };

    PaneAxis.prototype.onDidDestroy = function(fn) {
      return this.emitter.on('did-destroy', fn);
    };

    PaneAxis.prototype.onDidChangeFlexScale = function(fn) {
      return this.emitter.on('did-change-flex-scale', fn);
    };

    PaneAxis.prototype.observeFlexScale = function(fn) {
      fn(this.flexScale);
      return this.onDidChangeFlexScale(fn);
    };

    PaneAxis.prototype.addChild = function(child, index) {
      if (index == null) {
        index = this.children.length;
      }
      this.children.splice(index, 0, child);
      child.setParent(this);
      child.setContainer(this.container);
      this.subscribeToChild(child);
      return this.emitter.emit('did-add-child', {
        child: child,
        index: index
      });
    };

    PaneAxis.prototype.adjustFlexScale = function() {
      var child, i, j, len, len1, needTotal, ref1, ref2, results, total;
      total = 0;
      ref1 = this.children;
      for (i = 0, len = ref1.length; i < len; i++) {
        child = ref1[i];
        total += child.getFlexScale();
      }
      needTotal = this.children.length;
      ref2 = this.children;
      results = [];
      for (j = 0, len1 = ref2.length; j < len1; j++) {
        child = ref2[j];
        results.push(child.setFlexScale(needTotal * child.getFlexScale() / total));
      }
      return results;
    };

    PaneAxis.prototype.removeChild = function(child, replacing) {
      var index;
      if (replacing == null) {
        replacing = false;
      }
      index = this.children.indexOf(child);
      if (index === -1) {
        throw new Error("Removing non-existent child");
      }
      this.unsubscribeFromChild(child);
      this.children.splice(index, 1);
      this.adjustFlexScale();
      this.emitter.emit('did-remove-child', {
        child: child,
        index: index
      });
      if (!replacing && this.children.length < 2) {
        return this.reparentLastChild();
      }
    };

    PaneAxis.prototype.replaceChild = function(oldChild, newChild) {
      var index;
      this.unsubscribeFromChild(oldChild);
      this.subscribeToChild(newChild);
      newChild.setParent(this);
      newChild.setContainer(this.container);
      index = this.children.indexOf(oldChild);
      this.children.splice(index, 1, newChild);
      return this.emitter.emit('did-replace-child', {
        oldChild: oldChild,
        newChild: newChild,
        index: index
      });
    };

    PaneAxis.prototype.insertChildBefore = function(currentChild, newChild) {
      var index;
      index = this.children.indexOf(currentChild);
      return this.addChild(newChild, index);
    };

    PaneAxis.prototype.insertChildAfter = function(currentChild, newChild) {
      var index;
      index = this.children.indexOf(currentChild);
      return this.addChild(newChild, index + 1);
    };

    PaneAxis.prototype.reparentLastChild = function() {
      var lastChild;
      lastChild = this.children[0];
      lastChild.setFlexScale(this.flexScale);
      this.parent.replaceChild(this, lastChild);
      return this.destroy();
    };

    PaneAxis.prototype.subscribeToChild = function(child) {
      var subscription;
      subscription = child.onDidDestroy((function(_this) {
        return function() {
          return _this.removeChild(child);
        };
      })(this));
      this.subscriptionsByChild.set(child, subscription);
      return this.subscriptions.add(subscription);
    };

    PaneAxis.prototype.unsubscribeFromChild = function(child) {
      var subscription;
      subscription = this.subscriptionsByChild.get(child);
      this.subscriptions.remove(subscription);
      return subscription.dispose();
    };

    PaneAxis.prototype.destroyed = function() {
      this.subscriptions.dispose();
      this.emitter.emit('did-destroy');
      return this.emitter.dispose();
    };

    return PaneAxis;

  })(Model);

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
