(function() {
  var ElementResizeDetector, OverlayManager, elementResizeDetector;

  ElementResizeDetector = require('element-resize-detector');

  elementResizeDetector = null;

  module.exports = OverlayManager = (function() {
    function OverlayManager(presenter, container, views) {
      this.presenter = presenter;
      this.container = container;
      this.views = views;
      this.overlaysById = {};
    }

    OverlayManager.prototype.render = function(state) {
      var decorationId, id, overlay, overlayNode, ref, ref1, results;
      ref = state.content.overlays;
      for (decorationId in ref) {
        overlay = ref[decorationId];
        if (this.shouldUpdateOverlay(decorationId, overlay)) {
          this.renderOverlay(state, decorationId, overlay);
        }
      }
      ref1 = this.overlaysById;
      results = [];
      for (id in ref1) {
        overlayNode = ref1[id].overlayNode;
        if (!state.content.overlays.hasOwnProperty(id)) {
          delete this.overlaysById[id];
          overlayNode.remove();
          results.push(elementResizeDetector.uninstall(overlayNode));
        } else {
          results.push(void 0);
        }
      }
      return results;
    };

    OverlayManager.prototype.shouldUpdateOverlay = function(decorationId, overlay) {
      var cachedOverlay, ref, ref1, ref2, ref3;
      cachedOverlay = this.overlaysById[decorationId];
      if (cachedOverlay == null) {
        return true;
      }
      return ((ref = cachedOverlay.pixelPosition) != null ? ref.top : void 0) !== ((ref1 = overlay.pixelPosition) != null ? ref1.top : void 0) || ((ref2 = cachedOverlay.pixelPosition) != null ? ref2.left : void 0) !== ((ref3 = overlay.pixelPosition) != null ? ref3.left : void 0);
    };

    OverlayManager.prototype.measureOverlay = function(decorationId, itemView) {
      var contentMargin, ref;
      contentMargin = (ref = parseInt(getComputedStyle(itemView)['margin-left'])) != null ? ref : 0;
      return this.presenter.setOverlayDimensions(decorationId, itemView.offsetWidth, itemView.offsetHeight, contentMargin);
    };

    OverlayManager.prototype.renderOverlay = function(state, decorationId, arg) {
      var cachedOverlay, item, itemView, klass, overlayNode, pixelPosition;
      item = arg.item, pixelPosition = arg.pixelPosition, klass = arg["class"];
      itemView = this.views.getView(item);
      cachedOverlay = this.overlaysById[decorationId];
      if (!(overlayNode = cachedOverlay != null ? cachedOverlay.overlayNode : void 0)) {
        overlayNode = document.createElement('atom-overlay');
        if (klass != null) {
          overlayNode.classList.add(klass);
        }
        if (elementResizeDetector == null) {
          elementResizeDetector = ElementResizeDetector({
            strategy: 'scroll'
          });
        }
        elementResizeDetector.listenTo(overlayNode, (function(_this) {
          return function() {
            if (overlayNode.parentElement != null) {
              return _this.measureOverlay(decorationId, itemView);
            }
          };
        })(this));
        this.container.appendChild(overlayNode);
        this.overlaysById[decorationId] = cachedOverlay = {
          overlayNode: overlayNode,
          itemView: itemView
        };
      }
      if (!overlayNode.contains(itemView)) {
        overlayNode.appendChild(itemView);
      }
      cachedOverlay.pixelPosition = pixelPosition;
      overlayNode.style.top = pixelPosition.top + 'px';
      overlayNode.style.left = pixelPosition.left + 'px';
      return this.measureOverlay(decorationId, itemView);
    };

    return OverlayManager;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
