Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _child_process = require('child_process');

var _child_process2 = _interopRequireDefault(_child_process);

var _eventKit = require('event-kit');

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

// Extended: A wrapper which provides standard error/output line buffering for
// Node's ChildProcess.
//
// ## Examples
//
// ```js
// {BufferedProcess} = require('atom')
//
// const command = 'ps'
// const args = ['-ef']
// const stdout = (output) => console.log(output)
// const exit = (code) => console.log("ps -ef exited with #{code}")
// const process = new BufferedProcess({command, args, stdout, exit})
// ```

var BufferedProcess = (function () {
  /*
  Section: Construction
  */

  // Public: Runs the given command by spawning a new child process.
  //
  // * `options` An {Object} with the following keys:
  //   * `command` The {String} command to execute.
  //   * `args` The {Array} of arguments to pass to the command (optional).
  //   * `options` {Object} (optional) The options {Object} to pass to Node's
  //     `ChildProcess.spawn` method.
  //   * `stdout` {Function} (optional) The callback that receives a single
  //     argument which contains the standard output from the command. The
  //     callback is called as data is received but it's buffered to ensure only
  //     complete lines are passed until the source stream closes. After the
  //     source stream has closed all remaining data is sent in a final call.
  //     * `data` {String}
  //   * `stderr` {Function} (optional) The callback that receives a single
  //     argument which contains the standard error output from the command. The
  //     callback is called as data is received but it's buffered to ensure only
  //     complete lines are passed until the source stream closes. After the
  //     source stream has closed all remaining data is sent in a final call.
  //     * `data` {String}
  //   * `exit` {Function} (optional) The callback which receives a single
  //     argument containing the exit status.
  //     * `code` {Number}
  //   * `autoStart` {Boolean} (optional) Whether the command will automatically start
  //     when this BufferedProcess is created. Defaults to true.  When set to false you
  //     must call the `start` method to start the process.

  function BufferedProcess() {
    var _ref = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

    var command = _ref.command;
    var args = _ref.args;
    var _ref$options = _ref.options;
    var options = _ref$options === undefined ? {} : _ref$options;
    var stdout = _ref.stdout;
    var stderr = _ref.stderr;
    var exit = _ref.exit;
    var _ref$autoStart = _ref.autoStart;
    var autoStart = _ref$autoStart === undefined ? true : _ref$autoStart;

    _classCallCheck(this, BufferedProcess);

    this.emitter = new _eventKit.Emitter();
    this.command = command;
    this.args = args;
    this.options = options;
    this.stdout = stdout;
    this.stderr = stderr;
    this.exit = exit;
    if (autoStart === true) {
      this.start();
    }
    this.killed = false;
  }

  _createClass(BufferedProcess, [{
    key: 'start',
    value: function start() {
      if (this.started === true) return;

      this.started = true;
      // Related to joyent/node#2318
      if (process.platform === 'win32' && this.options.shell === undefined) {
        this.spawnWithEscapedWindowsArgs(this.command, this.args, this.options);
      } else {
        this.spawn(this.command, this.args, this.options);
      }
      this.handleEvents(this.stdout, this.stderr, this.exit);
    }

    // Windows has a bunch of special rules that node still doesn't take care of for you
  }, {
    key: 'spawnWithEscapedWindowsArgs',
    value: function spawnWithEscapedWindowsArgs(command, args, options) {
      var _this = this;

      var cmdArgs = [];
      // Quote all arguments and escapes inner quotes
      if (args) {
        cmdArgs = args.filter(function (arg) {
          return arg != null;
        }).map(function (arg) {
          if (_this.isExplorerCommand(command) && /^\/[a-zA-Z]+,.*$/.test(arg)) {
            // Don't wrap /root,C:\folder style arguments to explorer calls in
            // quotes since they will not be interpreted correctly if they are
            return arg;
          } else {
            // Escape double quotes by putting a backslash in front of them
            return '"' + arg.toString().replace(/"/g, '\\"') + '"';
          }
        });
      }

      // The command itself is quoted if it contains spaces, &, ^, | or # chars
      cmdArgs.unshift(/\s|&|\^|\(|\)|\||#/.test(command) ? '"' + command + '"' : command);

      var cmdOptions = _underscorePlus2['default'].clone(options);
      cmdOptions.windowsVerbatimArguments = true;

      this.spawn(this.getCmdPath(), ['/s', '/d', '/c', '"' + cmdArgs.join(' ') + '"'], cmdOptions);
    }

    /*
    Section: Event Subscription
    */

    // Public: Will call your callback when an error will be raised by the process.
    // Usually this is due to the command not being available or not on the PATH.
    // You can call `handle()` on the object passed to your callback to indicate
    // that you have handled this error.
    //
    // * `callback` {Function} callback
    //   * `errorObject` {Object}
    //     * `error` {Object} the error object
    //     * `handle` {Function} call this to indicate you have handled the error.
    //       The error will not be thrown if this function is called.
    //
    // Returns a {Disposable}
  }, {
    key: 'onWillThrowError',
    value: function onWillThrowError(callback) {
      return this.emitter.on('will-throw-error', callback);
    }

    /*
    Section: Helper Methods
    */

    // Helper method to pass data line by line.
    //
    // * `stream` The Stream to read from.
    // * `onLines` The callback to call with each line of data.
    // * `onDone` The callback to call when the stream has closed.
  }, {
    key: 'bufferStream',
    value: function bufferStream(stream, onLines, onDone) {
      var _this2 = this;

      stream.setEncoding('utf8');
      var buffered = '';

      stream.on('data', function (data) {
        if (_this2.killed) return;

        var bufferedLength = buffered.length;
        buffered += data;
        var lastNewlineIndex = data.lastIndexOf('\n');

        if (lastNewlineIndex !== -1) {
          var lineLength = lastNewlineIndex + bufferedLength + 1;
          onLines(buffered.substring(0, lineLength));
          buffered = buffered.substring(lineLength);
        }
      });

      stream.on('close', function () {
        if (_this2.killed) return;
        if (buffered.length > 0) onLines(buffered);
        onDone();
      });
    }

    // Kill all child processes of the spawned cmd.exe process on Windows.
    //
    // This is required since killing the cmd.exe does not terminate child
    // processes.
  }, {
    key: 'killOnWindows',
    value: function killOnWindows() {
      var _this3 = this;

      if (!this.process) return;

      var parentPid = this.process.pid;
      var cmd = 'wmic';
      var args = ['process', 'where', '(ParentProcessId=' + parentPid + ')', 'get', 'processid'];

      var wmicProcess = undefined;

      try {
        wmicProcess = _child_process2['default'].spawn(cmd, args);
      } catch (spawnError) {
        this.killProcess();
        return;
      }

      wmicProcess.on('error', function () {}); // ignore errors

      var output = '';
      wmicProcess.stdout.on('data', function (data) {
        output += data;
      });
      wmicProcess.stdout.on('close', function () {
        var pidsToKill = output.split(/\s+/).filter(function (pid) {
          return (/^\d+$/.test(pid)
          );
        }).map(function (pid) {
          return parseInt(pid);
        }).filter(function (pid) {
          return pid !== parentPid && pid > 0 && pid < Infinity;
        });

        for (var pid of pidsToKill) {
          try {
            process.kill(pid);
          } catch (error) {}
        }

        _this3.killProcess();
      });
    }
  }, {
    key: 'killProcess',
    value: function killProcess() {
      if (this.process) this.process.kill();
      this.process = null;
    }
  }, {
    key: 'isExplorerCommand',
    value: function isExplorerCommand(command) {
      if (command === 'explorer.exe' || command === 'explorer') {
        return true;
      } else if (process.env.SystemRoot) {
        return command === _path2['default'].join(process.env.SystemRoot, 'explorer.exe') || command === _path2['default'].join(process.env.SystemRoot, 'explorer');
      } else {
        return false;
      }
    }
  }, {
    key: 'getCmdPath',
    value: function getCmdPath() {
      if (process.env.comspec) {
        return process.env.comspec;
      } else if (process.env.SystemRoot) {
        return _path2['default'].join(process.env.SystemRoot, 'System32', 'cmd.exe');
      } else {
        return 'cmd.exe';
      }
    }

    // Public: Terminate the process.
  }, {
    key: 'kill',
    value: function kill() {
      if (this.killed) return;

      this.killed = true;
      if (process.platform === 'win32') {
        this.killOnWindows();
      } else {
        this.killProcess();
      }
    }
  }, {
    key: 'spawn',
    value: function spawn(command, args, options) {
      var _this4 = this;

      try {
        this.process = _child_process2['default'].spawn(command, args, options);
      } catch (spawnError) {
        process.nextTick(function () {
          return _this4.handleError(spawnError);
        });
      }
    }
  }, {
    key: 'handleEvents',
    value: function handleEvents(stdout, stderr, exit) {
      var _this5 = this;

      if (!this.process) return;

      var triggerExitCallback = function triggerExitCallback() {
        if (_this5.killed) return;
        if (stdoutClosed && stderrClosed && processExited && typeof exit === 'function') {
          exit(exitCode);
        }
      };

      var stdoutClosed = true;
      var stderrClosed = true;
      var processExited = true;
      var exitCode = 0;

      if (stdout) {
        stdoutClosed = false;
        this.bufferStream(this.process.stdout, stdout, function () {
          stdoutClosed = true;
          triggerExitCallback();
        });
      }

      if (stderr) {
        stderrClosed = false;
        this.bufferStream(this.process.stderr, stderr, function () {
          stderrClosed = true;
          triggerExitCallback();
        });
      }

      if (exit) {
        processExited = false;
        this.process.on('exit', function (code) {
          exitCode = code;
          processExited = true;
          triggerExitCallback();
        });
      }

      this.process.on('error', function (error) {
        _this5.handleError(error);
      });
    }
  }, {
    key: 'handleError',
    value: function handleError(error) {
      var handled = false;

      var handle = function handle() {
        handled = true;
      };

      this.emitter.emit('will-throw-error', { error: error, handle: handle });

      if (error.code === 'ENOENT' && error.syscall.indexOf('spawn') === 0) {
        error = new Error('Failed to spawn command `' + this.command + '`. Make sure `' + this.command + '` is installed and on your PATH', error.path);
        error.name = 'BufferedProcessError';
      }

      if (!handled) throw error;
    }
  }]);

  return BufferedProcess;
})();

exports['default'] = BufferedProcess;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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