Object.defineProperty(exports, '__esModule', {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom **/

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var GuideView = (function () {
  function GuideView(props) {
    _classCallCheck(this, GuideView);

    this.props = props;
    this.didClickProjectButton = this.didClickProjectButton.bind(this);
    this.didClickGitButton = this.didClickGitButton.bind(this);
    this.didClickGitHubButton = this.didClickGitHubButton.bind(this);
    this.didClickPackagesButton = this.didClickPackagesButton.bind(this);
    this.didClickThemesButton = this.didClickThemesButton.bind(this);
    this.didClickStylingButton = this.didClickStylingButton.bind(this);
    this.didClickInitScriptButton = this.didClickInitScriptButton.bind(this);
    this.didClickSnippetsButton = this.didClickSnippetsButton.bind(this);
    this.didExpandOrCollapseSection = this.didExpandOrCollapseSection.bind(this);
    _etch2['default'].initialize(this);
  }

  _createClass(GuideView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'welcome is-guide' },
        _etch2['default'].dom(
          'div',
          { className: 'welcome-container' },
          _etch2['default'].dom(
            'section',
            { className: 'welcome-panel' },
            _etch2['default'].dom(
              'h1',
              { className: 'welcome-title' },
              'Get to know Atom!'
            ),
            _etch2['default'].dom(
              'details',
              _extends({ className: 'welcome-card' }, this.getSectionProps('project')),
              _etch2['default'].dom(
                'summary',
                { className: 'welcome-summary icon icon-repo' },
                'Open a ',
                _etch2['default'].dom(
                  'span',
                  { className: 'welcome-highlight' },
                  'Project'
                )
              ),
              _etch2['default'].dom(
                'div',
                { className: 'welcome-detail' },
                _etch2['default'].dom(
                  'p',
                  null,
                  _etch2['default'].dom('img', { className: 'welcome-img', src: 'atom://welcome/assets/project.svg' })
                ),
                _etch2['default'].dom(
                  'p',
                  null,
                  'In Atom you can open individual files or a whole folder as a project. Opening a folder will add a tree view to the editor where you can browse all the files.'
                ),
                _etch2['default'].dom(
                  'p',
                  null,
                  _etch2['default'].dom(
                    'button',
                    { ref: 'projectButton', onclick: this.didClickProjectButton, className: 'btn btn-primary' },
                    'Open a Project'
                  )
                ),
                _etch2['default'].dom(
                  'p',
                  { className: 'welcome-note' },
                  _etch2['default'].dom(
                    'strong',
                    null,
                    'Next time:'
                  ),
                  ' You can also open projects from the menu, keyboard shortcut or by dragging a folder onto the Atom dock icon.'
                )
              )
            ),
            _etch2['default'].dom(
              'details',
              _extends({ className: 'welcome-card' }, this.getSectionProps('git')),
              _etch2['default'].dom(
                'summary',
                { className: 'welcome-summary icon icon-mark-github' },
                'Version control with ',
                _etch2['default'].dom(
                  'span',
                  { 'class': 'welcome-highlight' },
                  'Git and GitHub'
                )
              ),
              _etch2['default'].dom(
                'div',
                { className: 'welcome-detail' },
                _etch2['default'].dom(
                  'p',
                  null,
                  _etch2['default'].dom('img', { className: 'welcome-img', src: 'atom://welcome/assets/package.svg' })
                ),
                _etch2['default'].dom(
                  'p',
                  null,
                  'Track changes to your code as you work. Branch, commit, push, and pull without leaving the comfort of your editor. Collaborate with other developers on GitHub.'
                ),
                _etch2['default'].dom(
                  'p',
                  null,
                  _etch2['default'].dom(
                    'button',
                    { onclick: this.didClickGitButton, className: 'btn btn-primary inline-block' },
                    'Open the Git panel'
                  ),
                  _etch2['default'].dom(
                    'button',
                    { onclick: this.didClickGitHubButton, className: 'btn btn-primary inline-block' },
                    'Open the GitHub panel'
                  )
                ),
                _etch2['default'].dom(
                  'p',
                  { className: 'welcome-note' },
                  _etch2['default'].dom(
                    'strong',
                    null,
                    'Next time:'
                  ),
                  ' You can toggle the Git tab by clicking on the',
                  _etch2['default'].dom('span', { className: 'icon icon-diff' }),
                  ' button in your status bar.'
                )
              )
            ),
            _etch2['default'].dom(
              'details',
              _extends({ className: 'welcome-card' }, this.getSectionProps('packages')),
              _etch2['default'].dom(
                'summary',
                { className: 'welcome-summary icon icon-package' },
                'Install a ',
                _etch2['default'].dom(
                  'span',
                  { className: 'welcome-highlight' },
                  'Package'
                )
              ),
              _etch2['default'].dom(
                'div',
                { className: 'welcome-detail' },
                _etch2['default'].dom(
                  'p',
                  null,
                  _etch2['default'].dom('img', { className: 'welcome-img', src: 'atom://welcome/assets/package.svg' })
                ),
                _etch2['default'].dom(
                  'p',
                  null,
                  'One of the best things about Atom is the package ecosystem. Installing packages adds new features and functionality you can use to make the editor suit your needs. Let\'s install one.'
                ),
                _etch2['default'].dom(
                  'p',
                  null,
                  _etch2['default'].dom(
                    'button',
                    { ref: 'packagesButton', onclick: this.didClickPackagesButton, className: 'btn btn-primary' },
                    'Open Installer'
                  )
                ),
                _etch2['default'].dom(
                  'p',
                  { className: 'welcome-note' },
                  _etch2['default'].dom(
                    'strong',
                    null,
                    'Next time:'
                  ),
                  ' You can install new packages from the settings.'
                )
              )
            ),
            _etch2['default'].dom(
              'details',
              _extends({ className: 'welcome-card' }, this.getSectionProps('themes')),
              _etch2['default'].dom(
                'summary',
                { className: 'welcome-summary icon icon-paintcan' },
                'Choose a ',
                _etch2['default'].dom(
                  'span',
                  { 'class': 'welcome-highlight' },
                  'Theme'
                )
              ),
              _etch2['default'].dom(
                'div',
                { className: 'welcome-detail' },
                _etch2['default'].dom(
                  'p',
                  null,
                  _etch2['default'].dom('img', { className: 'welcome-img', src: 'atom://welcome/assets/theme.svg' })
                ),
                _etch2['default'].dom(
                  'p',
                  null,
                  'Atom comes with preinstalled themes. Let\'s try a few.'
                ),
                _etch2['default'].dom(
                  'p',
                  null,
                  _etch2['default'].dom(
                    'button',
                    { ref: 'themesButton', onclick: this.didClickThemesButton, className: 'btn btn-primary' },
                    'Open the theme picker'
                  )
                ),
                _etch2['default'].dom(
                  'p',
                  null,
                  'You can also install themes created by the Atom community. To install new themes, click on "+ Install" and switch the toggle to "themes".'
                ),
                _etch2['default'].dom(
                  'p',
                  { className: 'welcome-note' },
                  _etch2['default'].dom(
                    'strong',
                    null,
                    'Next time:'
                  ),
                  ' You can switch themes from the settings.'
                )
              )
            ),
            _etch2['default'].dom(
              'details',
              _extends({ className: 'welcome-card' }, this.getSectionProps('styling')),
              _etch2['default'].dom(
                'summary',
                { className: 'welcome-summary icon icon-paintcan' },
                'Customize the ',
                _etch2['default'].dom(
                  'span',
                  { 'class': 'welcome-highlight' },
                  'Styling'
                )
              ),
              _etch2['default'].dom(
                'div',
                { className: 'welcome-detail' },
                _etch2['default'].dom(
                  'p',
                  null,
                  _etch2['default'].dom('img', { className: 'welcome-img', src: 'atom://welcome/assets/code.svg' })
                ),
                _etch2['default'].dom(
                  'p',
                  null,
                  'You can customize almost anything by adding your own CSS/LESS.'
                ),
                _etch2['default'].dom(
                  'p',
                  null,
                  _etch2['default'].dom(
                    'button',
                    { ref: 'stylingButton', onclick: this.didClickStylingButton, className: 'btn btn-primary' },
                    'Open your Stylesheet'
                  )
                ),
                _etch2['default'].dom(
                  'p',
                  null,
                  'Now uncomment some of the examples or try your own'
                ),
                _etch2['default'].dom(
                  'p',
                  { className: 'welcome-note' },
                  _etch2['default'].dom(
                    'strong',
                    null,
                    'Next time:'
                  ),
                  ' You can open your stylesheet from Menu ',
                  this.getApplicationMenuName(),
                  '.'
                )
              )
            ),
            _etch2['default'].dom(
              'details',
              _extends({ className: 'welcome-card' }, this.getSectionProps('init-script')),
              _etch2['default'].dom(
                'summary',
                { className: 'welcome-summary icon icon-code' },
                'Hack on the ',
                _etch2['default'].dom(
                  'span',
                  { 'class': 'welcome-highlight' },
                  'Init Script'
                )
              ),
              _etch2['default'].dom(
                'div',
                { className: 'welcome-detail' },
                _etch2['default'].dom(
                  'p',
                  null,
                  _etch2['default'].dom('img', { className: 'welcome-img', src: 'atom://welcome/assets/code.svg' })
                ),
                _etch2['default'].dom(
                  'p',
                  null,
                  'The init script is a bit of JavaScript or CoffeeScript run at startup. You can use it to quickly change the behaviour of Atom.'
                ),
                _etch2['default'].dom(
                  'p',
                  null,
                  _etch2['default'].dom(
                    'button',
                    { ref: 'initScriptButton', onclick: this.didClickInitScriptButton, className: 'btn btn-primary' },
                    'Open your Init Script'
                  )
                ),
                _etch2['default'].dom(
                  'p',
                  null,
                  'Uncomment some of the examples or try out your own.'
                ),
                _etch2['default'].dom(
                  'p',
                  { className: 'welcome-note' },
                  _etch2['default'].dom(
                    'strong',
                    null,
                    'Next time:'
                  ),
                  ' You can open your init script from Menu > ',
                  this.getApplicationMenuName(),
                  '.'
                )
              )
            ),
            _etch2['default'].dom(
              'details',
              _extends({ className: 'welcome-card' }, this.getSectionProps('snippets')),
              _etch2['default'].dom(
                'summary',
                { className: 'welcome-summary icon icon-code' },
                'Add a ',
                _etch2['default'].dom(
                  'span',
                  { 'class': 'welcome-highlight' },
                  'Snippet'
                )
              ),
              _etch2['default'].dom(
                'div',
                { className: 'welcome-detail' },
                _etch2['default'].dom(
                  'p',
                  null,
                  _etch2['default'].dom('img', { className: 'welcome-img', src: 'atom://welcome/assets/code.svg' })
                ),
                _etch2['default'].dom(
                  'p',
                  null,
                  'Atom snippets allow you to enter a simple prefix in the editor and hit tab to expand the prefix into a larger code block with templated values.'
                ),
                _etch2['default'].dom(
                  'p',
                  null,
                  _etch2['default'].dom(
                    'button',
                    { ref: 'snippetsButton', onclick: this.didClickSnippetsButton, className: 'btn btn-primary' },
                    'Open your Snippets'
                  )
                ),
                _etch2['default'].dom(
                  'p',
                  null,
                  'In your snippets file, type ',
                  _etch2['default'].dom(
                    'code',
                    null,
                    'snip'
                  ),
                  ' then hit ',
                  _etch2['default'].dom(
                    'code',
                    null,
                    'tab'
                  ),
                  '. The ',
                  _etch2['default'].dom(
                    'code',
                    null,
                    'snip'
                  ),
                  ' snippet will expand to create a snippet!'
                ),
                _etch2['default'].dom(
                  'p',
                  { className: 'welcome-note' },
                  _etch2['default'].dom(
                    'strong',
                    null,
                    'Next time:'
                  ),
                  ' You can open your snippets in Menu > ',
                  this.getApplicationMenuName(),
                  '.'
                )
              )
            ),
            _etch2['default'].dom(
              'details',
              _extends({ className: 'welcome-card' }, this.getSectionProps('shortcuts')),
              _etch2['default'].dom(
                'summary',
                { className: 'welcome-summary icon icon-keyboard' },
                'Learn ',
                _etch2['default'].dom(
                  'span',
                  { 'class': 'welcome-highlight' },
                  'Keyboard Shortcuts'
                )
              ),
              _etch2['default'].dom(
                'div',
                { className: 'welcome-detail' },
                _etch2['default'].dom(
                  'p',
                  null,
                  _etch2['default'].dom('img', { className: 'welcome-img', src: 'atom://welcome/assets/shortcut.svg' })
                ),
                _etch2['default'].dom(
                  'p',
                  null,
                  'If you only remember one keyboard shortcut make it ',
                  _etch2['default'].dom(
                    'kbd',
                    { className: 'welcome-key' },
                    this.getCommandPaletteKeyBinding()
                  ),
                  '. This keystroke toggles the command palette, which lists every Atom command. It\'s a good way to learn more shortcuts. Yes, you can try it now!'
                ),
                _etch2['default'].dom(
                  'p',
                  null,
                  'If you want to use these guides again use the command palette ',
                  _etch2['default'].dom(
                    'kbd',
                    { className: 'welcome-key' },
                    this.getCommandPaletteKeyBinding()
                  ),
                  ' and search for ',
                  _etch2['default'].dom(
                    'span',
                    { className: 'text-highlight' },
                    'Welcome'
                  ),
                  '.'
                )
              )
            )
          )
        )
      );
    }
  }, {
    key: 'getSectionProps',
    value: function getSectionProps(sectionName) {
      var props = { dataset: { section: sectionName }, onclick: this.didExpandOrCollapseSection };
      if (this.props.openSections && this.props.openSections.indexOf(sectionName) !== -1) {
        props.open = true;
      }
      return props;
    }
  }, {
    key: 'getCommandPaletteKeyBinding',
    value: function getCommandPaletteKeyBinding() {
      if (process.platform === 'darwin') {
        return 'cmd-shift-p';
      } else {
        return 'ctrl-shift-p';
      }
    }
  }, {
    key: 'getApplicationMenuName',
    value: function getApplicationMenuName() {
      if (process.platform === 'darwin') {
        return 'Atom';
      } else if (process.platform === 'linux') {
        return 'Edit';
      } else {
        return 'File';
      }
    }
  }, {
    key: 'serialize',
    value: function serialize() {
      return {
        deserializer: this.constructor.name,
        openSections: this.getOpenSections(),
        uri: this.getURI()
      };
    }
  }, {
    key: 'getURI',
    value: function getURI() {
      return this.props.uri;
    }
  }, {
    key: 'getTitle',
    value: function getTitle() {
      return 'Welcome Guide';
    }
  }, {
    key: 'isEqual',
    value: function isEqual(other) {
      return other instanceof GuideView;
    }
  }, {
    key: 'getOpenSections',
    value: function getOpenSections() {
      return Array.from(this.element.querySelectorAll('details[open]')).map(function (sectionElement) {
        return sectionElement.dataset.section;
      });
    }
  }, {
    key: 'didClickProjectButton',
    value: function didClickProjectButton() {
      this.props.reporterProxy.sendEvent('clicked-project-cta');
      atom.commands.dispatch(atom.views.getView(atom.workspace), 'application:open');
    }
  }, {
    key: 'didClickGitButton',
    value: function didClickGitButton() {
      this.props.reporterProxy.sendEvent('clicked-git-cta');
      atom.commands.dispatch(atom.views.getView(atom.workspace), 'github:toggle-git-tab');
    }
  }, {
    key: 'didClickGitHubButton',
    value: function didClickGitHubButton() {
      this.props.reporterProxy.sendEvent('clicked-github-cta');
      atom.commands.dispatch(atom.views.getView(atom.workspace), 'github:toggle-github-tab');
    }
  }, {
    key: 'didClickPackagesButton',
    value: function didClickPackagesButton() {
      this.props.reporterProxy.sendEvent('clicked-packages-cta');
      atom.workspace.open('atom://config/install', { split: 'left' });
    }
  }, {
    key: 'didClickThemesButton',
    value: function didClickThemesButton() {
      this.props.reporterProxy.sendEvent('clicked-themes-cta');
      atom.workspace.open('atom://config/themes', { split: 'left' });
    }
  }, {
    key: 'didClickStylingButton',
    value: function didClickStylingButton() {
      this.props.reporterProxy.sendEvent('clicked-styling-cta');
      atom.workspace.open('atom://.atom/stylesheet', { split: 'left' });
    }
  }, {
    key: 'didClickInitScriptButton',
    value: function didClickInitScriptButton() {
      this.props.reporterProxy.sendEvent('clicked-init-script-cta');
      atom.workspace.open('atom://.atom/init-script', { split: 'left' });
    }
  }, {
    key: 'didClickSnippetsButton',
    value: function didClickSnippetsButton() {
      this.props.reporterProxy.sendEvent('clicked-snippets-cta');
      atom.workspace.open('atom://.atom/snippets', { split: 'left' });
    }
  }, {
    key: 'didExpandOrCollapseSection',
    value: function didExpandOrCollapseSection(event) {
      var sectionName = event.currentTarget.closest('details').dataset.section;
      var action = event.currentTarget.hasAttribute('open') ? 'collapse' : 'expand';
      this.props.reporterProxy.sendEvent(action + '-' + sectionName + '-section');
    }
  }]);

  return GuideView;
})();

exports['default'] = GuideView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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