(function() {
  var CompositeDisposable, Dialog, Disposable, Emitter, Point, Range, TextEditor, path, ref;

  ref = require('atom'), TextEditor = ref.TextEditor, CompositeDisposable = ref.CompositeDisposable, Disposable = ref.Disposable, Emitter = ref.Emitter, Range = ref.Range, Point = ref.Point;

  path = require('path');

  module.exports = Dialog = (function() {
    function Dialog(arg) {
      var baseName, blurHandler, extension, iconClass, initialPath, prompt, ref1, select, selectionEnd, selectionStart;
      ref1 = arg != null ? arg : {}, initialPath = ref1.initialPath, select = ref1.select, iconClass = ref1.iconClass, prompt = ref1.prompt;
      this.emitter = new Emitter();
      this.disposables = new CompositeDisposable();
      this.element = document.createElement('div');
      this.element.classList.add('tree-view-dialog');
      this.promptText = document.createElement('label');
      this.promptText.classList.add('icon');
      if (iconClass) {
        this.promptText.classList.add(iconClass);
      }
      this.promptText.textContent = prompt;
      this.element.appendChild(this.promptText);
      this.miniEditor = new TextEditor({
        mini: true
      });
      blurHandler = (function(_this) {
        return function() {
          if (document.hasFocus()) {
            return _this.close();
          }
        };
      })(this);
      this.miniEditor.element.addEventListener('blur', blurHandler);
      this.disposables.add(new Disposable((function(_this) {
        return function() {
          return _this.miniEditor.element.removeEventListener('blur', blurHandler);
        };
      })(this)));
      this.disposables.add(this.miniEditor.onDidChange((function(_this) {
        return function() {
          return _this.showError();
        };
      })(this)));
      this.element.appendChild(this.miniEditor.element);
      this.errorMessage = document.createElement('div');
      this.errorMessage.classList.add('error-message');
      this.element.appendChild(this.errorMessage);
      atom.commands.add(this.element, {
        'core:confirm': (function(_this) {
          return function() {
            return _this.onConfirm(_this.miniEditor.getText());
          };
        })(this),
        'core:cancel': (function(_this) {
          return function() {
            return _this.cancel();
          };
        })(this)
      });
      this.miniEditor.setText(initialPath);
      if (select) {
        extension = path.extname(initialPath);
        baseName = path.basename(initialPath);
        selectionStart = initialPath.length - baseName.length;
        if (baseName === extension) {
          selectionEnd = initialPath.length;
        } else {
          selectionEnd = initialPath.length - extension.length;
        }
        this.miniEditor.setSelectedBufferRange(Range(Point(0, selectionStart), Point(0, selectionEnd)));
      }
    }

    Dialog.prototype.attach = function() {
      this.panel = atom.workspace.addModalPanel({
        item: this
      });
      this.miniEditor.element.focus();
      return this.miniEditor.scrollToCursorPosition();
    };

    Dialog.prototype.close = function() {
      var activePane, panel;
      panel = this.panel;
      this.panel = null;
      if (panel != null) {
        panel.destroy();
      }
      this.emitter.dispose();
      this.disposables.dispose();
      this.miniEditor.destroy();
      activePane = atom.workspace.getCenter().getActivePane();
      if (!activePane.isDestroyed()) {
        return activePane.activate();
      }
    };

    Dialog.prototype.cancel = function() {
      var ref1;
      this.close();
      return (ref1 = document.querySelector('.tree-view')) != null ? ref1.focus() : void 0;
    };

    Dialog.prototype.showError = function(message) {
      if (message == null) {
        message = '';
      }
      this.errorMessage.textContent = message;
      if (message) {
        this.element.classList.add('error');
        return window.setTimeout(((function(_this) {
          return function() {
            return _this.element.classList.remove('error');
          };
        })(this)), 300);
      }
    };

    return Dialog;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
