Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var WindowPanelView = (function () {
  function WindowPanelView() {
    _classCallCheck(this, WindowPanelView);

    _etch2['default'].initialize(this);

    this.disposables = new _atom.CompositeDisposable();
    this.disposables.add(atom.tooltips.add(this.refs.windowTiming, { title: 'The time taken to load this window' }));
    this.disposables.add(atom.tooltips.add(this.refs.shellTiming, { title: 'The time taken to launch the app' }));
    this.disposables.add(atom.tooltips.add(this.refs.workspaceTiming, { title: 'The time taken to rebuild the previously opened editors' }));
    this.disposables.add(atom.tooltips.add(this.refs.projectTiming, { title: 'The time taken to rebuild the previously opened buffers' }));
    this.disposables.add(atom.tooltips.add(this.refs.atomTiming, { title: 'The time taken to read and parse the stored window state' }));
  }

  _createClass(WindowPanelView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'tool-panel padded package-panel' },
        _etch2['default'].dom(
          'div',
          { className: 'inset-panel' },
          _etch2['default'].dom(
            'div',
            { className: 'panel-heading' },
            'Startup Time'
          ),
          _etch2['default'].dom(
            'div',
            { className: 'panel-body padded' },
            _etch2['default'].dom(
              'div',
              { className: 'timing', ref: 'windowTiming' },
              _etch2['default'].dom(
                'span',
                { className: 'inline-block' },
                'Window load time'
              ),
              _etch2['default'].dom('span', { className: 'inline-block', ref: 'windowLoadTime' })
            ),
            _etch2['default'].dom(
              'div',
              { className: 'timing', ref: 'shellTiming' },
              _etch2['default'].dom(
                'span',
                { className: 'inline-block' },
                'Shell load time'
              ),
              _etch2['default'].dom('span', { className: 'inline-block', ref: 'shellLoadTime' })
            ),
            _etch2['default'].dom(
              'div',
              { ref: 'deserializeTimings' },
              _etch2['default'].dom(
                'div',
                { className: 'timing', ref: 'workspaceTiming' },
                _etch2['default'].dom(
                  'span',
                  { className: 'inline-block' },
                  'Workspace load time'
                ),
                _etch2['default'].dom('span', { className: 'inline-block', ref: 'workspaceLoadTime' })
              ),
              _etch2['default'].dom(
                'div',
                { className: 'timing', ref: 'projectTiming' },
                _etch2['default'].dom(
                  'span',
                  { className: 'inline-block' },
                  'Project load time'
                ),
                _etch2['default'].dom('span', { className: 'inline-block', ref: 'projectLoadTime' })
              ),
              _etch2['default'].dom(
                'div',
                { className: 'timing', ref: 'atomTiming' },
                _etch2['default'].dom(
                  'span',
                  { className: 'inline-block' },
                  'Window state load time'
                ),
                _etch2['default'].dom('span', { className: 'inline-block', ref: 'atomLoadTime' })
              )
            )
          )
        )
      );
    }
  }, {
    key: 'populate',
    value: function populate() {
      var time = atom.getWindowLoadTime();
      this.refs.windowLoadTime.classList.add(this.getHighlightClass(time));
      this.refs.windowLoadTime.textContent = time + 'ms';

      var _atom$getLoadSettings = atom.getLoadSettings();

      var shellLoadTime = _atom$getLoadSettings.shellLoadTime;

      if (shellLoadTime != null) {
        this.refs.shellLoadTime.classList.add(this.getHighlightClass(shellLoadTime));
        this.refs.shellLoadTime.textContent = shellLoadTime + 'ms';
      } else {
        this.refs.shellTiming.style.display = 'none';
      }

      if (atom.deserializeTimings != null) {
        this.refs.workspaceLoadTime.classList.add(this.getHighlightClass(atom.deserializeTimings.workspace));
        this.refs.workspaceLoadTime.textContent = atom.deserializeTimings.workspace + 'ms';
        this.refs.projectLoadTime.classList.add(this.getHighlightClass(atom.deserializeTimings.project));
        this.refs.projectLoadTime.textContent = atom.deserializeTimings.project + 'ms';
        this.refs.atomLoadTime.classList.add(this.getHighlightClass(atom.deserializeTimings.atom));
        this.refs.atomLoadTime.textContent = atom.deserializeTimings.atom + 'ms';
      } else {
        this.refs.deserializeTimings.style.display = 'none';
      }
    }
  }, {
    key: 'getHighlightClass',
    value: function getHighlightClass(time) {
      if (time > 1000) {
        return 'highlight-error';
      } else if (time > 800) {
        return 'highlight-warning';
      } else {
        return 'highlight-info';
      }
    }
  }]);

  return WindowPanelView;
})();

exports['default'] = WindowPanelView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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