Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var CachePanelView = (function () {
  function CachePanelView() {
    _classCallCheck(this, CachePanelView);

    _etch2['default'].initialize(this);
  }

  _createClass(CachePanelView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'tool-panel padded package-panel' },
        _etch2['default'].dom(
          'div',
          { className: 'inset-panel' },
          _etch2['default'].dom(
            'div',
            { className: 'panel-heading' },
            'Compile Cache'
          ),
          _etch2['default'].dom(
            'div',
            { className: 'panel-body padded' },
            _etch2['default'].dom(
              'div',
              { className: 'timing' },
              _etch2['default'].dom(
                'span',
                { className: 'inline-block' },
                'CoffeeScript files compiled'
              ),
              _etch2['default'].dom(
                'span',
                { className: 'inline-block highlight-info', ref: 'coffeeCompileCount' },
                '0'
              )
            ),
            _etch2['default'].dom(
              'div',
              { className: 'timing' },
              _etch2['default'].dom(
                'span',
                { className: 'inline-block' },
                'Babel files compiled'
              ),
              _etch2['default'].dom('span', { className: 'inline-block highlight-info', ref: 'babelCompileCount' })
            ),
            _etch2['default'].dom(
              'div',
              { className: 'timing' },
              _etch2['default'].dom(
                'span',
                { className: 'inline-block' },
                'Typescript files compiled'
              ),
              _etch2['default'].dom('span', { className: 'inline-block highlight-info', ref: 'typescriptCompileCount' })
            ),
            _etch2['default'].dom(
              'div',
              { className: 'timing' },
              _etch2['default'].dom(
                'span',
                { className: 'inline-block' },
                'CSON files compiled'
              ),
              _etch2['default'].dom('span', { className: 'inline-block highlight-info', ref: 'csonCompileCount' })
            ),
            _etch2['default'].dom(
              'div',
              { className: 'timing' },
              _etch2['default'].dom(
                'span',
                { className: 'inline-block' },
                'Less files compiled'
              ),
              _etch2['default'].dom('span', { className: 'inline-block highlight-info', ref: 'lessCompileCount' })
            )
          )
        )
      );
    }
  }, {
    key: 'populate',
    value: function populate() {
      var compileCacheStats = this.getCompileCacheStats();
      if (compileCacheStats) {
        this.refs.coffeeCompileCount.textContent = compileCacheStats['.coffee'].misses;
        this.refs.babelCompileCount.textContent = compileCacheStats['.js'].misses;
        this.refs.typescriptCompileCount.textContent = compileCacheStats['.ts'].misses;
      }

      this.refs.csonCompileCount.textContent = this.getCsonCompiles();
      this.refs.lessCompileCount.textContent = this.getLessCompiles();
    }
  }, {
    key: 'getCompileCacheStats',
    value: function getCompileCacheStats() {
      try {
        return require(_path2['default'].join(atom.getLoadSettings().resourcePath, 'src', 'compile-cache')).getCacheStats();
      } catch (error) {
        return null;
      }
    }
  }, {
    key: 'getCsonCompiles',
    value: function getCsonCompiles() {
      try {
        var CSON = require(_path2['default'].join(atom.getLoadSettings().resourcePath, 'node_modules', 'season'));
        if (CSON.getCacheMisses) {
          return CSON.getCacheMisses() || 0;
        } else {
          return 0;
        }
      } catch (error) {
        return 0;
      }
    }
  }, {
    key: 'getLessCompiles',
    value: function getLessCompiles() {
      var lessCache = atom.themes.lessCache;
      if (lessCache && lessCache.cache && lessCache.cache.stats && lessCache.cache.stats.misses) {
        return lessCache.cache.stats.misses || 0;
      } else {
        return 0;
      }
    }
  }]);

  return CachePanelView;
})();

exports['default'] = CachePanelView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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