Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _atom = require('atom');

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _fuzzaldrin = require('fuzzaldrin');

var SymbolsView = (function () {
  _createClass(SymbolsView, null, [{
    key: 'highlightMatches',
    value: function highlightMatches(context, name, matches, offsetIndex) {
      if (!offsetIndex) {
        offsetIndex = 0;
      }
      var lastIndex = 0;
      var matchedChars = []; // Build up a set of matched chars to be more semantic
      var fragment = document.createDocumentFragment();

      for (var matchIndex of Array.from(matches)) {
        matchIndex -= offsetIndex;
        if (matchIndex < 0) {
          continue; // If marking up the basename, omit name matches
        }
        var unmatched = name.substring(lastIndex, matchIndex);
        if (unmatched) {
          if (matchedChars.length) {
            var span = document.createElement('span');
            span.classList.add('character-match');
            span.textContent = matchedChars.join('');
            fragment.appendChild(span);
          }
          matchedChars = [];
          fragment.appendChild(document.createTextNode(unmatched));
        }
        matchedChars.push(name[matchIndex]);
        lastIndex = matchIndex + 1;
      }

      if (matchedChars.length) {
        var span = document.createElement('span');
        span.classList.add('character-match');
        span.textContent = matchedChars.join('');
        fragment.appendChild(span);
      }

      // Remaining characters are plain text
      fragment.appendChild(document.createTextNode(name.substring(lastIndex)));

      return fragment;
    }
  }]);

  function SymbolsView(stack) {
    var emptyMessage = arguments.length <= 1 || arguments[1] === undefined ? 'No symbols found' : arguments[1];
    var maxResults = arguments.length <= 2 || arguments[2] === undefined ? null : arguments[2];

    _classCallCheck(this, SymbolsView);

    this.stack = stack;
    this.selectListView = new _atomSelectList2['default']({
      maxResults: maxResults,
      emptyMessage: emptyMessage,
      items: [],
      filterKeyForItem: function filterKeyForItem(item) {
        return item.name;
      },
      elementForItem: this.elementForItem.bind(this),
      didChangeSelection: this.didChangeSelection.bind(this),
      didConfirmSelection: this.didConfirmSelection.bind(this),
      didConfirmEmptySelection: this.didConfirmEmptySelection.bind(this),
      didCancelSelection: this.didCancelSelection.bind(this)
    });
    this.element = this.selectListView.element;
    this.element.classList.add('symbols-view');
    this.panel = atom.workspace.addModalPanel({ item: this, visible: false });
  }

  _createClass(SymbolsView, [{
    key: 'destroy',
    value: _asyncToGenerator(function* () {
      yield this.cancel();
      this.panel.destroy();
      return this.selectListView.destroy();
    })
  }, {
    key: 'getFilterKey',
    value: function getFilterKey() {
      return 'name';
    }
  }, {
    key: 'elementForItem',
    value: function elementForItem(_ref) {
      var position = _ref.position;
      var name = _ref.name;
      var file = _ref.file;
      var directory = _ref.directory;

      // Style matched characters in search results
      var matches = (0, _fuzzaldrin.match)(name, this.selectListView.getFilterQuery());

      if (atom.project.getPaths().length > 1) {
        file = _path2['default'].join(_path2['default'].basename(directory), file);
      }

      var li = document.createElement('li');
      li.classList.add('two-lines');

      var primaryLine = document.createElement('div');
      primaryLine.classList.add('primary-line');
      if (position) {
        primaryLine.textContent = name + ':' + (position.row + 1);
      } else {
        primaryLine.appendChild(SymbolsView.highlightMatches(this, name, matches));
      }
      li.appendChild(primaryLine);

      var secondaryLine = document.createElement('div');
      secondaryLine.classList.add('secondary-line');
      secondaryLine.textContent = file;
      li.appendChild(secondaryLine);

      return li;
    }
  }, {
    key: 'cancel',
    value: _asyncToGenerator(function* () {
      if (!this.isCanceling) {
        this.isCanceling = true;
        yield this.selectListView.update({ items: [] });
        this.panel.hide();
        if (this.previouslyFocusedElement) {
          this.previouslyFocusedElement.focus();
          this.previouslyFocusedElement = null;
        }
        this.isCanceling = false;
      }
    })
  }, {
    key: 'didCancelSelection',
    value: function didCancelSelection() {
      this.cancel();
    }
  }, {
    key: 'didConfirmEmptySelection',
    value: function didConfirmEmptySelection() {
      this.cancel();
    }
  }, {
    key: 'didConfirmSelection',
    value: _asyncToGenerator(function* (tag) {
      var _this = this;

      if (tag.file && !_fsPlus2['default'].isFileSync(_path2['default'].join(tag.directory, tag.file))) {
        yield this.selectListView.update({ errorMessage: 'Selected file does not exist' });
        setTimeout(function () {
          _this.selectListView.update({ errorMessage: null });
        }, 2000);
      } else {
        yield this.cancel();
        this.openTag(tag);
      }
    })
  }, {
    key: 'didChangeSelection',
    value: function didChangeSelection(tag) {
      // no-op
    }
  }, {
    key: 'openTag',
    value: function openTag(tag) {
      var _this2 = this;

      var editor = atom.workspace.getActiveTextEditor();
      var previous = undefined;
      if (editor) {
        previous = {
          editorId: editor.id,
          position: editor.getCursorBufferPosition(),
          file: editor.getURI()
        };
      }

      var position = tag.position;

      if (!position) {
        position = this.getTagLine(tag);
      }
      if (tag.file) {
        atom.workspace.open(_path2['default'].join(tag.directory, tag.file)).then(function () {
          if (position) {
            return _this2.moveToPosition(position);
          }
          return undefined;
        });
      } else if (position && previous && !previous.position.isEqual(position)) {
        this.moveToPosition(position);
      }

      this.stack.push(previous);
    }
  }, {
    key: 'moveToPosition',
    value: function moveToPosition(position, beginningOfLine) {
      var editor = atom.workspace.getActiveTextEditor();
      if (beginningOfLine == null) {
        beginningOfLine = true;
      }
      if (editor) {
        editor.scrollToBufferPosition(position, { center: true });
        editor.setCursorBufferPosition(position);
        if (beginningOfLine) {
          editor.moveToFirstCharacterOfLine();
        }
      }
    }
  }, {
    key: 'attach',
    value: function attach() {
      this.previouslyFocusedElement = document.activeElement;
      this.panel.show();
      this.selectListView.reset();
      this.selectListView.focus();
    }
  }, {
    key: 'getTagLine',
    value: function getTagLine(tag) {
      // Remove leading /^ and trailing $/
      if (!tag || !tag.pattern) {
        return undefined;
      }
      var pattern = tag.pattern.replace(/(^^\/\^)|(\$\/$)/g, '').trim();

      if (!pattern) {
        return undefined;
      }
      var file = _path2['default'].join(tag.directory, tag.file);
      if (!_fsPlus2['default'].isFileSync(file)) {
        return undefined;
      }
      var iterable = _fsPlus2['default'].readFileSync(file, 'utf8').split('\n');
      for (var index = 0; index < iterable.length; index++) {
        var line = iterable[index];
        if (pattern === line.trim()) {
          return new _atom.Point(index, 0);
        }
      }

      return undefined;
    }
  }]);

  return SymbolsView;
})();

exports['default'] = SymbolsView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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