(function() {
  var CompositeDisposable, StyleguideUri;

  CompositeDisposable = require('atom').CompositeDisposable;

  StyleguideUri = 'atom://styleguide';

  module.exports = {
    activate: function() {
      this.subscriptions = new CompositeDisposable;
      this.subscriptions.add(atom.workspace.addOpener((function(_this) {
        return function(filePath) {
          if (filePath === StyleguideUri) {
            return _this.createStyleguideView({
              uri: StyleguideUri
            });
          }
        };
      })(this)));
      return this.subscriptions.add(atom.commands.add('atom-workspace', 'styleguide:show', function() {
        return atom.workspace.open(StyleguideUri);
      }));
    },
    deactivate: function() {
      return this.subscriptions.dispose();
    },
    createStyleguideView: function(state) {
      var StyleguideView;
      StyleguideView = require('./styleguide-view');
      return new StyleguideView(state);
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2hvbWUvdHJhdmlzL2J1aWxkL2F0b20vYXRvbS9vdXQvYXBwL25vZGVfbW9kdWxlcy9zdHlsZWd1aWRlL2xpYi9zdHlsZWd1aWRlLmNvZmZlZSJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtBQUFBLE1BQUE7O0VBQUMsc0JBQXVCLE9BQUEsQ0FBUSxNQUFSOztFQUN4QixhQUFBLEdBQWdCOztFQUVoQixNQUFNLENBQUMsT0FBUCxHQUNFO0lBQUEsUUFBQSxFQUFVLFNBQUE7TUFDUixJQUFDLENBQUEsYUFBRCxHQUFpQixJQUFJO01BQ3JCLElBQUMsQ0FBQSxhQUFhLENBQUMsR0FBZixDQUFtQixJQUFJLENBQUMsU0FBUyxDQUFDLFNBQWYsQ0FBeUIsQ0FBQSxTQUFBLEtBQUE7ZUFBQSxTQUFDLFFBQUQ7VUFDMUMsSUFBNkMsUUFBQSxLQUFZLGFBQXpEO21CQUFBLEtBQUMsQ0FBQSxvQkFBRCxDQUFzQjtjQUFBLEdBQUEsRUFBSyxhQUFMO2FBQXRCLEVBQUE7O1FBRDBDO01BQUEsQ0FBQSxDQUFBLENBQUEsSUFBQSxDQUF6QixDQUFuQjthQUVBLElBQUMsQ0FBQSxhQUFhLENBQUMsR0FBZixDQUFtQixJQUFJLENBQUMsUUFBUSxDQUFDLEdBQWQsQ0FBa0IsZ0JBQWxCLEVBQW9DLGlCQUFwQyxFQUF1RCxTQUFBO2VBQ3hFLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBZixDQUFvQixhQUFwQjtNQUR3RSxDQUF2RCxDQUFuQjtJQUpRLENBQVY7SUFPQSxVQUFBLEVBQVksU0FBQTthQUNWLElBQUMsQ0FBQSxhQUFhLENBQUMsT0FBZixDQUFBO0lBRFUsQ0FQWjtJQVVBLG9CQUFBLEVBQXNCLFNBQUMsS0FBRDtBQUNwQixVQUFBO01BQUEsY0FBQSxHQUFpQixPQUFBLENBQVEsbUJBQVI7YUFDYixJQUFBLGNBQUEsQ0FBZSxLQUFmO0lBRmdCLENBVnRCOztBQUpGIiwic291cmNlc0NvbnRlbnQiOlsie0NvbXBvc2l0ZURpc3Bvc2FibGV9ID0gcmVxdWlyZSAnYXRvbSdcblN0eWxlZ3VpZGVVcmkgPSAnYXRvbTovL3N0eWxlZ3VpZGUnXG5cbm1vZHVsZS5leHBvcnRzID1cbiAgYWN0aXZhdGU6IC0+XG4gICAgQHN1YnNjcmlwdGlvbnMgPSBuZXcgQ29tcG9zaXRlRGlzcG9zYWJsZVxuICAgIEBzdWJzY3JpcHRpb25zLmFkZCBhdG9tLndvcmtzcGFjZS5hZGRPcGVuZXIgKGZpbGVQYXRoKSA9PlxuICAgICAgQGNyZWF0ZVN0eWxlZ3VpZGVWaWV3KHVyaTogU3R5bGVndWlkZVVyaSkgaWYgZmlsZVBhdGggaXMgU3R5bGVndWlkZVVyaVxuICAgIEBzdWJzY3JpcHRpb25zLmFkZCBhdG9tLmNvbW1hbmRzLmFkZCAnYXRvbS13b3Jrc3BhY2UnLCAnc3R5bGVndWlkZTpzaG93JywgLT5cbiAgICAgIGF0b20ud29ya3NwYWNlLm9wZW4oU3R5bGVndWlkZVVyaSlcblxuICBkZWFjdGl2YXRlOiAtPlxuICAgIEBzdWJzY3JpcHRpb25zLmRpc3Bvc2UoKVxuXG4gIGNyZWF0ZVN0eWxlZ3VpZGVWaWV3OiAoc3RhdGUpIC0+XG4gICAgU3R5bGVndWlkZVZpZXcgPSByZXF1aXJlICcuL3N0eWxlZ3VpZGUtdmlldydcbiAgICBuZXcgU3R5bGVndWlkZVZpZXcoc3RhdGUpXG4iXX0=
