Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _errorView = require('./error-view');

var _errorView2 = _interopRequireDefault(_errorView);

var _packageCard = require('./package-card');

var _packageCard2 = _interopRequireDefault(_packageCard);

var UpdatesPanel = (function () {
  function UpdatesPanel(settingsView, packageManager) {
    var _this = this;

    _classCallCheck(this, UpdatesPanel);

    this.settingsView = settingsView;
    this.packageManager = packageManager;
    this.disposables = new _atom.CompositeDisposable();
    this.updatingPackages = [];
    this.packageCards = [];

    _etch2['default'].initialize(this);

    this.refs.updateAllButton.style.display = 'none';
    this.checkForUpdates();

    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    this.disposables.add(this.packageManager.on('package-updating theme-updating', function (_ref) {
      var pack = _ref.pack;
      var error = _ref.error;

      _this.refs.checkButton.disabled = true;
      _this.updatingPackages.push(pack);
    }));

    this.disposables.add(this.packageManager.on('package-updated theme-updated package-update-failed theme-update-failed', function (_ref2) {
      var pack = _ref2.pack;
      var error = _ref2.error;

      if (error != null) {
        _this.refs.updateErrors.appendChild(new _errorView2['default'](_this.packageManager, error).element);
      }

      for (var i = 0; i < _this.updatingPackages.length; i++) {
        var update = _this.updatingPackages[i];
        if (update.name === pack.name) {
          _this.updatingPackages.splice(i, 1);
        }
      }

      if (!_this.updatingPackages.length) {
        _this.refs.checkButton.disabled = false;
      }
    }));
  }

  _createClass(UpdatesPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.clearPackageCards();
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      return _etch2['default'].dom(
        'div',
        { tabIndex: '0', className: 'panels-item' },
        _etch2['default'].dom(
          'section',
          { className: 'section packages' },
          _etch2['default'].dom(
            'div',
            { className: 'section-container updates-container' },
            _etch2['default'].dom(
              'div',
              { className: 'updates-heading-container' },
              _etch2['default'].dom(
                'h1',
                { className: 'section-heading icon icon-cloud-download' },
                'Available Updates'
              ),
              _etch2['default'].dom(
                'div',
                { className: 'section-heading updates-btn-group' },
                _etch2['default'].dom(
                  'button',
                  {
                    ref: 'updateAllButton',
                    className: 'pull-right update-all-button btn btn-primary',
                    onclick: function () {
                      _this2.updateAll();
                    } },
                  'Update All'
                ),
                _etch2['default'].dom(
                  'button',
                  {
                    ref: 'checkButton',
                    className: 'pull-right update-all-button btn btn',
                    onclick: function () {
                      _this2.checkForUpdates(true);
                    } },
                  'Check for Updates'
                )
              )
            ),
            _etch2['default'].dom(
              'div',
              { ref: 'versionPinnedPackagesMessage', className: 'alert alert-warning icon icon-alert' },
              'The following packages are pinned to their current version and are not being checked for updates: ',
              _etch2['default'].dom(
                'strong',
                null,
                this.packageManager.getVersionPinnedPackages().join(', ')
              )
            ),
            _etch2['default'].dom('div', { ref: 'updateErrors' }),
            _etch2['default'].dom(
              'div',
              { ref: 'checkingMessage', className: 'alert alert-info icon icon-hourglass' },
              'Checking for updates…'
            ),
            _etch2['default'].dom(
              'div',
              { ref: 'noUpdatesMessage', className: 'alert alert-info icon icon-heart' },
              'All of your installed packages are up to date!'
            ),
            _etch2['default'].dom('div', { ref: 'updatesContainer', className: 'container package-container' })
          )
        )
      );
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'beforeShow',
    value: function beforeShow(opts) {
      var _this3 = this;

      if (opts && opts.back) {
        this.refs.breadcrumb.textContent = opts.back;
        this.refs.breadcrumb.onclick = function () {
          _this3.settingsView.showPanel(opts.back);
        };
      }

      if (opts && opts.updates) {
        this.availableUpdates = opts.updates;
        this.addUpdateViews();
      } else {
        this.availableUpdates = [];
        this.clearPackageCards();
        this.checkForUpdates();
      }

      if (this.packageManager.getVersionPinnedPackages().length === 0) {
        this.refs.versionPinnedPackagesMessage.style.display = 'none';
      }
    }

    // Check for updates and display them
  }, {
    key: 'checkForUpdates',
    value: _asyncToGenerator(function* (clearCache) {
      this.refs.noUpdatesMessage.style.display = 'none';
      this.refs.updateAllButton.disabled = true;
      this.refs.checkButton.disabled = true;
      this.refs.checkingMessage.style.display = '';

      try {
        this.availableUpdates = yield this.packageManager.getOutdated(clearCache);
        this.refs.checkButton.disabled = false;
        this.addUpdateViews();
      } catch (error) {
        this.refs.checkButton.disabled = false;
        this.refs.checkingMessage.style.display = 'none';
        this.refs.updateErrors.appendChild(new _errorView2['default'](this.packageManager, error).element);
      }
    })
  }, {
    key: 'addUpdateViews',
    value: function addUpdateViews() {
      if (this.availableUpdates.length > 0) {
        this.refs.updateAllButton.style.display = '';
        this.refs.updateAllButton.disabled = false;
      }
      this.refs.checkingMessage.style.display = 'none';
      this.clearPackageCards();
      if (this.availableUpdates.length === 0) {
        this.refs.noUpdatesMessage.style.display = '';
      }

      for (var pack of this.availableUpdates) {
        var packageCard = new _packageCard2['default'](pack, this.settingsView, this.packageManager, { back: 'Updates' });
        this.refs.updatesContainer.appendChild(packageCard.element);
        this.packageCards.push(packageCard);
      }
    }
  }, {
    key: 'updateAll',
    value: function updateAll() {
      var _this4 = this;

      this.refs.checkButton.disabled = true;
      this.refs.updateAllButton.disabled = true;

      var successfulUpdatesCount = 0;
      var remainingPackagesCount = this.packageCards.length;
      var totalUpdatesCount = this.packageCards.length; // This value doesn't change unlike remainingPackagesCount

      var notifyIfDone = function notifyIfDone() {
        if (remainingPackagesCount === 0) {
          if (successfulUpdatesCount > 0) {
            var pluralizedPackages = 'package';
            if (successfulUpdatesCount > 1) {
              pluralizedPackages += 's';
            }
            var message = 'Restart Atom to complete the update of ' + successfulUpdatesCount + ' ' + pluralizedPackages + '.';

            var buttons = [{
              text: 'Restart',
              onDidClick: function onDidClick() {
                return atom.restartApplication();
              }
            }];
            atom.notifications.addSuccess(message, { dismissable: true, buttons: buttons });
          }

          if (successfulUpdatesCount === totalUpdatesCount) {
            _this4.refs.checkButton.disabled = false;
            _this4.refs.updateAllButton.style.display = 'none';
          } else {
            // Some updates failed
            _this4.refs.checkButton.disabled = false;
            _this4.refs.updateAllButton.disabled = false;
          }
        }
      };

      var onUpdateResolved = function onUpdateResolved() {
        remainingPackagesCount--;
        successfulUpdatesCount++;
        notifyIfDone();
      };

      var onUpdateRejected = function onUpdateRejected() {
        remainingPackagesCount--;
        notifyIfDone();
      };

      for (var packageCard of this.packageCards) {
        if (!this.updatingPackages.includes(packageCard.pack)) {
          packageCard.update().then(onUpdateResolved, onUpdateRejected);
        } else {
          remainingPackagesCount--;
          totalUpdatesCount--;
        }
      }
    }
  }, {
    key: 'clearPackageCards',
    value: function clearPackageCards() {
      var packageCard = null;
      while (packageCard = this.packageCards.pop()) {
        packageCard.destroy();
      }
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return UpdatesPanel;
})();

exports['default'] = UpdatesPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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