Object.defineProperty(exports, '__esModule', {
  value: true
});
var _bind = Function.prototype.bind;

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x2, _x3, _x4) { var _again = true; _function: while (_again) { var object = _x2, property = _x3, receiver = _x4; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x2 = parent; _x3 = property; _x4 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/** @babel */

var _atom = require('atom');

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _collapsibleSectionPanel = require('./collapsible-section-panel');

var _collapsibleSectionPanel2 = _interopRequireDefault(_collapsibleSectionPanel);

var _richDescription = require('./rich-description');

var SCOPED_SETTINGS = ['autoIndent', 'autoIndentOnPaste', 'invisibles', 'nonWordCharacters', 'preferredLineLength', 'scrollPastEnd', 'showIndentGuide', 'showInvisibles', 'softWrap', 'softWrapAtPreferredLineLength', 'softWrapHangingIndent', 'tabLength'];

var SettingsPanel = (function (_CollapsibleSectionPanel) {
  _inherits(SettingsPanel, _CollapsibleSectionPanel);

  function SettingsPanel() {
    var options = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

    _classCallCheck(this, SettingsPanel);

    _get(Object.getPrototypeOf(SettingsPanel.prototype), 'constructor', this).call(this);
    var namespace = options.namespace;
    this.element = document.createElement('section');
    this.element.classList.add('section', 'settings-panel');
    this.options = options;
    this.disposables = new _atom.CompositeDisposable();
    var settings = undefined;
    if (this.options.scopeName) {
      namespace = 'editor';
      settings = {};
      for (var _name of SCOPED_SETTINGS) {
        settings[_name] = atom.config.get(_name, { scope: [this.options.scopeName] });
      }
    } else {
      settings = atom.config.get(namespace);
    }

    this.element.appendChild(this.elementForSettings(namespace, settings));

    this.disposables.add(this.bindInputFields());
    this.disposables.add(this.bindSelectFields());
    this.disposables.add(this.bindEditors());
    this.disposables.add(this.bindTooltips());
    this.disposables.add(this.handleEvents());
  }

  /*
   * Space Pen Helpers
   */

  _createClass(SettingsPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      this.element.remove();
    }
  }, {
    key: 'elementForSettings',
    value: function elementForSettings(namespace, settings) {
      if (_underscorePlus2['default'].isEmpty(settings)) {
        return document.createDocumentFragment();
      }

      var title = this.options.title;

      var includeTitle = this.options.includeTitle != null ? this.options.includeTitle : true;
      if (includeTitle) {
        if (title == null) {
          title = _underscorePlus2['default'].undasherize(_underscorePlus2['default'].uncamelcase(namespace)) + ' Settings';
        }
      } else {
        if (title == null) {
          title = "Settings";
        }
      }

      var icon = this.options.icon != null ? this.options.icon : 'gear';
      var note = this.options.note;

      var sortedSettings = this.sortSettings(namespace, settings);

      var container = document.createElement('div');
      container.classList.add('section-container');

      var heading = document.createElement('div');
      heading.classList.add('block', 'section-heading', 'icon', 'icon-' + icon);
      heading.textContent = title;
      container.appendChild(heading);

      if (note) {
        container.insertAdjacentHTML('beforeend', note);
      }

      var body = document.createElement('div');
      body.classList.add('section-body');
      for (var _name2 of sortedSettings) {
        body.appendChild(elementForSetting(namespace, _name2, settings[_name2]));
      }
      container.appendChild(body);

      return container;
    }
  }, {
    key: 'sortSettings',
    value: function sortSettings(namespace, settings) {
      return _sortSettings(namespace, settings);
    }
  }, {
    key: 'bindInputFields',
    value: function bindInputFields() {
      var _this = this;

      var disposables = Array.from(this.element.querySelectorAll('input[id]')).map(function (input) {
        var name = input.id;
        var type = input.type;

        _this.observe(name, function (value) {
          if (type === 'checkbox') {
            input.checked = value;
          } else {
            if (type === 'color') {
              if (value && value.toHexString && value.toHexString()) {
                value = value.toHexString();
              }
            }

            if (value) {
              input.value = value;
            }
          }
        });

        var changeHandler = function changeHandler() {
          var value = input.value;
          if (type === 'checkbox') {
            value = input.checked;
          } else {
            value = _this.parseValue(type, value);
          }

          if (type === 'color') {
            // This is debounced since the color wheel fires lots of events
            // as you are dragging it around
            clearTimeout(_this.colorDebounceTimeout);
            _this.colorDebounceTimeout = setTimeout(function () {
              _this.set(name, value);
            }, 100);
          } else {
            _this.set(name, value);
          }
        };

        input.addEventListener('change', changeHandler);
        return new _atom.Disposable(function () {
          return input.removeEventListener('change', changeHandler);
        });
      });

      return new (_bind.apply(_atom.CompositeDisposable, [null].concat(_toConsumableArray(disposables))))();
    }
  }, {
    key: 'observe',
    value: function observe(name, callback) {
      var params = { sources: [atom.config.getUserConfigPath()] };
      if (this.options.scopeName != null) {
        params.scope = [this.options.scopeName];
      }
      this.disposables.add(atom.config.observe(name, params, callback));
    }
  }, {
    key: 'isDefault',
    value: function isDefault(name) {
      var params = { sources: [atom.config.getUserConfigPath()] };
      if (this.options.scopeName != null) {
        params.scope = [this.options.scopeName];
      }
      var defaultValue = this.getDefault(name);
      var value = atom.config.get(name, params);
      return value == null || defaultValue === value;
    }
  }, {
    key: 'getDefault',
    value: function getDefault(name) {
      if (this.options.scopeName != null) {
        return atom.config.get(name);
      } else {
        var params = { excludeSources: [atom.config.getUserConfigPath()] };
        if (this.options.scopeName != null) {
          params.scope = [this.options.scopeName];
        }
        return atom.config.get(name, params);
      }
    }
  }, {
    key: 'set',
    value: function set(name, value) {
      if (this.options.scopeName) {
        if (value === undefined) {
          atom.config.unset(name, { scopeSelector: this.options.scopeName });
        } else {
          atom.config.set(name, value, { scopeSelector: this.options.scopeName });
        }
      } else {
        atom.config.set(name, value);
      }
    }
  }, {
    key: 'bindSelectFields',
    value: function bindSelectFields() {
      var _this2 = this;

      var disposables = Array.from(this.element.querySelectorAll('select[id]')).map(function (select) {
        var name = select.id;
        _this2.observe(name, function (value) {
          return select.value = value;
        });
        var changeHandler = function changeHandler() {
          _this2.set(name, select.value);
        };
        select.addEventListener('change', changeHandler);
        return new _atom.Disposable(function () {
          return select.removeEventListener('change', changeHandler);
        });
      });

      return new (_bind.apply(_atom.CompositeDisposable, [null].concat(_toConsumableArray(disposables))))();
    }
  }, {
    key: 'bindEditors',
    value: function bindEditors() {
      var _this3 = this;

      var disposables = Array.from(this.element.querySelectorAll('atom-text-editor')).map(function (editorElement) {
        var defaultValue = undefined,
            left = undefined;
        var editor = editorElement.getModel();
        var name = editorElement.id;
        var type = editorElement.getAttribute('type');

        if (defaultValue = _this3.valueToString(_this3.getDefault(name))) {
          if (_this3.options.scopeName != null) {
            editor.setPlaceholderText('Unscoped value: ' + defaultValue);
          } else {
            editor.setPlaceholderText('Default: ' + defaultValue);
          }
        }

        var subscriptions = new _atom.CompositeDisposable();

        var focusHandler = function focusHandler() {
          if (_this3.isDefault(name)) {
            editor.setText((left = _this3.valueToString(_this3.getDefault(name))) != null ? left : '');
          }
        };
        editorElement.addEventListener('focus', focusHandler);
        subscriptions.add(new _atom.Disposable(function () {
          return editorElement.removeEventListener('focus', focusHandler);
        }));

        var blurHandler = function blurHandler() {
          if (_this3.isDefault(name)) {
            editor.setText('');
          }
        };
        editorElement.addEventListener('blur', blurHandler);
        subscriptions.add(new _atom.Disposable(function () {
          return editorElement.removeEventListener('blur', blurHandler);
        }));

        _this3.observe(name, function (value) {
          var stringValue = undefined;
          if (_this3.isDefault(name)) {
            stringValue = '';
          } else {
            stringValue = (left = _this3.valueToString(value)) != null ? left : '';
          }

          if (stringValue === editor.getText() || _underscorePlus2['default'].isEqual(value, _this3.parseValue(type, editor.getText()))) {
            return;
          }

          editor.setText(stringValue);
        });

        subscriptions.add(editor.onDidStopChanging(function () {
          _this3.set(name, _this3.parseValue(type, editor.getText()));
        }));

        return subscriptions;
      });

      return new (_bind.apply(_atom.CompositeDisposable, [null].concat(_toConsumableArray(disposables))))();
    }
  }, {
    key: 'bindTooltips',
    value: function bindTooltips() {
      var _this4 = this;

      var disposables = Array.from(this.element.querySelectorAll('input[id], select[id], atom-text-editor[id]')).map(function (element) {
        var defaultValue = _this4.valueToString(_this4.getDefault(element.id));
        if (defaultValue) {
          return atom.tooltips.add(element, {
            title: 'Default: ' + defaultValue,
            delay: { show: 100 },
            placement: 'auto left'
          });
        } else {
          return new _atom.Disposable(function () {}); // no-op
        }
      });

      return new (_bind.apply(_atom.CompositeDisposable, [null].concat(_toConsumableArray(disposables))))();
    }
  }, {
    key: 'valueToString',
    value: function valueToString(value) {
      if (Array.isArray(value)) {
        return value.join(', ');
      } else if (value) {
        return value.toString();
      } else {
        return null;
      }
    }
  }, {
    key: 'parseValue',
    value: function parseValue(type, value) {
      if (value === '') {
        return undefined;
      } else if (type === 'number') {
        var floatValue = parseFloat(value);
        if (isNaN(floatValue)) {
          return value;
        } else {
          return floatValue;
        }
      } else if (type === 'array') {
        var arrayValue = (value || '').split(',');
        return arrayValue.filter(function (val) {
          return val;
        }).map(function (val) {
          return val.trim();
        });
      } else {
        return value;
      }
    }
  }]);

  return SettingsPanel;
})(_collapsibleSectionPanel2['default']);

exports['default'] = SettingsPanel;
var isEditableArray = function isEditableArray(array) {
  for (var item of array) {
    if (!_underscorePlus2['default'].isString(item)) {
      return false;
    }
  }
  return true;
};

function _sortSettings(namespace, settings) {
  return _underscorePlus2['default'].chain(settings).keys().sortBy(function (name) {
    return name;
  }).sortBy(function (name) {
    var schema = atom.config.getSchema(namespace + '.' + name);
    return schema ? schema.order : null;
  }).value();
}

function elementForSetting(namespace, name, value) {
  if (namespace === 'core') {
    if (name === 'themes') {
      return document.createDocumentFragment();
    } // Handled in the Themes panel
    if (name === 'disabledPackages') {
      return document.createDocumentFragment();
    } // Handled in the Packages panel
    if (name === 'customFileTypes') {
      return document.createDocumentFragment();
    }
  }

  if (namespace === 'editor') {
    // There's no global default for these, they are defined by language packages
    if (['commentStart', 'commentEnd', 'increaseIndentPattern', 'decreaseIndentPattern', 'foldEndPattern'].includes(name)) {
      return document.createDocumentFragment();
    }
  }

  var controlGroup = document.createElement('div');
  controlGroup.classList.add('control-group');

  var controls = document.createElement('div');
  controls.classList.add('controls');
  controlGroup.appendChild(controls);

  var schema = atom.config.getSchema(namespace + '.' + name);
  if (schema && schema['enum']) {
    controls.appendChild(elementForOptions(namespace, name, value));
  } else if (schema && schema.type === 'color') {
    controls.appendChild(elementForColor(namespace, name, value));
  } else if (_underscorePlus2['default'].isBoolean(value) || schema && schema.type === 'boolean') {
    controls.appendChild(elementForCheckbox(namespace, name, value));
  } else if (_underscorePlus2['default'].isArray(value) || schema && schema.type === 'array') {
    if (isEditableArray(value)) {
      controls.appendChild(elementForArray(namespace, name, value));
    }
  } else if (_underscorePlus2['default'].isObject(value) || schema && schema.type === 'object') {
    controls.appendChild(elementForObject(namespace, name, value));
  } else {
    controls.appendChild(elementForEditor(namespace, name, value));
  }

  return controlGroup;
}

function getSettingTitle(keyPath, name) {
  if (name == null) {
    name = '';
  }
  var schema = atom.config.getSchema(keyPath);
  var title = schema != null ? schema.title : null;
  return title || _underscorePlus2['default'].uncamelcase(name).split('.').map(_underscorePlus2['default'].capitalize).join(' ');
}

function elementForOptions(namespace, name, value) {
  var keyPath = namespace + '.' + name;
  var schema = atom.config.getSchema(keyPath);
  var options = schema && schema['enum'] ? schema['enum'] : [];

  var fragment = document.createDocumentFragment();

  var label = document.createElement('label');
  label.classList.add('control-label');

  var titleDiv = document.createElement('div');
  titleDiv.classList.add('setting-title');
  titleDiv.textContent = getSettingTitle(keyPath, name);
  label.appendChild(titleDiv);

  var descriptionDiv = document.createElement('div');
  descriptionDiv.classList.add('setting-description');
  descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
  label.appendChild(descriptionDiv);

  fragment.appendChild(label);

  var select = document.createElement('select');
  select.id = keyPath;
  select.classList.add('form-control');
  for (var option of options) {
    var optionElement = document.createElement('option');
    if (option.hasOwnProperty('value')) {
      optionElement.value = option.value;
      optionElement.textContent = option.description;
    } else {
      optionElement.value = option;
      optionElement.textContent = option;
    }
    select.appendChild(optionElement);
  }

  fragment.appendChild(select);

  return fragment;
}

function elementForCheckbox(namespace, name, value) {
  var keyPath = namespace + '.' + name;

  var div = document.createElement('div');
  div.classList.add('checkbox');

  var label = document.createElement('label');
  label['for'] = keyPath;

  var input = document.createElement('input');
  input.id = keyPath;
  input.type = 'checkbox';
  input.classList.add('input-checkbox');
  label.appendChild(input);

  var titleDiv = document.createElement('div');
  titleDiv.classList.add('setting-title');
  titleDiv.textContent = getSettingTitle(keyPath, name);
  label.appendChild(titleDiv);
  div.appendChild(label);

  var descriptionDiv = document.createElement('div');
  descriptionDiv.classList.add('setting-description');
  descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
  div.appendChild(descriptionDiv);

  return div;
}

function elementForColor(namespace, name, value) {
  var keyPath = namespace + '.' + name;

  var div = document.createElement('div');
  div.classList.add('color');

  var label = document.createElement('label');
  label['for'] = keyPath;

  var input = document.createElement('input');
  input.id = keyPath;
  input.type = 'color';
  label.appendChild(input);

  var titleDiv = document.createElement('div');
  titleDiv.classList.add('setting-title');
  titleDiv.textContent = getSettingTitle(keyPath, name);
  label.appendChild(titleDiv);
  div.appendChild(label);

  var descriptionDiv = document.createElement('div');
  descriptionDiv.classList.add('setting-description');
  descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
  div.appendChild(descriptionDiv);

  return div;
}

function elementForEditor(namespace, name, value) {
  var keyPath = namespace + '.' + name;
  var type = _underscorePlus2['default'].isNumber(value) ? 'number' : 'string';

  var fragment = document.createDocumentFragment();

  var label = document.createElement('label');
  label.classList.add('control-label');

  var titleDiv = document.createElement('div');
  titleDiv.classList.add('setting-title');
  titleDiv.textContent = getSettingTitle(keyPath, name);
  label.appendChild(titleDiv);

  var descriptionDiv = document.createElement('div');
  descriptionDiv.classList.add('setting-description');
  descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
  label.appendChild(descriptionDiv);
  fragment.appendChild(label);

  var controls = document.createElement('div');
  controls.classList.add('controls');

  var editorContainer = document.createElement('div');
  editorContainer.classList.add('editor-container');

  var editor = new _atom.TextEditor({ mini: true });
  editor.element.id = keyPath;
  editor.element.setAttribute('type', type);
  editorContainer.appendChild(editor.element);
  controls.appendChild(editorContainer);
  fragment.appendChild(controls);

  return fragment;
}

function elementForArray(namespace, name, value) {
  var keyPath = namespace + '.' + name;

  var fragment = document.createDocumentFragment();

  var label = document.createElement('label');
  label.classList.add('control-label');

  var titleDiv = document.createElement('div');
  titleDiv.classList.add('setting-title');
  titleDiv.textContent = getSettingTitle(keyPath, name);
  label.appendChild(titleDiv);

  var descriptionDiv = document.createElement('div');
  descriptionDiv.classList.add('setting-description');
  descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
  label.appendChild(descriptionDiv);
  fragment.appendChild(label);

  var controls = document.createElement('div');
  controls.classList.add('controls');

  var editorContainer = document.createElement('div');
  editorContainer.classList.add('editor-container');

  var editor = new _atom.TextEditor({ mini: true });
  editor.element.id = keyPath;
  editor.element.setAttribute('type', 'array');
  editorContainer.appendChild(editor.element);
  controls.appendChild(editorContainer);
  fragment.appendChild(controls);

  return fragment;
}

function elementForObject(namespace, name, value) {
  if (_underscorePlus2['default'].keys(value).length === 0) {
    return document.createDocumentFragment();
  } else {
    var keyPath = namespace + '.' + name;
    var schema = atom.config.getSchema(keyPath);
    var isCollapsed = schema.collapsed === true;

    var section = document.createElement('section');
    section.classList.add('sub-section');
    if (isCollapsed) {
      section.classList.add('collapsed');
    }

    var h3 = document.createElement('h3');
    h3.classList.add('sub-section-heading', 'has-items');
    h3.textContent = getSettingTitle(keyPath, name);
    section.appendChild(h3);

    var div = document.createElement('div');
    div.classList.add('sub-section-body');
    for (var key of _sortSettings(keyPath, value)) {
      div.appendChild(elementForSetting(namespace, name + '.' + key, value[key]));
    }
    section.appendChild(div);

    return section;
  }
}
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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