Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var PackageUpdatesStatusView = (function () {
  function PackageUpdatesStatusView() {
    _classCallCheck(this, PackageUpdatesStatusView);
  }

  _createClass(PackageUpdatesStatusView, [{
    key: 'initialize',
    value: function initialize(statusBar, packageManager, updates) {
      var _this = this;

      this.statusBar = statusBar;
      this.updates = updates;
      this.destroyed = true;
      this.updatingPackages = [];
      this.failedUpdates = [];
      this.disposables = new _atom.CompositeDisposable();

      this.element = document.createElement('div');
      this.element.classList.add('package-updates-status-view', 'inline-block', 'text', 'text-info');

      var iconPackage = document.createElement('span');
      iconPackage.classList.add('icon', 'icon-package');
      this.element.appendChild(iconPackage);

      this.countLabel = document.createElement('span');
      this.countLabel.classList.add('available-updates-status');
      this.element.appendChild(this.countLabel);

      this.disposables.add(packageManager.on('package-update-available theme-update-available', function (_ref) {
        var pack = _ref.pack;
        var error = _ref.error;
        _this.onPackageUpdateAvailable(pack);
      }));
      this.disposables.add(packageManager.on('package-updating theme-updating', function (_ref2) {
        var pack = _ref2.pack;
        var error = _ref2.error;
        _this.onPackageUpdating(pack);
      }));
      this.disposables.add(packageManager.on('package-updated theme-updated', function (_ref3) {
        var pack = _ref3.pack;
        var error = _ref3.error;
        _this.onPackageUpdated(pack);
      }));
      this.disposables.add(packageManager.on('package-update-failed theme-update-failed', function (_ref4) {
        var pack = _ref4.pack;
        var error = _ref4.error;
        _this.onPackageUpdateFailed(pack);
      }));

      var clickHandler = function clickHandler() {
        atom.commands.dispatch(atom.views.getView(atom.workspace), 'settings-view:check-for-package-updates');
      };
      this.element.addEventListener('click', clickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this.element.removeEventListener('click', clickHandler);
      }));

      this.updateTile();
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      this.element.remove();

      if (this.tile) {
        this.tile.destroy();
        this.tile = null;
      }

      if (this.tooltip) {
        this.tooltip.dispose();
        this.tooltip = null;
      }
    }
  }, {
    key: 'onPackageUpdateAvailable',
    value: function onPackageUpdateAvailable(pack) {
      for (var update of this.updates) {
        if (update.name === pack.name) {
          return;
        }
      }

      this.updates.push(pack);
      this.updateTile();
    }
  }, {
    key: 'onPackageUpdating',
    value: function onPackageUpdating(pack) {
      this.updatingPackages.push(pack);
      this.updateTile();
    }
  }, {
    key: 'onPackageUpdated',
    value: function onPackageUpdated(pack) {
      for (var index = 0; index < this.updates.length; index++) {
        var update = this.updates[index];
        if (update.name === pack.name) {
          this.updates.splice(index, 1);
        }
      }

      for (var index = 0; index < this.updatingPackages.length; index++) {
        var update = this.updatingPackages[index];
        if (update.name === pack.name) {
          this.updatingPackages.splice(index, 1);
        }
      }

      for (var index = 0; index < this.failedUpdates.length; index++) {
        var update = this.failedUpdates[index];
        if (update.name === pack.name) {
          this.failedUpdates.splice(index, 1);
        }
      }

      this.updateTile();
    }
  }, {
    key: 'onPackageUpdateFailed',
    value: function onPackageUpdateFailed(pack) {
      for (var update of this.failedUpdates) {
        if (update.name === pack.name) {
          return;
        }
      }

      for (var index = 0; index < this.updatingPackages.length; index++) {
        var update = this.updatingPackages[index];
        if (update.name === pack.name) {
          this.updatingPackages.splice(index, 1);
        }
      }

      this.failedUpdates.push(pack);
      this.updateTile();
    }
  }, {
    key: 'updateTile',
    value: function updateTile() {
      if (this.updates.length) {
        if (this.tooltip) {
          this.tooltip.dispose();
          this.tooltip = null;
        }

        if (this.destroyed) {
          // Priority of -99 should put us just to the left of the Squirrel icon, which displays when Atom has updates available
          this.tile = this.statusBar.addRightTile({ item: this, priority: -99 });
          this.destroyed = false;
        }

        var labelText = '' + _underscorePlus2['default'].pluralize(this.updates.length, 'update'); // 5 updates
        var tooltipText = _underscorePlus2['default'].pluralize(this.updates.length, 'package update') + ' available';

        if (this.updatingPackages.length) {
          labelText = this.updatingPackages.length + '/' + this.updates.length + ' updating'; // 3/5 updating
          tooltipText += ', ' + _underscorePlus2['default'].pluralize(this.updatingPackages.length, 'package') + ' currently updating';
        }

        if (this.failedUpdates.length) {
          labelText += ' (' + this.failedUpdates.length + ' failed)'; // 1 update (1 failed), or 3/5 updating (1 failed)
          tooltipText += ', ' + _underscorePlus2['default'].pluralize(this.failedUpdates.length, 'failed update');
        }

        this.countLabel.textContent = labelText;
        this.tooltip = atom.tooltips.add(this.element, { title: tooltipText });
      } else if (!this.destroyed) {
        this.tile.destroy();
        this.tile = null;
        this.destroyed = true;
      }
    }
  }]);

  return PackageUpdatesStatusView;
})();

exports['default'] = PackageUpdatesStatusView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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