Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

// View to display the snippets that a package has registered.

var PackageSnippetsView = (function () {
  function PackageSnippetsView(packagePath, snippetsProvider) {
    _classCallCheck(this, PackageSnippetsView);

    this.snippetsProvider = snippetsProvider;
    this.packagePath = _path2['default'].join(packagePath, _path2['default'].sep);
    _etch2['default'].initialize(this);
    this.element.style.display = 'none';
    this.addSnippets();
  }

  _createClass(PackageSnippetsView, [{
    key: 'destroy',
    value: function destroy() {
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'section',
        { className: 'section' },
        _etch2['default'].dom(
          'div',
          { className: 'section-heading icon icon-code' },
          'Snippets'
        ),
        _etch2['default'].dom(
          'table',
          { className: 'package-snippets-table table native-key-bindings text', tabIndex: -1 },
          _etch2['default'].dom(
            'thead',
            null,
            _etch2['default'].dom(
              'tr',
              null,
              _etch2['default'].dom(
                'th',
                null,
                'Trigger'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Name'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Body'
              )
            )
          ),
          _etch2['default'].dom('tbody', { ref: 'snippets' })
        )
      );
    }
  }, {
    key: 'getSnippetProperties',
    value: function getSnippetProperties() {
      var packageProperties = {};
      for (var _ref2 of this.snippetsProvider.getSnippets()) {
        var _name = _ref2.name;
        var properties = _ref2.properties;

        if (_name && _name.indexOf && _name.indexOf(this.packagePath) === 0) {
          var object = properties.snippets != null ? properties.snippets : {};
          for (var key in object) {
            var snippet = object[key];
            if (snippet != null) {
              if (packageProperties[key] == null) {
                packageProperties[_name] = snippet;
              }
            }
          }
        }
      }

      return _underscorePlus2['default'].values(packageProperties).sort(function (snippet1, snippet2) {
        var prefix1 = snippet1.prefix != null ? snippet1.prefix : '';
        var prefix2 = snippet2.prefix != null ? snippet2.prefix : '';
        return prefix1.localeCompare(prefix2);
      });
    }
  }, {
    key: 'getSnippets',
    value: function getSnippets(callback) {
      var _this = this;

      var snippetsPackage = atom.packages.getLoadedPackage('snippets');
      var snippetsModule = snippetsPackage ? snippetsPackage.mainModule : null;
      if (snippetsModule) {
        if (snippetsModule.loaded) {
          callback(this.getSnippetProperties());
        } else {
          snippetsModule.onDidLoadSnippets(function () {
            return callback(_this.getSnippetProperties());
          });
        }
      } else {
        callback([]);
      }
    }
  }, {
    key: 'addSnippets',
    value: function addSnippets() {
      var _this2 = this;

      this.getSnippets(function (snippets) {
        _this2.refs.snippets.innerHTML = '';

        for (var _ref32 of snippets) {
          var body = _ref32.body;
          var bodyText = _ref32.bodyText;
          var _name2 = _ref32.name;
          var prefix = _ref32.prefix;

          if (_name2 == null) {
            _name2 = '';
          }

          if (prefix == null) {
            prefix = '';
          }

          if (body == null) {
            body = bodyText;
          }

          if (body) {
            body = body.replace(/\t/g, '\\t').replace(/\n/g, '\\n');
          } else {
            body = '';
          }

          var row = document.createElement('tr');

          var prefixTd = document.createElement('td');
          prefixTd.classList.add('snippet-prefix');
          prefixTd.textContent = prefix;
          row.appendChild(prefixTd);

          var nameTd = document.createElement('td');
          nameTd.textContent = _name2;
          row.appendChild(nameTd);

          var bodyTd = document.createElement('td');
          bodyTd.classList.add('snippet-body');
          bodyTd.textContent = body;
          row.appendChild(bodyTd);

          _this2.refs.snippets.appendChild(row);
        }

        if (_this2.refs.snippets.children.length > 0) {
          _this2.refs.snippets.style.display = '';
        } else {
          _this2.refs.snippets.style.display = 'none';
        }
      });
    }
  }]);

  return PackageSnippetsView;
})();

exports['default'] = PackageSnippetsView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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