Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _settingsPanel = require('./settings-panel');

var _settingsPanel2 = _interopRequireDefault(_settingsPanel);

var GeneralPanel = (function () {
  function GeneralPanel() {
    var _this = this;

    _classCallCheck(this, GeneralPanel);

    _etch2['default'].initialize(this);
    this.subscriptions = new _atom.CompositeDisposable();
    this.subscriptions.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));
  }

  _createClass(GeneralPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.subscriptions.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { tabIndex: '0', className: 'panels-item', onclick: this.didClick },
        _etch2['default'].dom(_settingsPanel2['default'], {
          ref: 'panel',
          namespace: 'core',
          icon: 'settings',
          note: '<div class="text icon icon-question" id="core-settings-note" tabindex="-1">These are Atom\'s core settings which affect behavior unrelated to text editing. Individual packages may have their own additional settings found within their package card in the <a class="link packages-open">Packages list</a>.</div>' })
      );
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'didClick',
    value: function didClick(event) {
      var target = event.target.closest('.packages-open');
      if (target) {
        atom.workspace.open('atom://config/packages');
      }
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return GeneralPanel;
})();

exports['default'] = GeneralPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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