(function() {
  var CompositeDisposable, Notification, NotificationElement, Notifications, StackTraceParser, fs, isCoreOrPackageStackTrace, ref;

  ref = require('atom'), Notification = ref.Notification, CompositeDisposable = ref.CompositeDisposable;

  fs = require('fs-plus');

  StackTraceParser = null;

  NotificationElement = require('./notification-element');

  Notifications = {
    isInitialized: false,
    subscriptions: null,
    duplicateTimeDelay: 500,
    lastNotification: null,
    activate: function(state) {
      var CommandLogger, i, len, notification, ref1;
      CommandLogger = require('./command-logger');
      CommandLogger.start();
      this.subscriptions = new CompositeDisposable;
      ref1 = atom.notifications.getNotifications();
      for (i = 0, len = ref1.length; i < len; i++) {
        notification = ref1[i];
        this.addNotificationView(notification);
      }
      this.subscriptions.add(atom.notifications.onDidAddNotification((function(_this) {
        return function(notification) {
          return _this.addNotificationView(notification);
        };
      })(this)));
      this.subscriptions.add(atom.onWillThrowError(function(arg) {
        var line, match, message, options, originalError, preventDefault, url;
        message = arg.message, url = arg.url, line = arg.line, originalError = arg.originalError, preventDefault = arg.preventDefault;
        if (originalError.name === 'BufferedProcessError') {
          message = message.replace('Uncaught BufferedProcessError: ', '');
          return atom.notifications.addError(message, {
            dismissable: true
          });
        } else if (originalError.code === 'ENOENT' && !/\/atom/i.test(message) && (match = /spawn (.+) ENOENT/.exec(message))) {
          message = "'" + match[1] + "' could not be spawned.\nIs it installed and on your path?\nIf so please open an issue on the package spawning the process.";
          return atom.notifications.addError(message, {
            dismissable: true
          });
        } else if (!atom.inDevMode() || atom.config.get('notifications.showErrorsInDevMode')) {
          preventDefault();
          if (originalError.stack && !isCoreOrPackageStackTrace(originalError.stack)) {
            return;
          }
          options = {
            detail: url + ":" + line,
            stack: originalError.stack,
            dismissable: true
          };
          return atom.notifications.addFatalError(message, options);
        }
      }));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'core:cancel', function() {
        var j, len1, ref2, results;
        ref2 = atom.notifications.getNotifications();
        results = [];
        for (j = 0, len1 = ref2.length; j < len1; j++) {
          notification = ref2[j];
          results.push(notification.dismiss());
        }
        return results;
      }));
      if (atom.inDevMode()) {
        this.subscriptions.add(atom.commands.add('atom-workspace', 'notifications:toggle-dev-panel', function() {
          return Notifications.togglePanel();
        }));
        return this.subscriptions.add(atom.commands.add('atom-workspace', 'notifications:trigger-error', function() {
          var error, options;
          try {
            return abc + 2;
          } catch (error1) {
            error = error1;
            options = {
              detail: error.stack.split('\n')[1],
              stack: error.stack,
              dismissable: true
            };
            return atom.notifications.addFatalError("Uncaught " + (error.stack.split('\n')[0]), options);
          }
        }));
      }
    },
    deactivate: function() {
      var ref1, ref2;
      this.subscriptions.dispose();
      if ((ref1 = this.notificationsElement) != null) {
        ref1.remove();
      }
      if ((ref2 = this.notificationsPanel) != null) {
        ref2.destroy();
      }
      this.subscriptions = null;
      this.notificationsElement = null;
      this.notificationsPanel = null;
      return this.isInitialized = false;
    },
    initializeIfNotInitialized: function() {
      if (this.isInitialized) {
        return;
      }
      this.subscriptions.add(atom.views.addViewProvider(Notification, function(model) {
        return new NotificationElement(model);
      }));
      this.notificationsElement = document.createElement('atom-notifications');
      atom.views.getView(atom.workspace).appendChild(this.notificationsElement);
      return this.isInitialized = true;
    },
    togglePanel: function() {
      var NotificationsPanelView;
      if (this.notificationsPanel != null) {
        if (Notifications.notificationsPanel.isVisible()) {
          return Notifications.notificationsPanel.hide();
        } else {
          return Notifications.notificationsPanel.show();
        }
      } else {
        NotificationsPanelView = require('./notifications-panel-view');
        Notifications.notificationsPanelView = new NotificationsPanelView;
        return Notifications.notificationsPanel = atom.workspace.addBottomPanel({
          item: Notifications.notificationsPanelView.getElement()
        });
      }
    },
    addNotificationView: function(notification) {
      var timeSpan;
      if (notification == null) {
        return;
      }
      this.initializeIfNotInitialized();
      if (notification.wasDisplayed()) {
        return;
      }
      if (this.lastNotification != null) {
        timeSpan = notification.getTimestamp() - this.lastNotification.getTimestamp();
        if (!(timeSpan < this.duplicateTimeDelay && notification.isEqual(this.lastNotification))) {
          this.notificationsElement.appendChild(atom.views.getView(notification).element);
        }
      } else {
        this.notificationsElement.appendChild(atom.views.getView(notification).element);
      }
      notification.setDisplayed(true);
      return this.lastNotification = notification;
    }
  };

  isCoreOrPackageStackTrace = function(stack) {
    var file, i, len, ref1;
    if (StackTraceParser == null) {
      StackTraceParser = require('stacktrace-parser');
    }
    ref1 = StackTraceParser.parse(stack);
    for (i = 0, len = ref1.length; i < len; i++) {
      file = ref1[i].file;
      if (file === '<embedded>' || fs.isAbsolute(file)) {
        return true;
      }
    }
    return false;
  };

  module.exports = Notifications;

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
