(function() {
  var Reporter, extend, getOsArch, getReleaseChannel, path, post, querystring,
    slice = [].slice;

  path = require('path');

  querystring = require('querystring');

  extend = function() {
    var i, key, len, propertyMap, propertyMaps, target, value;
    target = arguments[0], propertyMaps = 2 <= arguments.length ? slice.call(arguments, 1) : [];
    for (i = 0, len = propertyMaps.length; i < len; i++) {
      propertyMap = propertyMaps[i];
      for (key in propertyMap) {
        value = propertyMap[key];
        target[key] = value;
      }
    }
    return target;
  };

  post = function(url) {
    var xhr;
    xhr = new XMLHttpRequest();
    xhr.open('POST', url);
    return xhr.send(null);
  };

  getReleaseChannel = function() {
    var version;
    version = atom.getVersion();
    if (version.indexOf('beta') > -1) {
      return 'beta';
    } else if (version.indexOf('dev') > -1) {
      return 'dev';
    } else {
      return 'stable';
    }
  };

  getOsArch = function() {
    if (process.platform === 'win32' && process.env.PROCESSOR_ARCHITEW6432 === 'AMD64') {
      return 'x64';
    }
    return process.arch;
  };

  module.exports = Reporter = (function() {
    function Reporter() {}

    Reporter.consented = function() {
      return atom.config.get('core.telemetryConsent') === 'limited';
    };

    Reporter.sendEvent = function(category, action, label, value) {
      var params;
      params = {
        t: 'event',
        ec: category,
        ea: action
      };
      if (label != null) {
        params.el = label;
      }
      if (value != null) {
        params.ev = value;
      }
      return this.send(params);
    };

    Reporter.sendTiming = function(category, name, value) {
      var params;
      params = {
        t: 'timing',
        utc: category,
        utv: name,
        utt: value
      };
      return this.send(params);
    };

    Reporter.sendException = function(description) {
      var params;
      params = {
        t: 'exception',
        exd: description,
        exf: atom.inDevMode() ? '0' : '1'
      };
      return this.send(params);
    };

    Reporter.viewNameForPaneItem = function(item) {
      var extension, itemPath, name, ref;
      name = (ref = typeof item.getViewClass === "function" ? item.getViewClass().name : void 0) != null ? ref : item.constructor.name;
      itemPath = typeof item.getPath === "function" ? item.getPath() : void 0;
      if (!((itemPath != null) && path.dirname(itemPath) === atom.getConfigDirPath())) {
        return name;
      }
      extension = path.extname(itemPath);
      switch (path.basename(itemPath, extension)) {
        case 'config':
          if (extension === '.json' || extension === '.cson') {
            name = 'UserConfig';
          }
          break;
        case 'init':
          if (extension === '.js' || extension === '.coffee') {
            name = 'UserInitScript';
          }
          break;
        case 'keymap':
          if (extension === '.json' || extension === '.cson') {
            name = 'UserKeymap';
          }
          break;
        case 'snippets':
          if (extension === '.json' || extension === '.cson') {
            name = 'UserSnippets';
          }
          break;
        case 'styles':
          if (extension === '.css' || extension === '.less') {
            name = 'UserStylesheet';
          }
      }
      return name;
    };

    Reporter.sendPaneItem = function(item) {
      var grammarName, params, ref;
      params = {
        t: 'appview',
        cd: this.viewNameForPaneItem(item)
      };
      grammarName = typeof item.getGrammar === "function" ? (ref = item.getGrammar()) != null ? ref.name : void 0 : void 0;
      if (grammarName != null) {
        params.dt = grammarName;
      }
      return this.send(params);
    };

    Reporter.sendCommand = function(commandName) {
      var base, params;
      if (this.commandCount == null) {
        this.commandCount = {};
      }
      if ((base = this.commandCount)[commandName] == null) {
        base[commandName] = 0;
      }
      this.commandCount[commandName]++;
      params = {
        t: 'event',
        ec: 'command',
        ea: commandName.split(':')[0],
        el: commandName,
        ev: this.commandCount[commandName]
      };
      return this.send(params);
    };

    Reporter.send = function(params) {
      if (navigator.onLine) {
        extend(params, {
          v: 1,
          aip: 1,
          tid: 'UA-3769691-33',
          cid: localStorage.getItem('metrics.userId'),
          an: 'atom',
          av: atom.getVersion()
        });
        if (Reporter.consented()) {
          extend(params, Reporter.consentedParams());
        }
        if (Reporter.consented() || Reporter.isTelemetryConsentChoice(params)) {
          return Reporter.request("https://ssl.google-analytics.com/collect?" + (querystring.stringify(params)));
        }
      }
    };

    Reporter.isTelemetryConsentChoice = function(params) {
      return params.t === 'event' && params.ec === 'setting' && params.ea === 'core.telemetryConsent';
    };

    Reporter.request = function(url) {
      return post(url);
    };

    Reporter.consentedParams = function() {
      var memUse;
      memUse = process.memoryUsage();
      return {
        cd2: getOsArch(),
        cd3: process.arch,
        cm1: memUse.heapUsed >> 20,
        cm2: Math.round((memUse.heapUsed / memUse.heapTotal) * 100),
        sr: screen.width + "x" + screen.height,
        vp: innerWidth + "x" + innerHeight,
        aiid: getReleaseChannel()
      };
    };

    return Reporter;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
