(function() {
  var MarkdownPreviewView, fs, isMarkdownPreviewView, renderer, url,
    indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  url = require('url');

  fs = require('fs-plus');

  MarkdownPreviewView = null;

  renderer = null;

  isMarkdownPreviewView = function(object) {
    if (MarkdownPreviewView == null) {
      MarkdownPreviewView = require('./markdown-preview-view');
    }
    return object instanceof MarkdownPreviewView;
  };

  module.exports = {
    activate: function() {
      var previewFile;
      atom.commands.add('atom-workspace', {
        'markdown-preview:toggle': (function(_this) {
          return function() {
            return _this.toggle();
          };
        })(this),
        'markdown-preview:copy-html': (function(_this) {
          return function() {
            return _this.copyHtml();
          };
        })(this),
        'markdown-preview:save-as-html': (function(_this) {
          return function() {
            return _this.saveAsHtml();
          };
        })(this),
        'markdown-preview:toggle-break-on-single-newline': function() {
          var keyPath;
          keyPath = 'markdown-preview.breakOnSingleNewline';
          return atom.config.set(keyPath, !atom.config.get(keyPath));
        },
        'markdown-preview:toggle-github-style': function() {
          var keyPath;
          keyPath = 'markdown-preview.useGitHubStyle';
          return atom.config.set(keyPath, !atom.config.get(keyPath));
        }
      });
      previewFile = this.previewFile.bind(this);
      atom.commands.add('.tree-view .file .name[data-name$=\\.markdown]', 'markdown-preview:preview-file', previewFile);
      atom.commands.add('.tree-view .file .name[data-name$=\\.md]', 'markdown-preview:preview-file', previewFile);
      atom.commands.add('.tree-view .file .name[data-name$=\\.mdown]', 'markdown-preview:preview-file', previewFile);
      atom.commands.add('.tree-view .file .name[data-name$=\\.mkd]', 'markdown-preview:preview-file', previewFile);
      atom.commands.add('.tree-view .file .name[data-name$=\\.mkdown]', 'markdown-preview:preview-file', previewFile);
      atom.commands.add('.tree-view .file .name[data-name$=\\.ron]', 'markdown-preview:preview-file', previewFile);
      atom.commands.add('.tree-view .file .name[data-name$=\\.txt]', 'markdown-preview:preview-file', previewFile);
      return atom.workspace.addOpener((function(_this) {
        return function(uriToOpen) {
          var path, protocol, ref;
          ref = uriToOpen.split('://'), protocol = ref[0], path = ref[1];
          if (protocol !== 'markdown-preview') {
            return;
          }
          try {
            path = decodeURI(path);
          } catch (error1) {
            return;
          }
          if (path.startsWith('editor/')) {
            return _this.createMarkdownPreviewView({
              editorId: path.substring(7)
            });
          } else {
            return _this.createMarkdownPreviewView({
              filePath: path
            });
          }
        };
      })(this));
    },
    createMarkdownPreviewView: function(state) {
      if (state.editorId || fs.isFileSync(state.filePath)) {
        if (MarkdownPreviewView == null) {
          MarkdownPreviewView = require('./markdown-preview-view');
        }
        return new MarkdownPreviewView(state);
      }
    },
    toggle: function() {
      var editor, grammars, ref, ref1;
      if (isMarkdownPreviewView(atom.workspace.getActivePaneItem())) {
        atom.workspace.destroyActivePaneItem();
        return;
      }
      editor = atom.workspace.getActiveTextEditor();
      if (editor == null) {
        return;
      }
      grammars = (ref = atom.config.get('markdown-preview.grammars')) != null ? ref : [];
      if (ref1 = editor.getGrammar().scopeName, indexOf.call(grammars, ref1) < 0) {
        return;
      }
      if (!this.removePreviewForEditor(editor)) {
        return this.addPreviewForEditor(editor);
      }
    },
    uriForEditor: function(editor) {
      return "markdown-preview://editor/" + editor.id;
    },
    removePreviewForEditor: function(editor) {
      var previewPane, uri;
      uri = this.uriForEditor(editor);
      previewPane = atom.workspace.paneForURI(uri);
      if (previewPane != null) {
        previewPane.destroyItem(previewPane.itemForURI(uri));
        return true;
      } else {
        return false;
      }
    },
    addPreviewForEditor: function(editor) {
      var options, previousActivePane, uri;
      uri = this.uriForEditor(editor);
      previousActivePane = atom.workspace.getActivePane();
      options = {
        searchAllPanes: true
      };
      if (atom.config.get('markdown-preview.openPreviewInSplitPane')) {
        options.split = 'right';
      }
      return atom.workspace.open(uri, options).then(function(markdownPreviewView) {
        if (isMarkdownPreviewView(markdownPreviewView)) {
          return previousActivePane.activate();
        }
      });
    },
    previewFile: function(arg) {
      var editor, filePath, i, len, ref, target;
      target = arg.target;
      filePath = target.dataset.path;
      if (!filePath) {
        return;
      }
      ref = atom.workspace.getTextEditors();
      for (i = 0, len = ref.length; i < len; i++) {
        editor = ref[i];
        if (!(editor.getPath() === filePath)) {
          continue;
        }
        this.addPreviewForEditor(editor);
        return;
      }
      return atom.workspace.open("markdown-preview://" + (encodeURI(filePath)), {
        searchAllPanes: true
      });
    },
    copyHtml: function() {
      var editor, text;
      editor = atom.workspace.getActiveTextEditor();
      if (editor == null) {
        return;
      }
      if (renderer == null) {
        renderer = require('./renderer');
      }
      text = editor.getSelectedText() || editor.getText();
      return renderer.toHTML(text, editor.getPath(), editor.getGrammar(), function(error, html) {
        if (error) {
          return console.warn('Copying Markdown as HTML failed', error);
        } else {
          return atom.clipboard.write(html);
        }
      });
    },
    saveAsHtml: function() {
      var activePane, editor, grammars, markdownPreviewPane, previousActivePane, ref, ref1, uri;
      activePane = atom.workspace.getActivePaneItem();
      if (isMarkdownPreviewView(activePane)) {
        activePane.saveAs();
        return;
      }
      editor = atom.workspace.getActiveTextEditor();
      if (editor == null) {
        return;
      }
      grammars = (ref = atom.config.get('markdown-preview.grammars')) != null ? ref : [];
      if (ref1 = editor.getGrammar().scopeName, indexOf.call(grammars, ref1) < 0) {
        return;
      }
      uri = this.uriForEditor(editor);
      markdownPreviewPane = atom.workspace.paneForURI(uri);
      if (markdownPreviewPane == null) {
        return;
      }
      previousActivePane = atom.workspace.getActivePane();
      markdownPreviewPane.activate();
      activePane = atom.workspace.getActivePaneItem();
      if (isMarkdownPreviewView(activePane)) {
        return activePane.saveAs().then(function() {
          return previousActivePane.activate();
        });
      }
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
