Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

exports.activate = activate;
exports.deactivate = deactivate;
exports.consumeStatusBar = consumeStatusBar;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var _statusBarItem = require('./status-bar-item');

var _statusBarItem2 = _interopRequireDefault(_statusBarItem);

var _helpers = require('./helpers');

var _helpers2 = _interopRequireDefault(_helpers);

'use babel';

var LineEndingRegExp = /\r\n|\n/g;
var LFRegExp = /(^|[^\r])\n/g;
var CRLFRegExp = /\r\n/g;

var disposables = null;
var modalPanel = null;
var lineEndingListView = null;

function activate() {
  disposables = new _atom.CompositeDisposable();

  disposables.add(atom.commands.add('atom-text-editor', {
    'line-ending-selector:show': function lineEndingSelectorShow(event) {
      if (!modalPanel) {
        lineEndingListView = new _atomSelectList2['default']({
          items: [{ name: 'LF', value: '\n' }, { name: 'CRLF', value: '\r\n' }],
          filterKeyForItem: function filterKeyForItem(lineEnding) {
            return lineEnding.name;
          },
          didConfirmSelection: function didConfirmSelection(lineEnding) {
            // TODO[v1.19]: Remove conditional once atom.workspace.getActiveTextEditor ships in Atom v1.19
            if (atom.workspace.getActiveTextEditor) {
              setLineEnding(atom.workspace.getActiveTextEditor(), lineEnding.value);
            } else {
              setLineEnding(atom.workspace.getActivePaneItem(), lineEnding.value);
            }
            modalPanel.hide();
          },
          didCancelSelection: function didCancelSelection() {
            modalPanel.hide();
          },
          elementForItem: function elementForItem(lineEnding) {
            var element = document.createElement('li');
            element.textContent = lineEnding.name;
            return element;
          }
        });
        modalPanel = atom.workspace.addModalPanel({ item: lineEndingListView });
        disposables.add(new _atom.Disposable(function () {
          lineEndingListView.destroy();
          modalPanel.destroy();
          modalPanel = null;
        }));
      }

      lineEndingListView.reset();
      modalPanel.show();
      lineEndingListView.focus();
    },

    'line-ending-selector:convert-to-LF': function lineEndingSelectorConvertToLF(event) {
      var editorElement = event.target.closest('atom-text-editor');
      setLineEnding(editorElement.getModel(), '\n');
    },

    'line-ending-selector:convert-to-CRLF': function lineEndingSelectorConvertToCRLF(event) {
      var editorElement = event.target.closest('atom-text-editor');
      setLineEnding(editorElement.getModel(), '\r\n');
    }
  }));
}

function deactivate() {
  disposables.dispose();
}

function consumeStatusBar(statusBar) {
  var statusBarItem = new _statusBarItem2['default']();
  var currentBufferDisposable = null;
  var tooltipDisposable = null;

  var updateTile = _underscorePlus2['default'].debounce(function (buffer) {
    getLineEndings(buffer).then(function (lineEndings) {
      if (lineEndings.size === 0) {
        var defaultLineEnding = getDefaultLineEnding();
        buffer.setPreferredLineEnding(defaultLineEnding);
        lineEndings = new Set().add(defaultLineEnding);
      }
      statusBarItem.setLineEndings(lineEndings);
    });
  }, 0);

  var observeActiveItem = function observeActiveItem(item) {
    if (currentBufferDisposable) currentBufferDisposable.dispose();

    if (item && item.getBuffer) {
      (function () {
        var buffer = item.getBuffer();
        updateTile(buffer);
        currentBufferDisposable = buffer.onDidChange(function (_ref) {
          var oldText = _ref.oldText;
          var newText = _ref.newText;

          if (!statusBarItem.hasLineEnding('\n')) {
            if (newText.indexOf('\n') >= 0) {
              updateTile(buffer);
            }
          } else if (!statusBarItem.hasLineEnding('\r\n')) {
            if (newText.indexOf('\r\n') >= 0) {
              updateTile(buffer);
            }
          } else if (oldText.indexOf('\n')) {
            updateTile(buffer);
          }
        });
      })();
    } else {
      statusBarItem.setLineEndings(new Set());
      currentBufferDisposable = null;
    }

    if (tooltipDisposable) {
      disposables.remove(tooltipDisposable);
      tooltipDisposable.dispose();
    }
    tooltipDisposable = atom.tooltips.add(statusBarItem.element, {
      title: function title() {
        return 'File uses ' + statusBarItem.description() + ' line endings';
      }
    });
    disposables.add(tooltipDisposable);
  };

  // TODO[v1.19]: Remove conditional once atom.workspace.observeActiveTextEditor ships in Atom v1.19
  if (atom.workspace.observeActiveTextEditor) {
    disposables.add(atom.workspace.observeActiveTextEditor(observeActiveItem));
  } else {
    disposables.add(atom.workspace.observeActivePaneItem(observeActiveItem));
  }

  disposables.add(new _atom.Disposable(function () {
    if (currentBufferDisposable) currentBufferDisposable.dispose();
  }));

  statusBarItem.onClick(function () {
    var editor = undefined;

    // TODO[v1.19]: Remove conditional once atom.workspace.getActiveTextEditor ships in Atom v1.19
    if (atom.workspace.getActiveTextEditor) {
      editor = atom.workspace.getActiveTextEditor();
    } else {
      editor = atom.workspace.getActivePaneItem();
    }

    atom.commands.dispatch(atom.views.getView(editor), 'line-ending-selector:show');
  });

  var tile = statusBar.addRightTile({ item: statusBarItem, priority: 200 });
  disposables.add(new _atom.Disposable(function () {
    return tile.destroy();
  }));
}

function getDefaultLineEnding() {
  switch (atom.config.get('line-ending-selector.defaultLineEnding')) {
    case 'LF':
      return '\n';
    case 'CRLF':
      return '\r\n';
    case 'OS Default':
    default:
      return _helpers2['default'].getProcessPlatform() === 'win32' ? '\r\n' : '\n';
  }
}

function getLineEndings(buffer) {
  if (typeof buffer.find === 'function') {
    return Promise.all([buffer.find(LFRegExp), buffer.find(CRLFRegExp)]).then(function (_ref2) {
      var _ref22 = _slicedToArray(_ref2, 2);

      var hasLF = _ref22[0];
      var hasCRLF = _ref22[1];

      var result = new Set();
      if (hasLF) result.add('\n');
      if (hasCRLF) result.add('\r\n');
      return result;
    });
  } else {
    return new Promise(function (resolve) {
      var result = new Set();
      for (var i = 0; i < buffer.getLineCount() - 1; i++) {
        result.add(buffer.lineEndingForRow(i));
      }
      resolve(result);
    });
  }
}

function setLineEnding(item, lineEnding) {
  if (item && item.getBuffer) {
    var buffer = item.getBuffer();
    buffer.setPreferredLineEnding(lineEnding);
    buffer.setText(buffer.getText().replace(LineEndingRegExp, lineEnding));
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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