Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atom = require('atom');

var _imageEditor = require('./image-editor');

var _imageEditor2 = _interopRequireDefault(_imageEditor);

var _bytes = require('bytes');

var _bytes2 = _interopRequireDefault(_bytes);

var ImageEditorStatusView = (function () {
  function ImageEditorStatusView(statusBar) {
    var _this = this;

    _classCallCheck(this, ImageEditorStatusView);

    this.statusBar = statusBar;
    this.disposables = new _atom.CompositeDisposable();

    this.element = document.createElement('div');
    this.element.classList.add('status-image', 'inline-block');

    this.imageSizeStatus = document.createElement('span');
    this.imageSizeStatus.classList.add('image-size');
    this.element.appendChild(this.imageSizeStatus);

    this.attach();

    this.disposables.add(atom.workspace.onDidChangeActivePaneItem(function () {
      _this.updateImageSize();
    }));
  }

  _createClass(ImageEditorStatusView, [{
    key: 'attach',
    value: function attach() {
      this.statusBarTile = this.statusBar.addLeftTile({ item: this });
      this.updateImageSize();
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.statusBarTile.destroy();
      this.disposables.dispose();
    }
  }, {
    key: 'getImageSize',
    value: function getImageSize(_ref) {
      var originalHeight = _ref.originalHeight;
      var originalWidth = _ref.originalWidth;
      var imageSize = _ref.imageSize;

      this.imageSizeStatus.textContent = originalWidth + 'x' + originalHeight + ' ' + (0, _bytes2['default'])(imageSize);
      this.imageSizeStatus.style.display = '';
    }
  }, {
    key: 'updateImageSize',
    value: function updateImageSize() {
      var _this2 = this;

      if (this.imageLoadDisposable) {
        this.imageLoadDisposable.dispose();
      }

      var editor = atom.workspace.getActivePaneItem();
      if (editor instanceof _imageEditor2['default']) {
        this.editorView = editor.view;
        if (this.editorView.loaded) {
          this.getImageSize(this.editorView);
        }

        this.imageLoadDisposable = this.editorView.onDidLoad(function () {
          if (editor === atom.workspace.getActivePaneItem()) {
            _this2.getImageSize(_this2.editorView);
          }
        });
      } else {
        this.imageSizeStatus.style.display = 'none';
      }
    }
  }]);

  return ImageEditorStatusView;
})();

exports['default'] = ImageEditorStatusView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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