'use strict';

const qs = require('querystring');

var _require = require('electron');

const remote = _require.remote,
      ipc = _require.ipcRenderer;

var _require2 = require('dugite');

const GitProcess = _require2.GitProcess;
let AverageTracker = class AverageTracker {
  constructor() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : { limit: 10 };

    let limit = _ref.limit;

    // for now this serves a dual purpose - # of values tracked AND # discarded prior to starting avg calculation
    this.limit = limit;
    this.sum = 0;
    this.values = [];
  }

  addValue(value) {
    if (this.values.length >= this.limit) {
      const discardedValue = this.values.shift();
      this.sum -= discardedValue;
    }
    this.values.push(value);
    this.sum += value;
  }

  getAverage() {
    if (this.enoughData()) {
      return this.sum / this.limit;
    } else {
      return null;
    }
  }

  getLimit() {
    return this.limit;
  }

  enoughData() {
    return this.values.length === this.limit;
  }
};


const query = qs.parse(window.location.search.substr(1));
const sourceWebContentsId = remote.getCurrentWindow().webContents.id;
const operationCountLimit = parseInt(query.operationCountLimit, 10);
const averageTracker = new AverageTracker({ limit: operationCountLimit });
const childPidsById = new Map();

const destroyRenderer = () => {
  if (!managerWebContents.isDestroyed()) {
    managerWebContents.removeListener('crashed', destroyRenderer);
    managerWebContents.removeListener('destroyed', destroyRenderer);
  }
  const win = remote.BrowserWindow.fromWebContents(remote.getCurrentWebContents());
  if (win && !win.isDestroyed()) {
    win.destroy();
  }
};
const managerWebContentsId = parseInt(query.managerWebContentsId, 10);
const managerWebContents = remote.webContents.fromId(managerWebContentsId);
if (managerWebContents && !managerWebContents.isDestroyed()) {
  managerWebContents.on('crashed', destroyRenderer);
  managerWebContents.on('destroyed', destroyRenderer);
  window.onbeforeunload = () => {
    managerWebContents.removeListener('crashed', destroyRenderer);
    managerWebContents.removeListener('destroyed', destroyRenderer);
  };
}

const channelName = query.channelName;
ipc.on(channelName, (event, _ref2) => {
  let type = _ref2.type,
      data = _ref2.data;

  if (type === 'git-exec') {
    const args = data.args,
          workingDir = data.workingDir,
          options = data.options,
          id = data.id;

    if (args) {
      document.getElementById('command').textContent = `git ${args.join(' ')}`;
    }

    options.processCallback = child => {
      childPidsById.set(id, child.pid);

      child.on('error', err => {
        event.sender.sendTo(managerWebContentsId, channelName, {
          sourceWebContentsId,
          type: 'git-spawn-error',
          data: { id, err }
        });
      });

      child.stdin.on('error', err => {
        event.sender.sendTo(managerWebContentsId, channelName, {
          sourceWebContentsId,
          type: 'git-stdin-error',
          data: { id, stdin: options.stdin, err }
        });
      });
    };

    const spawnStart = performance.now();
    GitProcess.exec(args, workingDir, options).then((_ref3) => {
      let stdout = _ref3.stdout,
          stderr = _ref3.stderr,
          exitCode = _ref3.exitCode;

      const timing = {
        spawnTime: spawnEnd - spawnStart,
        execTime: performance.now() - spawnEnd
      };
      childPidsById.delete(id);
      event.sender.sendTo(managerWebContentsId, channelName, {
        sourceWebContentsId,
        type: 'git-data',
        data: {
          id,
          average: averageTracker.getAverage(),
          results: { stdout, stderr, exitCode, timing }
        }
      });
    });
    const spawnEnd = performance.now();
    averageTracker.addValue(spawnEnd - spawnStart);

    // TODO: consider using this to avoid duplicate write operations upon crashing.
    // For now we won't do this to avoid clogging up ipc channel
    // event.sender.sendTo(managerWebContentsId, channelName, {sourceWebContentsId, type: 'exec-started', data: {id}});

    if (averageTracker.enoughData() && averageTracker.getAverage() > 20) {
      event.sender.sendTo(managerWebContentsId, channelName, { type: 'slow-spawns' });
    }
  } else if (type === 'git-cancel') {
    const id = data.id;

    const childPid = childPidsById.get(id);
    if (childPid !== undefined) {
      require('tree-kill')(childPid, 'SIGINT', () => {
        event.sender.sendTo(managerWebContentsId, channelName, {
          sourceWebContentsId,
          type: 'git-cancelled',
          data: { id, childPid }
        });
      });
      childPidsById.delete(id);
    }
  } else {
    throw new Error(`Could not identify type ${type}`);
  }
});

ipc.sendTo(managerWebContentsId, channelName, { sourceWebContentsId, type: 'renderer-ready', data: { pid: process.pid } });
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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