'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Operation = exports.RendererProcess = exports.Worker = exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _desc, _value, _class, _class2, _temp, _desc2, _value2, _class3, _class4, _temp2, _desc3, _value3, _class5, _class6, _temp3;

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _querystring = require('querystring');

var _querystring2 = _interopRequireDefault(_querystring);

var _electron = require('electron');

var _eventKit = require('event-kit');

var _coreDecorators = require('core-decorators');

var _helpers = require('./helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

const BrowserWindow = _electron.remote.BrowserWindow;
let WorkerManager = (_class = (_temp = _class2 = class WorkerManager {

  static getInstance() {
    if (!this.instance) {
      this.instance = new WorkerManager();
    }
    return this.instance;
  }

  static reset(force) {
    if (this.instance) {
      this.instance.destroy(force);
    }
    this.instance = null;
  }

  constructor() {
    this.workers = new Set();
    this.activeWorker = null;
    this.createNewWorker();
  }

  isReady() {
    return this.activeWorker.isReady();
  }

  request(data) {
    if (this.destroyed) {
      throw new Error('Worker is destroyed');
    }
    let operation;
    const requestPromise = new Promise((resolve, reject) => {
      operation = new Operation(data, resolve, reject);
      return this.activeWorker.executeOperation(operation);
    });
    operation.setPromise(requestPromise);
    return {
      cancel: () => this.activeWorker.cancelOperation(operation),
      promise: requestPromise
    };
  }

  createNewWorker() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : { operationCountLimit: 10 };

    let operationCountLimit = _ref.operationCountLimit;

    if (this.destroyed) {
      return;
    }
    this.activeWorker = new Worker({
      operationCountLimit,
      onDestroyed: this.onDestroyed,
      onCrashed: this.onCrashed,
      onSick: this.onSick
    });
    this.workers.add(this.activeWorker);
  }

  onDestroyed(destroyedWorker) {
    this.workers.delete(destroyedWorker);
  }

  onCrashed(crashedWorker) {
    if (crashedWorker === this.getActiveWorker()) {
      this.createNewWorker({ operationCountLimit: crashedWorker.getOperationCountLimit() });
    }
    crashedWorker.getRemainingOperations().forEach(operation => this.activeWorker.executeOperation(operation));
  }

  onSick(sickWorker) {
    if (!atom.inSpecMode()) {
      // eslint-disable-next-line no-console
      console.warn(`Sick worker detected.
        operationCountLimit: ${sickWorker.getOperationCountLimit()},
        completed operation count: ${sickWorker.getCompletedOperationCount()}`);
    }
    const operationCountLimit = this.calculateNewOperationCountLimit(sickWorker);
    return this.createNewWorker({ operationCountLimit });
  }

  calculateNewOperationCountLimit(lastWorker) {
    let operationCountLimit = 10;
    if (lastWorker.getOperationCountLimit() >= lastWorker.getCompletedOperationCount()) {
      operationCountLimit = Math.min(lastWorker.getOperationCountLimit() * 2, 100);
    }
    return operationCountLimit;
  }

  getActiveWorker() {
    return this.activeWorker;
  }

  getReadyPromise() {
    return this.activeWorker.getReadyPromise();
  }

  destroy(force) {
    this.destroyed = true;
    this.workers.forEach(worker => worker.destroy(force));
  }
}, _class2.instance = null, _temp), (_applyDecoratedDescriptor(_class.prototype, 'onDestroyed', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'onDestroyed'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'onCrashed', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'onCrashed'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'onSick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'onSick'), _class.prototype)), _class);
exports.default = WorkerManager;
let Worker = exports.Worker = (_class3 = (_temp2 = _class4 = class Worker {

  constructor(_ref2) {
    let operationCountLimit = _ref2.operationCountLimit,
        onSick = _ref2.onSick,
        onCrashed = _ref2.onCrashed,
        onDestroyed = _ref2.onDestroyed;

    this.operationCountLimit = operationCountLimit;
    this.onSick = onSick;
    this.onCrashed = onCrashed;
    this.onDestroyed = onDestroyed;

    this.operationsById = new Map();
    this.completedOperationCount = 0;
    this.sick = false;

    this.rendererProcess = new RendererProcess({
      loadUrl: this.getLoadUrl(operationCountLimit),
      onData: this.handleDataReceived,
      onCancelled: this.handleCancelled,
      onExecStarted: this.handleExecStarted,
      onSpawnError: this.handleSpawnError,
      onStdinError: this.handleStdinError,
      onSick: this.handleSick,
      onCrashed: this.handleCrashed,
      onDestroyed: this.destroy
    });
  }

  isReady() {
    return this.rendererProcess.isReady();
  }

  getLoadUrl(operationCountLimit) {
    const htmlPath = _path2.default.join((0, _helpers.getPackageRoot)(), 'lib', 'renderer.html');
    const rendererJsPath = _path2.default.join((0, _helpers.getPackageRoot)(), 'lib', 'worker.js');
    const qs = _querystring2.default.stringify({
      js: rendererJsPath,
      managerWebContentsId: this.getWebContentsId(),
      operationCountLimit,
      channelName: Worker.channelName
    });
    return `file://${htmlPath}?${qs}`;
  }

  getWebContentsId() {
    return _electron.remote.getCurrentWebContents().id;
  }

  executeOperation(operation) {
    this.operationsById.set(operation.id, operation);
    operation.onComplete(this.onOperationComplete);
    return this.rendererProcess.executeOperation(operation);
  }

  cancelOperation(operation) {
    return this.rendererProcess.cancelOperation(operation);
  }

  handleDataReceived(_ref3) {
    let id = _ref3.id,
        results = _ref3.results;

    const operation = this.operationsById.get(id);
    operation.complete(results, data => {
      const timing = data.timing;

      const totalInternalTime = timing.execTime + timing.spawnTime;
      const ipcTime = operation.getExecutionTime() - totalInternalTime;
      data.timing.ipcTime = ipcTime;
      return data;
    });
  }

  onOperationComplete(operation) {
    this.completedOperationCount++;
    this.operationsById.delete(operation.id);

    if (this.sick && this.operationsById.size === 0) {
      this.destroy();
    }
  }

  handleCancelled(_ref4) {
    let id = _ref4.id;

    const operation = this.operationsById.get(id);
    if (operation) {
      // handleDataReceived() can be received before handleCancelled()
      operation.wasCancelled();
    }
  }

  handleExecStarted(_ref5) {
    let id = _ref5.id;

    const operation = this.operationsById.get(id);
    operation.setInProgress();
  }

  handleSpawnError(_ref6) {
    let id = _ref6.id,
        err = _ref6.err;

    const operation = this.operationsById.get(id);
    operation.error(err);
  }

  handleStdinError(_ref7) {
    let id = _ref7.id,
        stdin = _ref7.stdin,
        err = _ref7.err;

    const operation = this.operationsById.get(id);
    operation.error(err);
  }

  handleSick() {
    this.sick = true;
    this.onSick(this);
  }

  handleCrashed() {
    this.onCrashed(this);
    this.destroy();
  }

  getOperationCountLimit() {
    return this.operationCountLimit;
  }

  getCompletedOperationCount() {
    return this.completedOperationCount;
  }

  getRemainingOperations() {
    return Array.from(this.operationsById.values());
  }

  getPid() {
    return this.rendererProcess.getPid();
  }

  getReadyPromise() {
    return this.rendererProcess.getReadyPromise();
  }

  destroy(force) {
    var _this = this;

    return _asyncToGenerator(function* () {
      _this.onDestroyed(_this);
      if (_this.operationsById.size > 0 && !force) {
        const remainingOperationPromises = _this.getRemainingOperations().map(function (operation) {
          return operation.getPromise().catch(function () {
            return null;
          });
        });
        yield Promise.all(remainingOperationPromises);
      }
      _this.rendererProcess.destroy();
    })();
  }
}, _class4.channelName = 'github:renderer-ipc', _temp2), (_applyDecoratedDescriptor(_class3.prototype, 'handleDataReceived', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class3.prototype, 'handleDataReceived'), _class3.prototype), _applyDecoratedDescriptor(_class3.prototype, 'onOperationComplete', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class3.prototype, 'onOperationComplete'), _class3.prototype), _applyDecoratedDescriptor(_class3.prototype, 'handleCancelled', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class3.prototype, 'handleCancelled'), _class3.prototype), _applyDecoratedDescriptor(_class3.prototype, 'handleExecStarted', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class3.prototype, 'handleExecStarted'), _class3.prototype), _applyDecoratedDescriptor(_class3.prototype, 'handleSpawnError', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class3.prototype, 'handleSpawnError'), _class3.prototype), _applyDecoratedDescriptor(_class3.prototype, 'handleStdinError', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class3.prototype, 'handleStdinError'), _class3.prototype), _applyDecoratedDescriptor(_class3.prototype, 'handleSick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class3.prototype, 'handleSick'), _class3.prototype), _applyDecoratedDescriptor(_class3.prototype, 'handleCrashed', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class3.prototype, 'handleCrashed'), _class3.prototype)), _class3);

/*
Sends operations to renderer processes
*/

let RendererProcess = exports.RendererProcess = (_class5 = class RendererProcess {
  constructor(_ref8) {
    let loadUrl = _ref8.loadUrl,
        onDestroyed = _ref8.onDestroyed,
        onCrashed = _ref8.onCrashed,
        onSick = _ref8.onSick,
        onData = _ref8.onData,
        onCancelled = _ref8.onCancelled,
        onSpawnError = _ref8.onSpawnError,
        onStdinError = _ref8.onStdinError,
        onExecStarted = _ref8.onExecStarted;

    this.onDestroyed = onDestroyed;
    this.onCrashed = onCrashed;
    this.onSick = onSick;
    this.onData = onData;
    this.onCancelled = onCancelled;
    this.onSpawnError = onSpawnError;
    this.onStdinError = onStdinError;
    this.onExecStarted = onExecStarted;

    this.win = new BrowserWindow({ show: !!process.env.ATOM_GITHUB_SHOW_RENDERER_WINDOW });
    this.webContents = this.win.webContents;
    // this.webContents.openDevTools();

    this.emitter = new _eventKit.Emitter();
    this.subscriptions = new _eventKit.CompositeDisposable();
    this.registerListeners();

    this.win.loadURL(loadUrl);
    this.win.webContents.on('crashed', this.handleDestroy);
    this.win.webContents.on('destroyed', this.handleDestroy);
    this.subscriptions.add(new _eventKit.Disposable(() => {
      if (!this.win.isDestroyed()) {
        this.win.webContents.removeListener('crashed', this.handleDestroy);
        this.win.webContents.removeListener('destroyed', this.handleDestroy);
        this.win.destroy();
      }
    }), this.emitter);

    this.ready = false;
    this.readyPromise = new Promise(resolve => {
      this.resolveReady = resolve;
    });
  }

  isReady() {
    return this.ready;
  }

  handleDestroy() {
    this.destroy();
    this.onCrashed(...arguments);
  }

  registerListeners() {
    const handleMessages = (event, _ref9) => {
      let sourceWebContentsId = _ref9.sourceWebContentsId,
          type = _ref9.type,
          data = _ref9.data;

      if (sourceWebContentsId === this.win.webContents.id) {
        this.emitter.emit(type, data);
      }
    };

    _electron.ipcRenderer.on(Worker.channelName, handleMessages);
    this.emitter.on('renderer-ready', (_ref10) => {
      let pid = _ref10.pid;

      this.pid = pid;
      this.ready = true;
      this.resolveReady();
    });
    this.emitter.on('git-data', this.onData);
    this.emitter.on('git-cancelled', this.onCancelled);
    this.emitter.on('git-spawn-error', this.onSpawnError);
    this.emitter.on('git-stdin-error', this.onStdinError);
    this.emitter.on('slow-spawns', this.onSick);

    // not currently used to avoid clogging up ipc channel
    // keeping it around as it's potentially useful for avoiding duplicate write operations upon renderer crashing
    this.emitter.on('exec-started', this.onExecStarted);

    this.subscriptions.add(new _eventKit.Disposable(() => _electron.ipcRenderer.removeListener(Worker.channelName, handleMessages)));
  }

  executeOperation(operation) {
    return operation.execute(payload => {
      if (this.destroyed) {
        return null;
      }
      return this.webContents.send(Worker.channelName, {
        type: 'git-exec',
        data: payload
      });
    });
  }

  cancelOperation(operation) {
    return operation.cancel(payload => {
      if (this.destroyed) {
        return null;
      }
      return this.webContents.send(Worker.channelName, {
        type: 'git-cancel',
        data: payload
      });
    });
  }

  getPid() {
    return this.pid;
  }

  getReadyPromise() {
    return this.readyPromise;
  }

  destroy() {
    this.destroyed = true;
    this.subscriptions.dispose();
  }
}, (_applyDecoratedDescriptor(_class5.prototype, 'handleDestroy', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class5.prototype, 'handleDestroy'), _class5.prototype)), _class5);
let Operation = exports.Operation = (_temp3 = _class6 = class Operation {

  constructor(data, resolve, reject) {
    this.id = Operation.id++;
    this.data = data;
    this.resolve = resolve;
    this.reject = reject;
    this.promise = null;
    this.cancellationResolve = () => {};
    this.startTime = null;
    this.endTime = null;
    this.status = Operation.status.PENDING;
    this.results = null;
    this.emitter = new _eventKit.Emitter();
  }

  onComplete(cb) {
    return this.emitter.on('complete', cb);
  }

  setPromise(promise) {
    this.promise = promise;
  }

  getPromise() {
    return this.promise;
  }

  setInProgress() {
    // after exec has been called but before results a received
    this.status = Operation.status.INPROGRESS;
  }

  getExecutionTime() {
    if (!this.startTime || !this.endTime) {
      return NaN;
    } else {
      return this.endTime - this.startTime;
    }
  }

  complete(results) {
    let mutate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : data => data;

    this.endTime = performance.now();
    this.results = results;
    this.resolve(mutate(results));
    this.cancellationResolve();
    this.status = Operation.status.COMPLETE;
    this.emitter.emit('complete', this);
    this.emitter.dispose();
  }

  wasCancelled() {
    this.status = Operation.status.CANCELLED;
    this.cancellationResolve();
  }

  error(results) {
    this.endTime = performance.now();
    const err = new Error(results.message, results.fileName, results.lineNumber);
    err.stack = results.stack;
    this.reject(err);
  }

  execute(execFn) {
    this.startTime = performance.now();
    return execFn(_extends({}, this.data, { id: this.id }));
  }

  cancel(execFn) {
    return new Promise(resolve => {
      this.status = Operation.status.CANCELLING;
      this.cancellationResolve = resolve;
      execFn({ id: this.id });
    });
  }
}, _class6.status = {
  PENDING: Symbol('pending'),
  INPROGRESS: Symbol('in-progress'),
  COMPLETE: Symbol('complete'),
  CANCELLING: Symbol('cancelling'),
  CANCELLED: Symbol('canceled')
}, _class6.id = 0, _temp3);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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