'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _moment = require('moment');

var _moment2 = _interopRequireDefault(_moment);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

let Timeago = (_temp = _class = class Timeago extends _react2.default.Component {

  static getTimeDisplay(time) {
    let now = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : (0, _moment2.default)();

    const m = (0, _moment2.default)(time);
    const diff = m.diff(now, 'months', true);
    if (Math.abs(diff) <= 1) {
      return m.from(now);
    } else {
      const format = m.format('MMM Do, YYYY');
      return `on ${format}`;
    }
  }

  render() {
    var _props = this.props;

    const type = _props.type,
          time = _props.time,
          others = _objectWithoutProperties(_props, ['type', 'time']);

    const display = Timeago.getTimeDisplay(time);
    const Type = type;
    const className = (0, _classnames2.default)('timeago', others.className);
    return _react2.default.createElement(
      Type,
      _extends({}, others, { className: className }),
      display
    );
  }
}, _class.propTypes = {
  time: _propTypes2.default.any.isRequired,
  type: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.func])
}, _class.defaultProps = {
  type: 'span'
}, _temp);
exports.default = Timeago;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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