'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let PushPullView = (_temp = _class = class PushPullView extends _react2.default.Component {

  render() {
    const pushing = this.props.pushInProgress;
    const pulling = this.props.fetchInProgress;
    const pushClasses = (0, _classnames2.default)('github-PushPull-icon', 'icon', { 'icon-arrow-up': !pushing, 'icon-sync': pushing });
    const pullClasses = (0, _classnames2.default)('github-PushPull-icon', 'icon', { 'icon-arrow-down': !pulling, 'icon-sync': pulling });
    return _react2.default.createElement(
      'div',
      { className: 'github-PushPull inline-block', ref: e => {
          this.element = e;
        } },
      _react2.default.createElement('span', { className: pullClasses }),
      _react2.default.createElement(
        'span',
        { className: 'github-PushPull-label is-pull' },
        this.props.behindCount ? `${this.props.behindCount}` : ''
      ),
      _react2.default.createElement('span', { className: pushClasses }),
      _react2.default.createElement(
        'span',
        { className: 'github-PushPull-label is-push' },
        this.props.aheadCount ? `${this.props.aheadCount}` : ''
      )
    );
  }
}, _class.propTypes = {
  pushInProgress: _propTypes2.default.bool,
  fetchInProgress: _propTypes2.default.bool,
  behindCount: _propTypes2.default.number,
  aheadCount: _propTypes2.default.number
}, _class.defaultProps = {
  pushInProgress: false,
  fetchInProgress: false,
  behindCount: 0,
  aheadCount: 0
}, _temp);
exports.default = PushPullView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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