'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * `Portal` is a mechanism for rendering a React subtree at a different place
 * in the DOM.
 *
 *    <Portal type="span" className="portal-class" appendNode={true}>
 *      <Stuff />
 *    </Portal>
 *
 * Given the above example, there will be a span with the class "portal-class"
 * created and appended to the document body, and then `<Stuff />` will be
 * rendered into it. Note that this uses `unstable_renderSubtreeIntoContainer`
 * to preserve context in the subtree.
 *
 * `getElement()` allows access to the React subtree container element.
 * `getRenderedSubtree()` allows access to the rendered subtree instance
 * (`Stuff` in the example above).
 *
 * Pass `false` (the default) to `appendNode` to skip adding the node to the
 * DOM. `type` defaults to "div" and `className` defaults to
 * "react-atom-portal".
 */
let Portal = (_temp = _class = class Portal extends _react2.default.Component {

  componentDidMount() {
    let node;
    if (this.props.getDOMNode) {
      node = this.props.getDOMNode();
    }

    if (!node) {
      node = document.createElement(this.props.type);
      node.className = this.props.className;
    }

    this.node = node;

    if (this.props.appendNode) {
      document.body.appendChild(this.node);
    }
    this.renderPortal(this.props);
  }

  componentWillReceiveProps(newProps) {
    this.renderPortal(newProps);
  }

  componentWillUnmount() {
    _reactDom2.default.unmountComponentAtNode(this.node);
    if (this.props.appendNode) {
      document.body.removeChild(this.node);
    }
  }

  renderPortal(props) {
    this.subtree = _reactDom2.default.unstable_renderSubtreeIntoContainer(this, props.children, this.node);
  }

  shouldComponentUpdate() {
    return false;
  }

  render() {
    return null;
  }

  getRenderedSubtree() {
    return this.subtree;
  }

  getElement() {
    return this.node;
  }

  getView() {
    if (this.view) {
      return this.view;
    }

    const override = {
      getPortal: () => this,
      getInstance: () => this.subtree,
      getElement: this.getElement.bind(this)
    };

    this.view = new Proxy(override, {
      get(target, name) {
        if (Reflect.has(target, name)) {
          return target[name];
        }

        return target.getInstance()[name];
      },

      set(target, name, value) {
        target.getInstance()[name] = value;
      },

      has(target, name) {
        return Reflect.has(target.getInstance(), name) || Reflect.has(target, name);
      }
    });
    return this.view;
  }
}, _class.propTypes = {
  type: _propTypes2.default.string,
  className: _propTypes2.default.string,
  appendNode: _propTypes2.default.bool,
  getDOMNode: _propTypes2.default.func
}, _class.defaultProps = {
  type: 'div',
  className: 'react-atom-portal',
  appendNode: false,
  getDOMNode: null
}, _temp);
exports.default = Portal;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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