'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _eventKit = require('event-kit');

var _commands = require('./commands');

var _commands2 = _interopRequireDefault(_commands);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

const ISSUEISH_URL_REGEX = /^(?:https?:\/\/)?github.com\/([^/]+)\/([^/]+)\/(?:issues|pull)\/(\d+)/;

let OpenIssueishDialog = (_class = (_temp = _class2 = class OpenIssueishDialog extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.state = {
      cloneDisabled: false
    };

    this.subs = new _eventKit.CompositeDisposable();
  }

  componentDidMount() {
    if (this.issueishUrlElement) {
      setTimeout(() => this.issueishUrlElement.focus());
    }
  }

  render() {
    return this.renderDialog();
  }

  renderDialog() {
    return _react2.default.createElement(
      'div',
      { className: 'github-Dialog github-OpenIssueish modal' },
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: '.github-OpenIssueish' },
        _react2.default.createElement(_commands.Command, { command: 'core:cancel', callback: this.cancel }),
        _react2.default.createElement(_commands.Command, { command: 'core:confirm', callback: this.accept })
      ),
      _react2.default.createElement(
        'main',
        { className: 'github-DialogInputs' },
        _react2.default.createElement(
          'label',
          { className: 'github-DialogLabel github-IssueishUrl' },
          'Issue or pull request URL:',
          _react2.default.createElement('atom-text-editor', { mini: true, ref: this.editorRefs('issueishUrl'), tabIndex: '1' })
        ),
        this.state.error && _react2.default.createElement(
          'span',
          { className: 'error' },
          this.state.error
        )
      ),
      _react2.default.createElement(
        'div',
        { className: 'github-DialogButtons' },
        _react2.default.createElement(
          'button',
          { className: 'btn github-CancelButton', onClick: this.cancel, tabIndex: '3' },
          'Cancel'
        ),
        _react2.default.createElement(
          'button',
          {
            className: 'btn btn-primary icon icon-git-pull-request',
            onClick: this.accept,
            disabled: this.getIssueishUrl().length === 0,
            tabIndex: '2' },
          'Open Issue or Pull Request'
        )
      )
    );
  }

  accept() {
    if (this.getIssueishUrl().length === 0) {
      return;
    }

    const parsed = this.parseUrl();
    if (!parsed) {
      this.setState({
        error: 'That is not a valid issue or pull request URL.'
      });
      return;
    }
    const repoOwner = parsed.repoOwner,
          repoName = parsed.repoName,
          issueishNumber = parsed.issueishNumber;


    this.props.didAccept({ repoOwner, repoName, issueishNumber });
  }

  cancel() {
    this.props.didCancel();
  }

  editorRefs(baseName) {
    const elementName = `${baseName}Element`;
    const modelName = `${baseName}Editor`;
    const subName = `${baseName}Subs`;
    const changeMethodName = `didChange${baseName[0].toUpperCase()}${baseName.substring(1)}`;

    return element => {
      if (!element) {
        return;
      }

      this[elementName] = element;
      const editor = element.getModel();
      if (this[modelName] !== editor) {
        this[modelName] = editor;

        if (this[subName]) {
          this[subName].dispose();
          this.subs.remove(this[subName]);
        }

        this[subName] = editor.onDidChange(this[changeMethodName]);
        this.subs.add(this[subName]);
      }
    };
  }

  didChangeIssueishUrl() {
    this.setState({ error: null });
  }

  parseUrl() {
    const url = this.getIssueishUrl();
    const matches = url.match(ISSUEISH_URL_REGEX);
    if (!matches) {
      return false;
    }

    var _matches = _slicedToArray(matches, 4);

    const _full = _matches[0],
          repoOwner = _matches[1],
          repoName = _matches[2],
          issueishNumber = _matches[3]; // eslint-disable-line no-unused-vars

    return { repoOwner, repoName, issueishNumber };
  }

  getIssueishUrl() {
    return this.issueishUrlEditor ? this.issueishUrlEditor.getText() : '';
  }
}, _class2.propTypes = {
  commandRegistry: _propTypes2.default.object.isRequired,
  didAccept: _propTypes2.default.func,
  didCancel: _propTypes2.default.func
}, _class2.defaultProps = {
  didAccept: () => {},
  didCancel: () => {}
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'accept', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'accept'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'cancel', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'cancel'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'editorRefs', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'editorRefs'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'didChangeIssueishUrl', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'didChangeIssueishUrl'), _class.prototype)), _class);
exports.default = OpenIssueishDialog;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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