'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _desc, _value, _class;

var _coreDecorators = require('core-decorators');

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

const COPY = {};

let ListSelection = (_class = class ListSelection {
  constructor() {
    let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    if (options._copy !== COPY) {
      this.options = {
        isItemSelectable: options.isItemSelectable || (item => true)
      };
      this.setItems(options.items || []);
    } else {
      this.options = {
        isItemSelectable: options.isItemSelectable
      };
      this.items = options.items;
      this.selections = options.selections;
    }
  }

  copy() {
    // Deep-copy selections because it will be modified.
    // (That's temporary, until ListSelection is changed to be immutable, too.)
    return new ListSelection({
      _copy: COPY,
      isItemSelectable: this.options.isItemSelectable,
      items: this.items,
      selections: this.selections.map((_ref) => {
        let head = _ref.head,
            tail = _ref.tail,
            negate = _ref.negate;
        return { head, tail, negate };
      })
    });
  }

  isItemSelectable(item) {
    return this.options.isItemSelectable(item);
  }

  setItems(items) {
    let newSelectionIndex;
    if (this.selections && this.selections.length > 0) {
      var _selections = _slicedToArray(this.selections, 1),
          _selections$ = _selections[0];

      const head = _selections$.head,
            tail = _selections$.tail;

      newSelectionIndex = Math.min(head, tail, items.length - 1);
    } else {
      newSelectionIndex = 0;
    }

    this.items = items;
    if (items.length > 0) {
      this.selections = [{ head: newSelectionIndex, tail: newSelectionIndex }];
    } else {
      this.selections = [];
    }
  }

  getItems() {
    return this.items;
  }

  getLastItem() {
    return this.items[this.items.length - 1];
  }

  selectFirstItem(preserveTail) {
    for (let i = 0; i < this.items.length; i++) {
      const item = this.items[i];
      if (this.isItemSelectable(item)) {
        this.selectItem(item, preserveTail);
        break;
      }
    }
  }

  selectLastItem(preserveTail) {
    for (let i = this.items.length - 1; i > 0; i--) {
      const item = this.items[i];
      if (this.isItemSelectable(item)) {
        this.selectItem(item, preserveTail);
        break;
      }
    }
  }

  selectAllItems() {
    this.selectFirstItem();
    this.selectLastItem(true);
  }

  selectNextItem(preserveTail) {
    if (this.selections.length === 0) {
      this.selectFirstItem();
      return;
    }

    let itemIndex = this.selections[0].head;
    let nextItemIndex = itemIndex;
    while (itemIndex < this.items.length - 1) {
      itemIndex++;
      if (this.isItemSelectable(this.items[itemIndex])) {
        nextItemIndex = itemIndex;
        break;
      }
    }

    this.selectItem(this.items[nextItemIndex], preserveTail);
  }

  selectPreviousItem(preserveTail) {
    if (this.selections.length === 0) {
      this.selectLastItem();
      return;
    }

    let itemIndex = this.selections[0].head;
    let previousItemIndex = itemIndex;

    while (itemIndex > 0) {
      itemIndex--;
      if (this.isItemSelectable(this.items[itemIndex])) {
        previousItemIndex = itemIndex;
        break;
      }
    }

    this.selectItem(this.items[previousItemIndex], preserveTail);
  }

  selectItem(item, preserveTail, addOrSubtract) {
    if (addOrSubtract && preserveTail) {
      throw new Error('addOrSubtract and preserveTail cannot both be true at the same time');
    }

    const itemIndex = this.items.indexOf(item);
    if (preserveTail && this.selections[0]) {
      this.selections[0].head = itemIndex;
    } else {
      const selection = { head: itemIndex, tail: itemIndex };
      if (addOrSubtract) {
        if (this.getSelectedItems().has(item)) {
          selection.negate = true;
        }
        this.selections.unshift(selection);
      } else {
        this.selections = [selection];
      }
    }
  }

  addOrSubtractSelection(item) {
    this.selectItem(item, false, true);
  }

  coalesce() {
    if (this.selections.length === 0) {
      return;
    }

    const mostRecent = this.selections[0];
    let mostRecentStart = Math.min(mostRecent.head, mostRecent.tail);
    let mostRecentEnd = Math.max(mostRecent.head, mostRecent.tail);
    while (mostRecentStart > 0 && !this.isItemSelectable(this.items[mostRecentStart - 1])) {
      mostRecentStart--;
    }
    while (mostRecentEnd < this.items.length - 1 && !this.isItemSelectable(this.items[mostRecentEnd + 1])) {
      mostRecentEnd++;
    }

    for (let i = 1; i < this.selections.length;) {
      const current = this.selections[i];
      const currentStart = Math.min(current.head, current.tail);
      const currentEnd = Math.max(current.head, current.tail);
      if (mostRecentStart <= currentEnd + 1 && currentStart - 1 <= mostRecentEnd) {
        if (mostRecent.negate) {
          const truncatedSelections = [];
          if (current.head > current.tail) {
            if (currentEnd > mostRecentEnd) {
              // suffix
              truncatedSelections.push({ tail: mostRecentEnd + 1, head: currentEnd });
            }
            if (currentStart < mostRecentStart) {
              // prefix
              truncatedSelections.push({ tail: currentStart, head: mostRecentStart - 1 });
            }
          } else {
            if (currentStart < mostRecentStart) {
              // prefix
              truncatedSelections.push({ head: currentStart, tail: mostRecentStart - 1 });
            }
            if (currentEnd > mostRecentEnd) {
              // suffix
              truncatedSelections.push({ head: mostRecentEnd + 1, tail: currentEnd });
            }
          }
          this.selections.splice(i, 1, ...truncatedSelections);
          i += truncatedSelections.length;
        } else {
          mostRecentStart = Math.min(mostRecentStart, currentStart);
          mostRecentEnd = Math.max(mostRecentEnd, currentEnd);
          if (mostRecent.head >= mostRecent.tail) {
            mostRecent.head = mostRecentEnd;
            mostRecent.tail = mostRecentStart;
          } else {
            mostRecent.head = mostRecentStart;
            mostRecent.tail = mostRecentEnd;
          }
          this.selections.splice(i, 1);
        }
      } else {
        i++;
      }
    }

    if (mostRecent.negate) {
      this.selections.shift();
    }
  }

  getSelectedItems() {
    const selectedItems = new Set();
    for (const _ref2 of this.selections.slice().reverse()) {
      const head = _ref2.head,
            tail = _ref2.tail,
            negate = _ref2.negate;

      const start = Math.min(head, tail);
      const end = Math.max(head, tail);
      for (let i = start; i <= end; i++) {
        const item = this.items[i];
        if (this.isItemSelectable(item)) {
          if (negate) {
            selectedItems.delete(item);
          } else {
            selectedItems.add(item);
          }
        }
      }
    }
    return selectedItems;
  }

  getHeadItem() {
    return this.selections.length > 0 ? this.items[this.selections[0].head] : null;
  }

  getMostRecentSelectionStartIndex() {
    const selection = this.selections[0];
    return Math.min(selection.head, selection.tail);
  }

  getTailIndex() {
    return this.selections[0] ? this.selections[0].tail : null;
  }
}, (_applyDecoratedDescriptor(_class.prototype, 'isItemSelectable', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'isItemSelectable'), _class.prototype)), _class);
exports.default = ListSelection;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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