'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _eventKit = require('event-kit');

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _coreDecorators = require('core-decorators');

var _hunkView = require('./hunk-view');

var _hunkView2 = _interopRequireDefault(_hunkView);

var _simpleTooltip = require('./simple-tooltip');

var _simpleTooltip2 = _interopRequireDefault(_simpleTooltip);

var _commands = require('./commands');

var _commands2 = _interopRequireDefault(_commands);

var _filePatchSelection = require('./file-patch-selection');

var _filePatchSelection2 = _interopRequireDefault(_filePatchSelection);

var _switchboard = require('../switchboard');

var _switchboard2 = _interopRequireDefault(_switchboard);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let FilePatchView = (_class = (_temp = _class2 = class FilePatchView extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.mouseSelectionInProgress = false;
    this.disposables = new _eventKit.CompositeDisposable();

    this.state = {
      selection: new _filePatchSelection2.default(this.props.hunks)
    };
  }

  componentDidMount() {
    window.addEventListener('mouseup', this.mouseup);
    this.disposables.add(new _eventKit.Disposable(() => window.removeEventListener('mouseup', this.mouseup)));
  }

  componentWillReceiveProps(nextProps) {
    const hunksChanged = this.props.hunks.length !== nextProps.hunks.length || this.props.hunks.some((hunk, index) => hunk !== nextProps.hunks[index]);

    if (hunksChanged) {
      this.setState(prevState => {
        return {
          selection: prevState.selection.updateHunks(nextProps.hunks)
        };
      }, () => {
        nextProps.switchboard.didChangePatch();
      });
    }
  }

  render() {
    const selectedHunks = this.state.selection.getSelectedHunks();
    const selectedLines = this.state.selection.getSelectedLines();
    const headHunk = this.state.selection.getHeadHunk();
    const headLine = this.state.selection.getHeadLine();
    const hunkSelectionMode = this.state.selection.getMode() === 'hunk';

    const unstaged = this.props.stagingStatus === 'unstaged';
    const stageButtonLabelPrefix = unstaged ? 'Stage' : 'Unstage';

    return _react2.default.createElement(
      'div',
      {
        className: (0, _classnames2.default)('github-FilePatchView', { 'is-staged': !unstaged, 'is-unstaged': unstaged }),
        tabIndex: '-1',
        onMouseUp: this.mouseup,
        ref: e => {
          this.element = e;
        } },
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: '.github-FilePatchView' },
        _react2.default.createElement(_commands.Command, { command: 'github:toggle-patch-selection-mode', callback: this.togglePatchSelectionMode }),
        _react2.default.createElement(_commands.Command, { command: 'core:confirm', callback: this.didConfirm }),
        _react2.default.createElement(_commands.Command, { command: 'core:move-up', callback: this.selectPrevious }),
        _react2.default.createElement(_commands.Command, { command: 'core:move-down', callback: this.selectNext }),
        _react2.default.createElement(_commands.Command, { command: 'core:move-right', callback: this.didMoveRight }),
        _react2.default.createElement(_commands.Command, { command: 'core:move-to-top', callback: this.selectFirst }),
        _react2.default.createElement(_commands.Command, { command: 'core:move-to-bottom', callback: this.selectLast }),
        _react2.default.createElement(_commands.Command, { command: 'core:select-up', callback: this.selectToPrevious }),
        _react2.default.createElement(_commands.Command, { command: 'core:select-down', callback: this.selectToNext }),
        _react2.default.createElement(_commands.Command, { command: 'core:select-to-top', callback: this.selectToFirst }),
        _react2.default.createElement(_commands.Command, { command: 'core:select-to-bottom', callback: this.selectToLast }),
        _react2.default.createElement(_commands.Command, { command: 'core:select-all', callback: this.selectAll }),
        _react2.default.createElement(_commands.Command, { command: 'github:select-next-hunk', callback: this.selectNextHunk }),
        _react2.default.createElement(_commands.Command, { command: 'github:select-previous-hunk', callback: this.selectPreviousHunk }),
        _react2.default.createElement(_commands.Command, { command: 'github:open-file', callback: this.openFile }),
        _react2.default.createElement(_commands.Command, {
          command: 'github:view-corresponding-diff',
          callback: () => this.props.isPartiallyStaged && this.props.didDiveIntoCorrespondingFilePatch()
        }),
        _react2.default.createElement(_commands.Command, { command: 'github:discard-selected-lines', callback: this.discardSelection }),
        _react2.default.createElement(_commands.Command, {
          command: 'core:undo',
          callback: () => this.props.hasUndoHistory && this.props.undoLastDiscard()
        })
      ),
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: 'atom-workspace' },
        _react2.default.createElement(_commands.Command, {
          command: 'github:undo-last-discard-in-diff-view',
          callback: () => this.props.hasUndoHistory && this.props.undoLastDiscard()
        })
      ),
      _react2.default.createElement(
        'header',
        { className: 'github-FilePatchView-header' },
        _react2.default.createElement(
          'span',
          { className: 'github-FilePatchView-title' },
          unstaged ? 'Unstaged Changes for ' : 'Staged Changes for ',
          this.props.filePath
        ),
        this.renderButtonGroup()
      ),
      _react2.default.createElement(
        'main',
        { className: 'github-FilePatchView-container' },
        this.props.hunks.map(hunk => {
          const isSelected = selectedHunks.has(hunk);
          let stageButtonSuffix = hunkSelectionMode || !isSelected ? ' Hunk' : ' Selection';
          if (selectedHunks.size > 1 && selectedHunks.has(hunk)) {
            stageButtonSuffix += 's';
          }
          const stageButtonLabel = stageButtonLabelPrefix + stageButtonSuffix;
          const discardButtonLabel = 'Discard' + stageButtonSuffix;

          return _react2.default.createElement(_hunkView2.default, {
            key: hunk.getHeader(),
            tooltips: this.props.tooltips,
            hunk: hunk,
            isSelected: selectedHunks.has(hunk),
            hunkSelectionMode: hunkSelectionMode,
            unstaged: unstaged,
            stageButtonLabel: stageButtonLabel,
            discardButtonLabel: discardButtonLabel,
            selectedLines: selectedLines,
            headLine: headLine,
            headHunk: headHunk,
            mousedownOnHeader: e => this.mousedownOnHeader(e, hunk),
            mousedownOnLine: this.mousedownOnLine,
            mousemoveOnLine: this.mousemoveOnLine,
            contextMenuOnItem: this.contextMenuOnItem,
            didClickStageButton: () => this.didClickStageButtonForHunk(hunk),
            didClickDiscardButton: () => this.didClickDiscardButtonForHunk(hunk)
          });
        })
      )
    );
  }

  renderButtonGroup() {
    const unstaged = this.props.stagingStatus === 'unstaged';

    return _react2.default.createElement(
      'span',
      { className: 'btn-group' },
      this.props.hasUndoHistory && unstaged ? _react2.default.createElement(
        'button',
        {
          className: 'btn icon icon-history',
          onClick: this.props.undoLastDiscard },
        'Undo Discard'
      ) : null,
      this.props.isPartiallyStaged ? _react2.default.createElement(
        _simpleTooltip2.default,
        {
          tooltips: this.props.tooltips,
          title: `View ${unstaged ? 'staged' : 'unstaged'} changes` },
        _react2.default.createElement('button', {
          className: (0, _classnames2.default)('btn', 'icon', { 'icon-tasklist': unstaged, 'icon-list-unordered': !unstaged }),
          onClick: this.props.didDiveIntoCorrespondingFilePatch
        })
      ) : null,
      _react2.default.createElement(
        _simpleTooltip2.default,
        {
          tooltips: this.props.tooltips,
          title: 'Open File' },
        _react2.default.createElement('button', {
          className: 'btn icon icon-code',
          onClick: this.openFile
        })
      ),
      _react2.default.createElement(
        'button',
        {
          className: (0, _classnames2.default)('btn', 'icon', { 'icon-move-down': unstaged, 'icon-move-up': !unstaged }),
          onClick: this.stageOrUnstageAll },
        unstaged ? 'Stage File' : 'Unstage File'
      )
    );
  }

  componentWillUnmount() {
    this.disposables.dispose();
  }

  contextMenuOnItem(event, hunk, line) {
    const resend = () => {
      const newEvent = new MouseEvent(event.type, event);
      setImmediate(() => event.target.parentNode.dispatchEvent(newEvent));
    };

    const mode = this.state.selection.getMode();
    if (mode === 'hunk' && !this.state.selection.getSelectedHunks().has(hunk)) {
      event.stopPropagation();

      this.setState(prevState => {
        return { selection: prevState.selection.selectHunk(hunk, event.shiftKey) };
      }, resend);
    } else if (mode === 'line' && !this.state.selection.getSelectedLines().has(line)) {
      event.stopPropagation();

      this.setState(prevState => {
        return { selection: prevState.selection.selectLine(line, event.shiftKey) };
      }, resend);
    }
  }

  mousedownOnHeader(event, hunk) {
    if (event.button !== 0) {
      return;
    }
    const windows = process.platform === 'win32';
    if (event.ctrlKey && !windows) {
      return;
    } // simply open context menu

    this.mouseSelectionInProgress = true;
    event.persist && event.persist();

    this.setState(prevState => {
      let selection = prevState.selection;
      if (event.metaKey || event.ctrlKey && windows) {
        if (selection.getMode() === 'hunk') {
          selection = selection.addOrSubtractHunkSelection(hunk);
        } else {
          // TODO: optimize
          selection = hunk.getLines().reduce((current, line) => current.addOrSubtractLineSelection(line).coalesce(), selection);
        }
      } else if (event.shiftKey) {
        if (selection.getMode() === 'hunk') {
          selection = selection.selectHunk(hunk, true);
        } else {
          const hunkLines = hunk.getLines();
          const tailIndex = selection.getLineSelectionTailIndex();
          const selectedHunkAfterTail = tailIndex < hunkLines[0].diffLineNumber;
          if (selectedHunkAfterTail) {
            selection = selection.selectLine(hunkLines[hunkLines.length - 1], true);
          } else {
            selection = selection.selectLine(hunkLines[0], true);
          }
        }
      } else {
        selection = selection.selectHunk(hunk, false);
      }

      return { selection };
    });
  }

  mousedownOnLine(event, hunk, line) {
    if (event.button !== 0) {
      return;
    }
    const windows = process.platform === 'win32';
    if (event.ctrlKey && !windows) {
      return;
    } // simply open context menu

    this.mouseSelectionInProgress = true;
    event.persist && event.persist();

    this.setState(prevState => {
      let selection = prevState.selection;

      if (event.metaKey || event.ctrlKey && windows) {
        if (selection.getMode() === 'hunk') {
          selection = selection.addOrSubtractHunkSelection(hunk);
        } else {
          selection = selection.addOrSubtractLineSelection(line);
        }
      } else if (event.shiftKey) {
        if (selection.getMode() === 'hunk') {
          selection = selection.selectHunk(hunk, true);
        } else {
          selection = selection.selectLine(line, true);
        }
      } else if (event.detail === 1) {
        selection = selection.selectLine(line, false);
      } else if (event.detail === 2) {
        selection = selection.selectHunk(hunk, false);
      }

      return { selection };
    });
  }

  mousemoveOnLine(event, hunk, line) {
    if (!this.mouseSelectionInProgress) {
      return;
    }

    this.setState(prevState => {
      let selection = null;
      if (prevState.selection.getMode() === 'hunk') {
        selection = prevState.selection.selectHunk(hunk, true);
      } else {
        selection = prevState.selection.selectLine(line, true);
      }
      return { selection };
    });
  }

  mouseup() {
    this.mouseSelectionInProgress = false;
    this.setState(prevState => {
      return { selection: prevState.selection.coalesce() };
    });
  }

  togglePatchSelectionMode() {
    this.setState(prevState => ({ selection: prevState.selection.toggleMode() }));
  }

  getPatchSelectionMode() {
    return this.state.selection.getMode();
  }

  getSelectedHunks() {
    return this.state.selection.getSelectedHunks();
  }

  getSelectedLines() {
    return this.state.selection.getSelectedLines();
  }

  selectNext() {
    this.setState(prevState => ({ selection: prevState.selection.selectNext() }));
  }

  selectNextHunk() {
    this.setState(prevState => ({ selection: prevState.selection.jumpToNextHunk() }));
  }

  selectToNext() {
    this.setState(prevState => {
      return { selection: prevState.selection.selectNext(true).coalesce() };
    });
  }

  selectPrevious() {
    this.setState(prevState => ({ selection: prevState.selection.selectPrevious() }));
  }

  selectPreviousHunk() {
    this.setState(prevState => ({ selection: prevState.selection.jumpToPreviousHunk() }));
  }

  selectToPrevious() {
    this.setState(prevState => {
      return { selection: prevState.selection.selectPrevious(true).coalesce() };
    });
  }

  selectFirst() {
    this.setState(prevState => ({ selection: prevState.selection.selectFirst() }));
  }

  selectToFirst() {
    this.setState(prevState => ({ selection: prevState.selection.selectFirst(true) }));
  }

  selectLast() {
    this.setState(prevState => ({ selection: prevState.selection.selectLast() }));
  }

  selectToLast() {
    this.setState(prevState => ({ selection: prevState.selection.selectLast(true) }));
  }

  selectAll() {
    return new Promise(resolve => {
      this.setState(prevState => ({ selection: prevState.selection.selectAll() }), resolve);
    });
  }

  getNextHunkUpdatePromise() {
    return this.state.selection.getNextUpdatePromise();
  }

  didClickStageButtonForHunk(hunk) {
    if (this.state.selection.getSelectedHunks().has(hunk)) {
      this.props.attemptLineStageOperation(this.state.selection.getSelectedLines());
    } else {
      this.setState(prevState => ({ selection: prevState.selection.selectHunk(hunk) }), () => {
        this.props.attemptHunkStageOperation(hunk);
      });
    }
  }

  didClickDiscardButtonForHunk(hunk) {
    if (this.state.selection.getSelectedHunks().has(hunk)) {
      this.discardSelection();
    } else {
      this.setState(prevState => ({ selection: prevState.selection.selectHunk(hunk) }), () => {
        this.discardSelection();
      });
    }
  }

  didConfirm() {
    return this.didClickStageButtonForHunk([...this.state.selection.getSelectedHunks()][0]);
  }

  didMoveRight() {
    if (this.props.didSurfaceFile) {
      this.props.didSurfaceFile();
    }
  }

  focus() {
    this.element.focus();
  }

  openFile() {
    let lineNumber = 0;
    const firstSelectedLine = Array.from(this.state.selection.getSelectedLines())[0];
    if (firstSelectedLine && firstSelectedLine.newLineNumber > -1) {
      lineNumber = firstSelectedLine.newLineNumber;
    } else {
      const firstSelectedHunk = Array.from(this.state.selection.getSelectedHunks())[0];
      lineNumber = firstSelectedHunk ? firstSelectedHunk.getNewStartRow() : 0;
    }
    return this.props.openCurrentFile({ lineNumber });
  }

  stageOrUnstageAll() {
    var _this = this;

    return _asyncToGenerator(function* () {
      yield _this.selectAll();
      _this.didConfirm();
    })();
  }

  discardSelection() {
    const selectedLines = this.state.selection.getSelectedLines();
    return selectedLines.size ? this.props.discardLines(selectedLines) : null;
  }

  goToDiffLine(lineNumber) {
    this.setState(prevState => ({ selection: prevState.selection.goToDiffLine(lineNumber) }));
  }
}, _class2.propTypes = {
  commandRegistry: _propTypes2.default.object.isRequired,
  tooltips: _propTypes2.default.object.isRequired,
  filePath: _propTypes2.default.string.isRequired,
  hunks: _propTypes2.default.arrayOf(_propTypes2.default.object).isRequired,
  stagingStatus: _propTypes2.default.oneOf(['unstaged', 'staged']).isRequired,
  isPartiallyStaged: _propTypes2.default.bool.isRequired,
  hasUndoHistory: _propTypes2.default.bool.isRequired,
  attemptLineStageOperation: _propTypes2.default.func.isRequired,
  attemptHunkStageOperation: _propTypes2.default.func.isRequired,
  discardLines: _propTypes2.default.func.isRequired,
  undoLastDiscard: _propTypes2.default.func.isRequired,
  openCurrentFile: _propTypes2.default.func.isRequired,
  didSurfaceFile: _propTypes2.default.func.isRequired,
  didDiveIntoCorrespondingFilePatch: _propTypes2.default.func.isRequired,
  switchboard: _propTypes2.default.instanceOf(_switchboard2.default)
}, _class2.defaultProps = {
  switchboard: new _switchboard2.default()
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'renderButtonGroup', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'renderButtonGroup'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'contextMenuOnItem', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'contextMenuOnItem'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'mousedownOnLine', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'mousedownOnLine'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'mousemoveOnLine', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'mousemoveOnLine'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'mouseup', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'mouseup'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'togglePatchSelectionMode', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'togglePatchSelectionMode'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'selectNext', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'selectNext'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'selectNextHunk', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'selectNextHunk'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'selectToNext', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'selectToNext'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'selectPrevious', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'selectPrevious'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'selectPreviousHunk', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'selectPreviousHunk'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'selectToPrevious', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'selectToPrevious'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'selectFirst', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'selectFirst'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'selectToFirst', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'selectToFirst'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'selectLast', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'selectLast'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'selectToLast', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'selectToLast'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'selectAll', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'selectAll'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'didConfirm', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'didConfirm'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'didMoveRight', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'didMoveRight'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'openFile', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'openFile'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'stageOrUnstageAll', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'stageOrUnstageAll'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'discardSelection', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'discardSelection'), _class.prototype)), _class);
exports.default = FilePatchView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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