'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _commands = require('./commands');

var _commands2 = _interopRequireDefault(_commands);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let CredentialDialog = (_class = (_temp = _class2 = class CredentialDialog extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.state = {
      username: '',
      password: ''
    };
  }

  componentDidMount() {
    setTimeout(this.focusFirstInput);
  }

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'github-Dialog github-Credentials modal native-key-bindings' },
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: '.github-Credentials' },
        _react2.default.createElement(_commands.Command, { command: 'core:cancel', callback: this.cancel }),
        _react2.default.createElement(_commands.Command, { command: 'core:confirm', callback: this.confirm })
      ),
      _react2.default.createElement(
        'header',
        { className: 'github-DialogPrompt' },
        this.props.prompt
      ),
      _react2.default.createElement(
        'main',
        { className: 'github-DialogInputs' },
        this.props.includeUsername ? _react2.default.createElement(
          'label',
          { className: 'github-DialogLabel' },
          'Username:',
          _react2.default.createElement('input', {
            type: 'text',
            ref: e => this.usernameInput = e,
            className: 'input-text github-CredentialDialog-Username',
            value: this.state.username,
            onChange: this.onUsernameChange,
            tabIndex: '1'
          })
        ) : null,
        _react2.default.createElement(
          'label',
          { className: 'github-DialogLabel' },
          'Password:',
          _react2.default.createElement('input', {
            type: 'password',
            ref: e => this.passwordInput = e,
            className: 'input-text github-CredentialDialog-Password',
            value: this.state.password,
            onChange: this.onPasswordChange,
            tabIndex: '2'
          })
        )
      ),
      _react2.default.createElement(
        'footer',
        { className: 'github-DialogButtons' },
        _react2.default.createElement(
          'button',
          { className: 'btn github-CancelButton', tabIndex: '3', onClick: this.cancel },
          'Cancel'
        ),
        _react2.default.createElement(
          'button',
          { className: 'btn btn-primary', tabIndex: '4', onClick: this.confirm },
          'Sign in'
        )
      )
    );
  }

  confirm() {
    const payload = { password: this.state.password };

    if (this.props.includeUsername) {
      payload.username = this.state.username;
    }

    this.props.onSubmit(payload);
  }

  cancel() {
    this.props.onCancel();
  }

  onUsernameChange(e) {
    this.setState({ username: e.target.value });
  }

  onPasswordChange(e) {
    this.setState({ password: e.target.value });
  }

  focusFirstInput() {
    (this.usernameInput || this.passwordInput).focus();
  }
}, _class2.propTypes = {
  commandRegistry: _propTypes2.default.object.isRequired,
  prompt: _propTypes2.default.string.isRequired,
  includeUsername: _propTypes2.default.bool,
  onSubmit: _propTypes2.default.func,
  onCancel: _propTypes2.default.func
}, _class2.defaultProps = {
  includeUsername: false,
  onSubmit: () => {},
  onCancel: () => {}
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'confirm', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'confirm'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'cancel', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'cancel'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'onUsernameChange', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'onUsernameChange'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'onPasswordChange', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'onPasswordChange'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'focusFirstInput', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'focusFirstInput'), _class.prototype)), _class);
exports.default = CredentialDialog;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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