'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('./octicon');

var _octicon2 = _interopRequireDefault(_octicon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let ChangedFilesCountView = (_temp = _class = class ChangedFilesCountView extends _react2.default.Component {

  render() {
    const label = this.props.changedFilesCount === 1 ? '1 file' : `${this.props.changedFilesCount} files`;
    return _react2.default.createElement(
      'a',
      {
        ref: 'changedFiles',
        className: 'github-ChangedFilesCount inline-block icon icon-diff',
        onClick: this.props.didClick },
      label,
      this.props.mergeConflictsPresent && _react2.default.createElement(_octicon2.default, { icon: 'alert' })
    );
  }
}, _class.propTypes = {
  changedFilesCount: _propTypes2.default.number.isRequired,
  didClick: _propTypes2.default.func.isRequired,
  mergeConflictsPresent: _propTypes2.default.bool
}, _class.defaultProps = {
  changedFilesCount: 0,
  mergeConflictsPresent: false,
  didClick: () => {}
}, _temp);
exports.default = ChangedFilesCountView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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