'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _compareSets2 = require('compare-sets');

var _compareSets3 = _interopRequireDefault(_compareSets2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let MultiList = class MultiList {
  constructor(lists, didChangeActiveItem) {
    this.listInfoByKey = new Map();
    this.listOrderByKey = lists.map(list => {
      this.listInfoByKey.set(list.key, {
        items: list.items,
        activeItem: list.items[0],
        activeIndex: 0
      });
      return list.key;
    });
    this.didChangeActiveItem = didChangeActiveItem;
    this.activateListForKey(lists[0].key, { suppressCallback: true });
  }

  getListKeys() {
    return this.listOrderByKey;
  }

  getActiveListKey() {
    return this.activeListKey;
  }

  getItemsForKey(key) {
    return this.listInfoByKey.get(key).items;
  }

  getItemsInActiveList() {
    return this.getItemsForKey(this.getActiveListKey());
  }

  getItemIndexForKey(key, item) {
    const items = this.getItemsForKey(key);
    return items.indexOf(item);
  }

  getActiveItemForKey(key) {
    if (key === undefined) {
      throw new RangeError();
    }
    return this.listInfoByKey.get(key).activeItem;
  }

  getActiveItem() {
    return this.listInfoByKey.get(this.getActiveListKey()).activeItem;
  }

  activateListForKey(key) {
    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    let suppressCallback = _ref.suppressCallback;

    this.activeListKey = key;

    if (this.didChangeActiveItem && !suppressCallback) {
      this.didChangeActiveItem(this.getActiveItem(), this.getActiveListKey());
    }
  }

  activateItemAtIndexForKey(key, index) {
    var _ref2 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    let suppressCallback = _ref2.suppressCallback;

    this.activateListForKey(key, { suppressCallback: true });
    const listInfo = this.listInfoByKey.get(key);
    listInfo.activeIndex = index;
    listInfo.activeItem = listInfo.items[index];

    if (this.didChangeActiveItem && !suppressCallback) {
      this.didChangeActiveItem(this.getActiveItem(), this.getActiveListKey());
    }
  }

  activateItem(activeItem) {
    var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    let suppressCallback = _ref3.suppressCallback;

    for (const _ref4 of this.listInfoByKey) {
      var _ref5 = _slicedToArray(_ref4, 2);

      const key = _ref5[0];
      const listInfo = _ref5[1];

      for (let index = 0; index < listInfo.items.length; index++) {
        const item = listInfo.items[index];
        if (activeItem === item) {
          return this.activateItemAtIndexForKey(key, index, { suppressCallback });
        }
      }
    }
    return null;
  }

  activateNextList() {
    var _ref6 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    let wrap = _ref6.wrap,
        activateFirst = _ref6.activateFirst,
        suppressCallback = _ref6.suppressCallback;

    const listCount = this.listOrderByKey.length;
    let index = this.listOrderByKey.indexOf(this.getActiveListKey()) + 1;
    if (wrap && index >= listCount) {
      index = 0;
    }
    let listsLeft = listCount - 1;
    while (index < listCount && listsLeft && this.getItemsForKey(this.listOrderByKey[index]).length === 0) {
      index++;
      if (wrap && index >= listCount) {
        index = 0;
      }
      listsLeft--;
    }
    if (index < listCount) {
      const key = this.listOrderByKey[index];
      activateFirst ? this.activateItemAtIndexForKey(key, 0, { suppressCallback }) : this.activateListForKey(key, { suppressCallback });
    }
  }

  activatePreviousList() {
    var _ref7 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    let wrap = _ref7.wrap,
        activateLast = _ref7.activateLast,
        suppressCallback = _ref7.suppressCallback;

    const listCount = this.listOrderByKey.length;
    let index = this.listOrderByKey.indexOf(this.getActiveListKey()) - 1;
    if (wrap && index < 0) {
      index = listCount - 1;
    }
    let listsLeft = index;
    while (index >= 0 && listsLeft && this.getItemsForKey(this.listOrderByKey[index]).length === 0) {
      index--;
      if (wrap && index < 0) {
        index = listCount - 1;
      }
      listsLeft--;
    }
    if (index >= 0) {
      const key = this.listOrderByKey[index];
      if (activateLast) {
        const lastItemIndex = this.getItemsForKey(this.listOrderByKey[index]).length - 1;
        this.activateItemAtIndexForKey(key, lastItemIndex, { suppressCallback });
      } else {
        this.activateListForKey(key, { suppressCallback });
      }
    }
  }

  activateNextItem() {
    var _ref8 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    let wrap = _ref8.wrap,
        stopAtBounds = _ref8.stopAtBounds;

    const key = this.getActiveListKey();
    const listInfo = this.listInfoByKey.get(key);
    const newItemIndex = listInfo.activeIndex + 1;
    if (newItemIndex < listInfo.items.length) {
      this.activateItemAtIndexForKey(key, newItemIndex);
    } else {
      if (!stopAtBounds) {
        this.activateNextList({ activateFirst: true, wrap });
      }
    }
  }

  activatePreviousItem() {
    var _ref9 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    let wrap = _ref9.wrap,
        stopAtBounds = _ref9.stopAtBounds;

    const key = this.getActiveListKey();
    const listInfo = this.listInfoByKey.get(key);
    const newItemIndex = listInfo.activeIndex - 1;
    if (newItemIndex >= 0) {
      this.activateItemAtIndexForKey(key, newItemIndex);
    } else {
      if (!stopAtBounds) {
        this.activatePreviousList({ activateLast: true, wrap });
      }
    }
  }

  getItemsAndKeysInRange(endPoint1, endPoint2) {
    // TODO: optimize
    const index1 = this.listOrderByKey.indexOf(endPoint1.key);
    const index2 = this.listOrderByKey.indexOf(endPoint2.key);

    if (index1 < 0) {
      throw new Error(`key "${endPoint1.key}" not found`);
    }
    if (index2 < 0) {
      throw new Error(`key "${endPoint2.key}" not found`);
    }
    let startPoint, endPoint, startKeyIndex, endKeyIndex;
    if (index1 < index2) {
      startPoint = endPoint1;
      endPoint = endPoint2;
      startKeyIndex = index1;
      endKeyIndex = index2;
    } else {
      startPoint = endPoint2;
      endPoint = endPoint1;
      startKeyIndex = index2;
      endKeyIndex = index1;
    }
    const startItemIndex = this.getItemIndexForKey(startPoint.key, startPoint.item);
    const endItemIndex = this.getItemIndexForKey(endPoint.key, endPoint.item);
    if (startItemIndex < 0) {
      throw new Error(`item "${startPoint.item}" not found`);
    }
    if (endItemIndex < 0) {
      throw new Error(`item "${endPoint.item}" not found`);
    }

    if (startKeyIndex === endKeyIndex) {
      const items = this.getItemsForKey(this.listOrderByKey[startKeyIndex]);
      const indexes = [startItemIndex, endItemIndex].sort();
      return {
        items: items.slice(indexes[0], indexes[1] + 1),
        keys: [startPoint.key]
      };
    }

    let itemsInRange;
    for (let i = startKeyIndex; i <= endKeyIndex; i++) {
      const items = this.getItemsForKey(this.listOrderByKey[i]);
      if (i === startKeyIndex) {
        itemsInRange = items.slice(startItemIndex);
      } else if (i === endKeyIndex) {
        itemsInRange = itemsInRange.concat(items.slice(0, endItemIndex + 1));
      } else {
        itemsInRange = itemsInRange.concat(items);
      }
    }
    return {
      items: itemsInRange,
      keys: this.listOrderByKey.slice(startKeyIndex, endKeyIndex + 1)
    };
  }

  updateLists(newLists) {
    var _ref10 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    let suppressCallback = _ref10.suppressCallback,
        oldActiveListIndex = _ref10.oldActiveListIndex,
        oldActiveListItemIndex = _ref10.oldActiveListItemIndex;

    const oldActiveItem = this.getActiveItem();
    const oldActiveListKey = this.getActiveListKey();
    // eslint-disable-next-line no-param-reassign
    oldActiveListIndex = oldActiveListIndex || this.listOrderByKey.indexOf(oldActiveListKey);

    const newListInfo = this.getNewListInfoAndOrder(newLists, { oldActiveListIndex, oldActiveListItemIndex });
    const newListOrderByKey = newListInfo.newListOrderByKey,
          newListInfoByKey = newListInfo.newListInfoByKey,
          selectNext = newListInfo.selectNext;

    this.listInfoByKey = newListInfoByKey;
    this.listOrderByKey = newListOrderByKey;

    if (!newListOrderByKey.includes(oldActiveListKey)) {
      this.activateItemBasedOnIndex(oldActiveListIndex);
    }

    if (this.getItemsInActiveList().length === 0 || selectNext) {
      this.activateNextList({ suppressCallback: true, activateFirst: true });
      if (this.getItemsInActiveList().length === 0) {
        this.activatePreviousList({ suppressCallback: true, activateLast: true });
      }
    }

    if (this.getActiveItem() !== oldActiveItem && this.didChangeActiveItem && !suppressCallback) {
      this.didChangeActiveItem(this.getActiveItem(), this.getActiveListKey());
    }
  }

  getNewListInfoAndOrder(newLists, _ref11) {
    let oldActiveListIndex = _ref11.oldActiveListIndex,
        oldActiveListItemIndex = _ref11.oldActiveListItemIndex;

    var _compareSets = (0, _compareSets3.default)(new Set(this.listOrderByKey), new Set(newLists.map(list => list.key)));

    const retained = _compareSets.retained;

    if (retained.size > 0) {
      return this.getInfoBasedOnOldActiveItem(newLists);
    } else {
      return this.getInfoBasedOnOldActiveIndex(newLists, { oldActiveListIndex, oldActiveListItemIndex });
    }
  }

  getInfoBasedOnOldActiveIndex(newLists, _ref12) {
    let oldActiveListIndex = _ref12.oldActiveListIndex,
        oldActiveListItemIndex = _ref12.oldActiveListItemIndex;

    let selectNext;
    const newListInfoByKey = new Map();
    const newListOrderByKey = newLists.map((list, listIndex) => {
      const newListItems = list.items;
      let newInfo;
      if (oldActiveListItemIndex !== undefined && listIndex === oldActiveListIndex) {
        const items = list.items;
        const item = items[oldActiveListItemIndex];
        if (item !== undefined) {
          newInfo = {
            activeItem: item,
            activeIndex: oldActiveListItemIndex
          };
        } else {
          selectNext = true;
          newInfo = {
            activeItem: items[items.length - 1],
            activeIndex: Math.max(items.length - 1, 0)
          };
        }
      } else {
        newInfo = {
          activeItem: newListItems[0],
          activeIndex: 0
        };
      }
      newInfo.items = newListItems;
      newListInfoByKey.set(list.key, newInfo);
      return list.key;
    });

    return { newListOrderByKey, newListInfoByKey, selectNext };
  }

  getInfoBasedOnOldActiveItem(newLists) {
    const newListInfoByKey = new Map();
    const newListOrderByKey = newLists.map(list => {
      const oldInfo = this.listInfoByKey.get(list.key);
      const key = list.key;
      const newListItems = list.items;
      let newInfo;
      if (oldInfo && newListItems.length > 0) {
        const activeItemIndex = newListItems.indexOf(oldInfo.activeItem);
        if (activeItemIndex > -1) {
          newInfo = {
            activeItem: oldInfo.activeItem,
            activeIndex: activeItemIndex
          };
        } else if (newListItems[oldInfo.activeIndex] !== undefined) {
          newInfo = {
            activeItem: newListItems[oldInfo.activeIndex],
            activeIndex: oldInfo.activeIndex
          };
        } else {
          newInfo = {
            activeItem: newListItems[newListItems.length - 1],
            activeIndex: newListItems.length - 1
          };
        }
      } else {
        newInfo = {
          activeItem: newListItems[0],
          activeIndex: 0
        };
      }
      newInfo.items = newListItems;

      newListInfoByKey.set(key, newInfo);
      return key;
    });

    return { newListOrderByKey, newListInfoByKey };
  }

  activateItemBasedOnIndex(oldActiveListIndex) {
    let newActiveListKey = this.listOrderByKey[oldActiveListIndex];
    if (newActiveListKey) {
      this.activateListForKey(newActiveListKey, { suppressCallback: true });
    } else {
      newActiveListKey = this.listOrderByKey[this.listOrderByKey.length - 1];
      const items = this.getItemsForKey(newActiveListKey);
      this.activateItemAtIndexForKey(newActiveListKey, items.length - 1, { suppressCallback: true });
    }
  }

  toObject() {
    const listOrderByKey = this.listOrderByKey,
          activeListKey = this.activeListKey;

    return { listOrderByKey, activeListKey };
  }
};
exports.default = MultiList;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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