'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _multiList = require('./multi-list');

var _multiList2 = _interopRequireDefault(_multiList);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let MultiListCollection = class MultiListCollection {
  constructor(lists, didChangeSelection) {
    this.list = new _multiList2.default(lists, (item, key) => {
      didChangeSelection && didChangeSelection(item, key);
    });
    const selectedKey = this.list.getActiveListKey();
    const selectedItem = this.list.getActiveItem();
    this.selectedKeys = new Set(selectedKey ? [selectedKey] : []);
    this.selectedItems = new Set(selectedItem ? [selectedItem] : []);
  }

  updateLists(lists) {
    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    let suppressCallback = _ref.suppressCallback;

    const listKeys = this.list.getListKeys();

    let oldActiveListIndex, oldActiveListItemIndex;
    for (let i = 0; i < listKeys.length; i++) {
      const key = listKeys[i];
      if (this.selectedKeys.has(key)) {
        oldActiveListIndex = i;
        const items = this.getItemsForKey(key);
        for (let j = 0; j < items.length; j++) {
          const item = items[j];
          if (this.selectedItems.has(item)) {
            oldActiveListItemIndex = j;
            break;
          }
        }
        break;
      }
    }

    this.list.updateLists(lists, { suppressCallback, oldActiveListIndex, oldActiveListItemIndex });
    this.updateSelections();
  }

  clearSelectedItems() {
    this.selectedItems = new Set();
  }

  clearSelectedKeys() {
    this.selectedKeys = new Set();
  }

  getSelectedItems() {
    return this.selectedItems;
  }

  getSelectedKeys() {
    return this.selectedKeys;
  }

  getItemsForKey(key) {
    return this.list.getItemsForKey(key);
  }

  getActiveListKey() {
    return this.list.getActiveListKey();
  }

  getActiveItem() {
    return this.list.getActiveItem();
  }

  selectNextList() {
    var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    let wrap = _ref2.wrap,
        addToExisting = _ref2.addToExisting;

    this.list.activateNextList({ wrap });
    this.updateSelections({ addToExisting });
  }

  selectPreviousList() {
    var _ref3 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    let wrap = _ref3.wrap,
        addToExisting = _ref3.addToExisting;

    this.list.activatePreviousList({ wrap });
    this.updateSelections({ addToExisting });
  }

  selectNextItem() {
    var _ref4 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    let addToExisting = _ref4.addToExisting,
        stopAtBounds = _ref4.stopAtBounds;

    this.list.activateNextItem({ stopAtBounds });
    this.updateSelections({ addToExisting });
  }

  selectPreviousItem() {
    var _ref5 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    let addToExisting = _ref5.addToExisting,
        stopAtBounds = _ref5.stopAtBounds;

    this.list.activatePreviousItem({ stopAtBounds });
    this.updateSelections({ addToExisting });
  }

  updateSelections() {
    var _ref6 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    let addToExisting = _ref6.addToExisting;

    const selectedKey = this.list.getActiveListKey();
    const selectedItem = this.list.getActiveItem();
    this.selectItems(selectedItem ? [selectedItem] : [], { addToExisting, suppressCallback: true });
    this.selectKeys(selectedKey ? [selectedKey] : [], { addToExisting, suppressCallback: true });
  }

  selectItems(items) {
    var _ref7 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    let addToExisting = _ref7.addToExisting,
        suppressCallback = _ref7.suppressCallback;

    if (!addToExisting) {
      this.clearSelectedItems();
    }
    items.forEach(item => this.selectedItems.add(item));
    this.list.activateItem(items[0], { suppressCallback });
  }

  selectKeys(keys) {
    var _ref8 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    let addToExisting = _ref8.addToExisting,
        suppressCallback = _ref8.suppressCallback;

    if (!addToExisting) {
      this.clearSelectedKeys();
    }
    keys.forEach(key => this.selectedKeys.add(key));
    this.list.activateListForKey(keys[0], { suppressCallback });
  }

  selectAllItemsForKey(key, addToExisting) {
    this.selectKeys([key], { addToExisting });
    this.selectItems(this.list.getItemsForKey(key), { addToExisting });
  }

  selectFirstItemForKey(key) {
    var _ref9 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    let addToExisting = _ref9.addToExisting;

    this.selectKeys([key], { addToExisting });
    this.selectItems([this.list.getItemsForKey(key)[0]], { addToExisting });
  }

  selectItemsAndKeysInRange(endPoint1, endPoint2, addToExisting) {
    if (!addToExisting) {
      this.clearSelectedItems();
      this.clearSelectedKeys();
    }
    // TODO: optimize
    const listKeys = this.list.getListKeys();
    const index1 = listKeys.indexOf(endPoint1.key);
    const index2 = listKeys.indexOf(endPoint2.key);

    if (index1 < 0) {
      throw new Error(`key "${endPoint1.key}" not found`);
    }
    if (index2 < 0) {
      throw new Error(`key "${endPoint2.key}" not found`);
    }
    let startPoint, endPoint, startKeyIndex, endKeyIndex;
    if (index1 < index2) {
      startPoint = endPoint1;
      endPoint = endPoint2;
      startKeyIndex = index1;
      endKeyIndex = index2;
    } else {
      startPoint = endPoint2;
      endPoint = endPoint1;
      startKeyIndex = index2;
      endKeyIndex = index1;
    }
    const startItemIndex = this.list.getItemIndexForKey(startPoint.key, startPoint.item);
    const endItemIndex = this.list.getItemIndexForKey(endPoint.key, endPoint.item);
    if (startItemIndex < 0) {
      throw new Error(`item "${startPoint.item}" not found`);
    }
    if (endItemIndex < 0) {
      throw new Error(`item "${endPoint.item}" not found`);
    }

    if (startKeyIndex === endKeyIndex) {
      const items = this.list.getItemsForKey(listKeys[startKeyIndex]);
      const indexes = [startItemIndex, endItemIndex].sort((a, b) => a - b);
      this.selectKeys([startPoint.key], { addToExisting: true, suppressCallback: true });
      this.selectItems(items.slice(indexes[0], indexes[1] + 1), { addToExisting: true });
      return;
    }

    for (let i = startKeyIndex; i <= endKeyIndex; i++) {
      const key = listKeys[i];
      const items = this.list.getItemsForKey(key);
      if (i === startKeyIndex) {
        this.selectItems(items.slice(startItemIndex), { addToExisting: true });
      } else if (i === endKeyIndex) {
        this.selectItems(items.slice(0, endItemIndex + 1), { addToExisting: true });
      } else {
        this.selectItems(items, { addToExisting: true });
      }
    }
    const keys = listKeys.slice(startKeyIndex, endKeyIndex - startKeyIndex + 1);
    this.selectKeys(keys, { addToExisting: true, suppressCallback: true });
  }
};
exports.default = MultiListCollection;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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