'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _state = require('./state');

var _state2 = _interopRequireDefault(_state);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

/**
 * Initial state to be used when it's uncertain whether or not a git repository is present in a working directory. If
 * it is a git repository, transition to Present, otherwise transition to Empty.
 */
let Loading = class Loading extends _state2.default {
  start() {
    var _this = this;

    return _asyncToGenerator(function* () {
      const dotGitDir = yield _this.resolveDotGitDir();
      if (dotGitDir) {
        _this.repository.setGitDirectoryPath(dotGitDir);
        const history = yield _this.loadHistoryPayload();
        return _this.transitionTo('Present', history);
      } else {
        return _this.transitionTo('Empty');
      }
    })();
  }

  isLoading() {
    return true;
  }

  init() {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      yield _this2.getLoadPromise();
      yield _this2.repository.init();
    })();
  }

  clone(remoteUrl) {
    var _this3 = this;

    return _asyncToGenerator(function* () {
      yield _this3.getLoadPromise();
      yield _this3.repository.clone(remoteUrl);
    })();
  }

  showGitTabLoading() {
    return true;
  }

  directResolveDotGitDir() {
    return this.git().resolveDotGitDir();
  }

  directGetConfig(key, options) {
    return this.git().getConfig(key, options);
  }

  directGetBlobContents(sha) {
    return this.git().getBlobContents(sha);
  }
};
exports.default = Loading;


_state2.default.register(Loading);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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