'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
const UNBORN = {};

let Commit = class Commit {
  static createUnborn() {
    return new Commit('', '', UNBORN);
  }

  constructor(sha, message) {
    let unbornRef = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

    this.sha = sha;
    this.message = message.trim();
    this.unbornRef = unbornRef === UNBORN;
  }

  getSha() {
    return this.sha;
  }

  getMessage() {
    return this.message;
  }

  isUnbornRef() {
    return this.unbornRef;
  }

  isPresent() {
    return true;
  }
};
exports.default = Commit;
const nullCommit = exports.nullCommit = {
  getSha() {
    return '';
  },

  getMessage() {
    return '';
  },

  isUnbornRef() {
    return false;
  },

  isPresent() {
    return false;
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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