'use strict';

var _githubPackage = require('./github-package');

var _githubPackage2 = _interopRequireDefault(_githubPackage);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let pack;
const entry = {
  initialize() {
    pack = new _githubPackage2.default(atom.workspace, atom.project, atom.commands, atom.notifications, atom.tooltips, atom.styles, atom.config, atom.confirm.bind(atom), atom.getConfigDirPath(), atom.getLoadSettings.bind(atom));
  }
};

module.exports = new Proxy(entry, {
  get(target, name) {
    if (pack && Reflect.has(pack, name)) {
      let item = pack[name];
      if (typeof item === 'function') {
        item = item.bind(pack);
      }
      return item;
    } else {
      return target[name];
    }
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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