'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _desc, _value, _class, _class2, _temp, _desc2, _value2, _class3;

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _atom = require('atom');

var _eventKit = require('event-kit');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _etchWrapper = require('../views/etch-wrapper');

var _etchWrapper2 = _interopRequireDefault(_etchWrapper);

var _statusBar = require('../views/status-bar');

var _statusBar2 = _interopRequireDefault(_statusBar);

var _panel = require('../views/panel');

var _panel2 = _interopRequireDefault(_panel);

var _paneItem = require('../views/pane-item');

var _paneItem2 = _interopRequireDefault(_paneItem);

var _dockItem = require('../views/dock-item');

var _dockItem2 = _interopRequireDefault(_dockItem);

var _resizer = require('../views/resizer');

var _resizer2 = _interopRequireDefault(_resizer);

var _tabs = require('../views/tabs');

var _tabs2 = _interopRequireDefault(_tabs);

var _cloneDialog = require('../views/clone-dialog');

var _cloneDialog2 = _interopRequireDefault(_cloneDialog);

var _openIssueishDialog = require('../views/open-issueish-dialog');

var _openIssueishDialog2 = _interopRequireDefault(_openIssueishDialog);

var _initDialog = require('../views/init-dialog');

var _initDialog2 = _interopRequireDefault(_initDialog);

var _credentialDialog = require('../views/credential-dialog');

var _credentialDialog2 = _interopRequireDefault(_credentialDialog);

var _commands = require('../views/commands');

var _commands2 = _interopRequireDefault(_commands);

var _githubTabController = require('./github-tab-controller');

var _githubTabController2 = _interopRequireDefault(_githubTabController);

var _filePatchController = require('./file-patch-controller');

var _filePatchController2 = _interopRequireDefault(_filePatchController);

var _gitTabController = require('./git-tab-controller');

var _gitTabController2 = _interopRequireDefault(_gitTabController);

var _statusBarTileController = require('./status-bar-tile-controller');

var _statusBarTileController2 = _interopRequireDefault(_statusBarTileController);

var _repositoryConflictController = require('./repository-conflict-controller');

var _repositoryConflictController2 = _interopRequireDefault(_repositoryConflictController);

var _modelObserver = require('../models/model-observer');

var _modelObserver2 = _interopRequireDefault(_modelObserver);

var _modelStateRegistry = require('../models/model-state-registry');

var _modelStateRegistry2 = _interopRequireDefault(_modelStateRegistry);

var _conflict = require('../models/conflicts/conflict');

var _conflict2 = _interopRequireDefault(_conflict);

var _switchboard = require('../switchboard');

var _switchboard2 = _interopRequireDefault(_switchboard);

var _helpers = require('../helpers');

var _gitShellOutStrategy = require('../git-shell-out-strategy');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

const nullFilePatchState = {
  filePath: null,
  filePatch: null,
  stagingStatus: 'unstaged',
  partiallyStaged: false
};

let RootController = (_class = (_temp = _class2 = class RootController extends _react2.default.Component {

  serialize() {
    return {
      gitTabActive: this.state.gitTabActive,
      githubTabActive: this.state.githubTabActive,
      panelSize: this.state.panelSize,
      activeTab: this.state.activeTab
    };
  }

  constructor(props, context) {
    var _this;

    _this = super(props, context);

    const renderGitTab = props.startOpen || (props.savedState.gitTabActive === undefined ? !this.props.useLegacyPanels : this.props.savedState.gitTabActive);
    const renderGitHubTab = props.startOpen || (props.savedState.githubTabActive === undefined ? !this.props.useLegacyPanels : this.props.savedState.githubTabActive);

    this.state = _extends({}, nullFilePatchState, {
      amending: false,
      gitTabActive: renderGitTab,
      githubTabActive: renderGitHubTab,
      panelSize: props.savedState.panelSize || 400,
      activeTab: props.savedState.activeTab || 0,
      cloneDialogActive: false,
      cloneDialogInProgress: false,
      initDialogActive: false,
      credentialDialogQuery: null
    });

    this.repositoryStateRegistry = new _modelStateRegistry2.default(RootController, {
      save: () => {
        return { amending: this.state.amending };
      },
      restore: function () {
        let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        _this.setState({ amending: !!state.amending });
      }
    });

    this.subscriptions = new _eventKit.CompositeDisposable();

    this.repositoryObserver = new _modelObserver2.default({
      didUpdate: () => this.onRepoRefresh()
    });
    this.repositoryObserver.setActiveModel(props.repository);
    this.subscriptions.add(new _eventKit.Disposable(() => this.repositoryObserver.destroy()));

    this.gitTabTracker = new TabTracker('git', {
      useLegacyPanels: this.props.useLegacyPanels,
      getState: () => this.state.gitTabActive,
      setState: (value, _ref, callback) => {
        let activateTab = _ref.activateTab;

        const newState = { gitTabActive: value };
        if (activateTab) {
          newState.activeTab = 0;
        }
        this.setState(newState, callback);
      },
      getController: () => this.gitTabController,
      getDockItem: () => this.gitDockItem,
      getWorkspace: () => this.props.workspace
    });

    this.githubTabTracker = new TabTracker('github', {
      useLegacyPanels: this.props.useLegacyPanels,
      getState: () => this.state.githubTabActive,
      setState: (value, _ref2, callback) => {
        let activateTab = _ref2.activateTab;

        const newState = { githubTabActive: value };
        if (activateTab) {
          newState.activeTab = 1;
        }
        this.setState(newState, callback);
      },
      getController: () => this.githubTabController,
      getDockItem: () => this.githubDockItem,
      getWorkspace: () => this.props.workspace
    });
  }

  componentWillMount() {
    this.repositoryStateRegistry.setModel(this.props.repository);
  }

  componentWillReceiveProps(newProps) {
    this.repositoryObserver.setActiveModel(newProps.repository);
    this.repositoryStateRegistry.setModel(newProps.repository);

    this.gitTabTracker.useLegacyPanels = newProps.useLegacyPanels;
    this.githubTabTracker.useLegacyPanels = newProps.useLegacyPanels;
  }

  render() {
    return _react2.default.createElement(
      'div',
      null,
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: 'atom-workspace' },
        _react2.default.createElement(_commands.Command, { command: 'github:show-waterfall-diagnostics', callback: this.showWaterfallDiagnostics }),
        _react2.default.createElement(_commands.Command, { command: 'github:open-issue-or-pull-request', callback: this.showOpenIssueishDialog }),
        _react2.default.createElement(_commands.Command, { command: 'github:toggle-git-tab', callback: this.gitTabTracker.toggle }),
        _react2.default.createElement(_commands.Command, { command: 'github:toggle-git-tab-focus', callback: this.gitTabTracker.toggleFocus }),
        _react2.default.createElement(_commands.Command, { command: 'github:toggle-github-tab', callback: this.githubTabTracker.toggle }),
        _react2.default.createElement(_commands.Command, { command: 'github:toggle-github-tab-focus', callback: this.githubTabTracker.toggleFocus }),
        _react2.default.createElement(_commands.Command, { command: 'github:clone', callback: this.openCloneDialog }),
        _react2.default.createElement(_commands.Command, {
          command: 'github:view-unstaged-changes-for-current-file',
          callback: this.viewUnstagedChangesForCurrentFile
        }),
        _react2.default.createElement(_commands.Command, {
          command: 'github:view-staged-changes-for-current-file',
          callback: this.viewStagedChangesForCurrentFile
        })
      ),
      this.renderStatusBarTile(),
      this.renderPanels(),
      this.state.filePath && this.state.filePatch ? this.renderFilePatchController() : null,
      this.renderInitDialog(),
      this.renderCloneDialog(),
      this.renderCredentialDialog(),
      this.renderOpenIssueishDialog(),
      this.renderRepositoryConflictController()
    );
  }

  renderStatusBarTile() {
    return _react2.default.createElement(
      _statusBar2.default,
      { statusBar: this.props.statusBar, onConsumeStatusBar: sb => this.onConsumeStatusBar(sb) },
      _react2.default.createElement(_statusBarTileController2.default, {
        workspace: this.props.workspace,
        repository: this.props.repository,
        commandRegistry: this.props.commandRegistry,
        notificationManager: this.props.notificationManager,
        tooltips: this.props.tooltips,
        confirm: this.props.confirm,
        toggleGitTab: this.gitTabTracker.toggle,
        ensureGitTabVisible: this.gitTabTracker.ensureVisible
      })
    );
  }

  renderPanels() {
    if (!this.props.useLegacyPanels) {
      const gitTab = this.state.gitTabActive && _react2.default.createElement(
        _dockItem2.default,
        {
          ref: c => {
            this.gitDockItem = c;
          },
          workspace: this.props.workspace,
          getItem: (_ref3) => {
            let subtree = _ref3.subtree;
            return subtree.getWrappedComponent();
          },
          onDidCloseItem: () => this.setState({ gitTabActive: false }),
          stubItemSelector: 'git-tab-controller',
          activate: this.props.startOpen },
        _react2.default.createElement(
          _etchWrapper2.default,
          {
            ref: c => {
              this.gitTabController = c;
            },
            className: 'github-PanelEtchWrapper',
            reattachDomNode: false },
          _react2.default.createElement(_gitTabController2.default, {
            workspace: this.props.workspace,
            commandRegistry: this.props.commandRegistry,
            notificationManager: this.props.notificationManager,
            repository: this.props.repository,
            initializeRepo: this.initializeRepo,
            resolutionProgress: this.props.resolutionProgress,
            isAmending: this.state.amending,
            didSelectFilePath: this.showFilePatchForPath,
            didDiveIntoFilePath: this.diveIntoFilePatchForPath,
            didSelectMergeConflictFile: this.showMergeConflictFileForPath,
            didDiveIntoMergeConflictPath: this.diveIntoMergeConflictFileForPath,
            showFilePatchForPath: this.showFilePatchForPath,
            didChangeAmending: this.didChangeAmending,
            focusFilePatchView: this.focusFilePatchView,
            ensureGitTab: this.gitTabTracker.ensureVisible,
            openFiles: this.openFiles,
            discardWorkDirChangesForPaths: this.discardWorkDirChangesForPaths,
            undoLastDiscard: this.undoLastDiscard,
            refreshResolutionProgress: this.refreshResolutionProgress
          })
        )
      );

      const githubTab = this.state.githubTabActive && _react2.default.createElement(
        _dockItem2.default,
        {
          ref: c => {
            this.githubDockItem = c;
          },
          workspace: this.props.workspace,
          onDidCloseItem: () => this.setState({ githubTabActive: false }),
          stubItemSelector: 'github-tab-controller' },
        _react2.default.createElement(_githubTabController2.default, {
          ref: c => {
            this.githubTabController = c;
          },
          repository: this.props.repository
        })
      );

      return _react2.default.createElement(
        'div',
        null,
        gitTab,
        githubTab
      );
    }

    return _react2.default.createElement(
      _panel2.default,
      {
        workspace: this.props.workspace,
        location: 'right',
        onDidClosePanel: () => this.setState({ gitTabActive: false, githubTabActive: false }),
        visible: !!this.state.gitTabActive || !!this.state.githubTabActive },
      _react2.default.createElement(
        _resizer2.default,
        {
          size: this.state.panelSize,
          onChange: this.handlePanelResize,
          className: 'github-PanelResizer' },
        _react2.default.createElement(
          _tabs2.default,
          { activeIndex: this.state.activeTab, onChange: this.handleChangeTab, className: 'sidebar-tabs' },
          _react2.default.createElement(
            _tabs2.default.Panel,
            { title: 'Git' },
            _react2.default.createElement(
              _etchWrapper2.default,
              {
                ref: c => {
                  this.gitTabController = c;
                },
                className: 'github-PanelEtchWrapper',
                reattachDomNode: false },
              _react2.default.createElement(_gitTabController2.default, {
                workspace: this.props.workspace,
                commandRegistry: this.props.commandRegistry,
                notificationManager: this.props.notificationManager,
                repository: this.props.repository,
                initializeRepo: this.initializeRepo,
                resolutionProgress: this.props.resolutionProgress,
                isAmending: this.state.amending,
                didSelectFilePath: this.showFilePatchForPath,
                didDiveIntoFilePath: this.diveIntoFilePatchForPath,
                didSelectMergeConflictFile: this.showMergeConflictFileForPath,
                didDiveIntoMergeConflictPath: this.diveIntoMergeConflictFileForPath,
                didChangeAmending: this.didChangeAmending,
                focusFilePatchView: this.focusFilePatchView,
                ensureGitTab: this.gitTabTracker.ensureVisible,
                openFiles: this.openFiles,
                discardWorkDirChangesForPaths: this.discardWorkDirChangesForPaths,
                undoLastDiscard: this.undoLastDiscard,
                refreshResolutionProgress: this.refreshResolutionProgress
              })
            )
          ),
          _react2.default.createElement(
            _tabs2.default.Panel,
            { title: 'GitHub (preview)' },
            _react2.default.createElement(_githubTabController2.default, {
              ref: c => {
                this.githubTabController = c;
              },
              repository: this.props.repository
            })
          )
        )
      )
    );
  }

  renderFilePatchController() {
    return _react2.default.createElement(
      'div',
      null,
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: 'atom-workspace' },
        _react2.default.createElement(_commands.Command, { command: 'github:focus-diff-view', callback: this.focusFilePatchView })
      ),
      _react2.default.createElement(
        _paneItem2.default,
        {
          workspace: this.props.workspace,
          ref: c => {
            this.filePatchControllerPane = c;
          },
          onDidCloseItem: () => {
            this.setState(_extends({}, nullFilePatchState));
          } },
        _react2.default.createElement(_filePatchController2.default, {
          ref: c => {
            this.filePatchController = c;
          },
          activeWorkingDirectory: this.props.activeWorkingDirectory,
          repository: this.props.repository,
          commandRegistry: this.props.commandRegistry,
          tooltips: this.props.tooltips,
          filePatch: this.state.filePatch,
          stagingStatus: this.state.stagingStatus,
          isAmending: this.state.amending,
          isPartiallyStaged: this.state.partiallyStaged,
          onRepoRefresh: this.onRepoRefresh,
          didSurfaceFile: this.surfaceFromFileAtPath,
          didDiveIntoFilePath: this.diveIntoFilePatchForPath,
          quietlySelectItem: this.quietlySelectItem,
          openFiles: this.openFiles,
          discardLines: this.discardLines,
          undoLastDiscard: this.undoLastDiscard,
          switchboard: this.props.switchboard
        })
      )
    );
  }

  renderInitDialog() {
    if (!this.state.initDialogActive) {
      return null;
    }

    return _react2.default.createElement(
      _panel2.default,
      { workspace: this.props.workspace, location: 'modal' },
      _react2.default.createElement(_initDialog2.default, {
        config: this.props.config,
        commandRegistry: this.props.commandRegistry,
        didAccept: this.acceptInit,
        didCancel: this.cancelInit
      })
    );
  }

  renderCloneDialog() {
    if (!this.state.cloneDialogActive) {
      return null;
    }

    return _react2.default.createElement(
      _panel2.default,
      { workspace: this.props.workspace, location: 'modal' },
      _react2.default.createElement(_cloneDialog2.default, {
        config: this.props.config,
        commandRegistry: this.props.commandRegistry,
        didAccept: this.acceptClone,
        didCancel: this.cancelClone,
        inProgress: this.state.cloneDialogInProgress
      })
    );
  }

  renderOpenIssueishDialog() {
    if (!this.state.openIssueishDialogActive) {
      return null;
    }

    return _react2.default.createElement(
      _panel2.default,
      { workspace: this.props.workspace, location: 'modal' },
      _react2.default.createElement(_openIssueishDialog2.default, {
        commandRegistry: this.props.commandRegistry,
        didAccept: this.acceptOpenIssueish,
        didCancel: this.cancelOpenIssueish
      })
    );
  }

  renderCredentialDialog() {
    if (this.state.credentialDialogQuery === null) {
      return null;
    }

    return _react2.default.createElement(
      _panel2.default,
      { workspace: this.props.workspace, location: 'modal' },
      _react2.default.createElement(_credentialDialog2.default, _extends({ commandRegistry: this.props.commandRegistry }, this.state.credentialDialogQuery))
    );
  }

  renderRepositoryConflictController() {
    if (!this.props.repository) {
      return null;
    }

    return _react2.default.createElement(_repositoryConflictController2.default, {
      workspace: this.props.workspace,
      repository: this.props.repository,
      resolutionProgress: this.props.resolutionProgress,
      refreshResolutionProgress: this.refreshResolutionProgress,
      commandRegistry: this.props.commandRegistry
    });
  }

  componentWillUnmount() {
    this.repositoryStateRegistry.save();
    this.subscriptions.dispose();
  }

  onConsumeStatusBar(statusBar) {
    if (statusBar.disableGitInfoTile) {
      statusBar.disableGitInfoTile();
    }
  }

  initializeRepo() {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      if (_this2.props.activeWorkingDirectory) {
        yield _this2.acceptInit(_this2.props.activeWorkingDirectory);
        return;
      }

      _this2.setState({ initDialogActive: true });
    })();
  }

  showOpenIssueishDialog() {
    this.setState({ openIssueishDialogActive: true });
  }

  showWaterfallDiagnostics() {
    this.props.workspace.open('atom-github://debug/timings');
  }

  acceptClone(remoteUrl, projectPath) {
    var _this3 = this;

    return _asyncToGenerator(function* () {
      _this3.setState({ cloneDialogInProgress: true });
      try {
        yield _this3.props.cloneRepositoryForProjectPath(remoteUrl, projectPath);
      } catch (e) {
        _this3.props.notificationManager.addError(`Unable to clone ${remoteUrl}`, { detail: e.stdErr, dismissable: true });
      } finally {
        _this3.setState({ cloneDialogInProgress: false, cloneDialogActive: false });
      }
    })();
  }

  cancelClone() {
    this.setState({ cloneDialogActive: false });
  }

  acceptInit(projectPath) {
    var _this4 = this;

    return _asyncToGenerator(function* () {
      try {
        yield _this4.props.createRepositoryForProjectPath(projectPath);
      } catch (e) {
        _this4.props.notificationManager.addError(`Unable to initialize git repository in ${projectPath}`, { detail: e.stdErr, dismissable: true });
      } finally {
        _this4.setState({ initDialogActive: false });
      }
    })();
  }

  cancelInit() {
    this.setState({ initDialogActive: false });
  }

  acceptOpenIssueish(_ref4) {
    let repoOwner = _ref4.repoOwner,
        repoName = _ref4.repoName,
        issueishNumber = _ref4.issueishNumber;

    const uri = `atom-github://issueish/https://api.github.com/${repoOwner}/${repoName}/${issueishNumber}`;
    this.setState({ openIssueishDialogActive: false });
    this.props.workspace.open(uri);
  }

  cancelOpenIssueish() {
    this.setState({ openIssueishDialogActive: false });
  }

  showFilePatchForPath(filePath, stagingStatus) {
    var _this5 = this;

    var _ref5 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    let activate = _ref5.activate,
        amending = _ref5.amending,
        lineNumber = _ref5.lineNumber;
    return _asyncToGenerator(function* () {
      if (!filePath) {
        return null;
      }
      const repository = _this5.props.repository;
      if (!repository) {
        return null;
      }

      const staged = stagingStatus === 'staged';
      const filePatch = yield repository.getFilePatchForPath(filePath, { staged, amending: staged && amending });
      const partiallyStaged = yield repository.isPartiallyStaged(filePath);
      return new Promise(function (resolve) {
        if (filePatch) {
          _this5.setState({ filePath, filePatch, stagingStatus, partiallyStaged }, function () {
            // TODO: can be better done w/ a prop?
            if (activate && _this5.filePatchControllerPane) {
              _this5.filePatchControllerPane.activate();
              if (lineNumber) {
                _this5.filePatchController.goToDiffLine(lineNumber);
              }
            }
            _this5.props.switchboard.didFinishRender('RootController.showFilePatchForPath');
            resolve();
          });
        } else {
          _this5.setState(_extends({}, nullFilePatchState), function () {
            _this5.props.switchboard.didFinishRender('RootController.showFilePatchForPath');
            resolve();
          });
        }
      });
    })();
  }

  diveIntoFilePatchForPath(filePath, stagingStatus) {
    var _this6 = this;

    let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    return _asyncToGenerator(function* () {
      yield _this6.showFilePatchForPath(filePath, stagingStatus, _extends({}, options, { activate: true }));
      _this6.focusFilePatchView();
    })();
  }

  surfaceFromFileAtPath(filePath, stagingStatus) {
    if (this.gitTabController) {
      this.gitTabController.getWrappedComponent().focusAndSelectStagingItem(filePath, stagingStatus);
    }
  }

  onRepoRefresh() {
    return this.showFilePatchForPath(this.state.filePath, this.state.stagingStatus, { amending: this.state.amending });
  }

  showMergeConflictFileForPath(relativeFilePath) {
    var _this7 = this;

    var _ref6 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    let focus = _ref6.focus;
    return _asyncToGenerator(function* () {
      const absolutePath = _path2.default.join(_this7.props.repository.getWorkingDirectoryPath(), relativeFilePath);
      if (yield new _atom.File(absolutePath).exists()) {
        return _this7.props.workspace.open(absolutePath, { activatePane: Boolean(focus), pending: true });
      } else {
        _this7.props.notificationManager.addInfo('File has been deleted.');
        return null;
      }
    })();
  }

  diveIntoMergeConflictFileForPath(relativeFilePath) {
    return this.showMergeConflictFileForPath(relativeFilePath, { focus: true });
  }

  didChangeAmending(isAmending) {
    this.setState({ amending: isAmending });
    return this.showFilePatchForPath(this.state.filePath, this.state.stagingStatus, { amending: isAmending });
  }

  openCloneDialog() {
    this.setState({ cloneDialogActive: true });
  }

  handlePanelResize(size) {
    this.setState({
      panelSize: Math.max(size, 300)
    });
  }

  handleChangeTab(activeTab) {
    this.setState({ activeTab });
  }

  quietlySelectItem(filePath, stagingStatus) {
    if (this.gitTabController) {
      return this.gitTabController.getWrappedComponent().quietlySelectItem(filePath, stagingStatus);
    } else {
      return null;
    }
  }

  focusFilePatchView() {
    const item = this.filePatchControllerPane.getPaneItem();
    const viewElement = item.getElement().querySelector('[tabindex]');
    viewElement.focus();
  }

  viewChangesForCurrentFile(stagingStatus) {
    const editor = this.props.workspace.getActiveTextEditor();
    const absFilePath = editor.getPath();
    const repoPath = this.props.repository.getWorkingDirectoryPath();
    if (absFilePath.startsWith(repoPath)) {
      const filePath = absFilePath.slice(repoPath.length + 1);
      this.quietlySelectItem(filePath, stagingStatus);
      const splitDirection = this.props.config.get('github.viewChangesForCurrentFileDiffPaneSplitDirection');
      const pane = atom.workspace.getActivePane();
      if (splitDirection === 'right') {
        pane.splitRight();
      } else if (splitDirection === 'down') {
        pane.splitDown();
      }
      return this.diveIntoFilePatchForPath(filePath, stagingStatus, {
        lineNumber: editor.getCursorBufferPosition().row + 1,
        amending: stagingStatus === 'staged' && this.state.isAmending
      });
    } else {
      throw new Error(`${absFilePath} does not belong to repo ${repoPath}`);
    }
  }

  viewUnstagedChangesForCurrentFile() {
    this.viewChangesForCurrentFile('unstaged');
  }

  viewStagedChangesForCurrentFile() {
    this.viewChangesForCurrentFile('staged');
  }

  goToDiffLine(lineNumber) {
    return this.filePatchController.goToDiffLine(lineNumber);
  }

  openFiles(filePaths) {
    return Promise.all(filePaths.map(filePath => {
      const absolutePath = _path2.default.join(this.props.repository.getWorkingDirectoryPath(), filePath);
      return this.props.workspace.open(absolutePath, { pending: filePaths.length === 1 });
    }));
  }

  getUnsavedFiles(filePaths) {
    const isModifiedByPath = new Map();
    this.props.workspace.getTextEditors().forEach(editor => {
      isModifiedByPath.set(editor.getPath(), editor.isModified());
    });
    return filePaths.filter(filePath => {
      const absFilePath = _path2.default.join(this.props.repository.getWorkingDirectoryPath(), filePath);
      return isModifiedByPath.get(absFilePath);
    });
  }

  ensureNoUnsavedFiles(filePaths, message) {
    const unsavedFiles = this.getUnsavedFiles(filePaths).map(filePath => `\`${filePath}\``).join('<br>');
    if (unsavedFiles.length) {
      this.props.notificationManager.addError(message, {
        description: `You have unsaved changes in:<br>${unsavedFiles}.`,
        dismissable: true
      });
      return false;
    } else {
      return true;
    }
  }

  discardWorkDirChangesForPaths(filePaths) {
    var _this8 = this;

    return _asyncToGenerator(function* () {
      const destructiveAction = function () {
        return _this8.props.repository.discardWorkDirChangesForPaths(filePaths);
      };
      return yield _this8.props.repository.storeBeforeAndAfterBlobs(filePaths, function () {
        return _this8.ensureNoUnsavedFiles(filePaths, 'Cannot discard changes in selected files.');
      }, destructiveAction);
    })();
  }

  discardLines(lines) {
    var _this9 = this;

    return _asyncToGenerator(function* () {
      const filePath = _this9.state.filePatch.getPath();
      const filePatch = _this9.state.filePatch;
      const destructiveAction = (() => {
        var _ref7 = _asyncToGenerator(function* () {
          const discardFilePatch = filePatch.getUnstagePatchForLines(lines);
          yield _this9.props.repository.applyPatchToWorkdir(discardFilePatch);
        });

        return function destructiveAction() {
          return _ref7.apply(this, arguments);
        };
      })();
      return yield _this9.props.repository.storeBeforeAndAfterBlobs([filePath], function () {
        return _this9.ensureNoUnsavedFiles([filePath], 'Cannot discard lines.');
      }, destructiveAction, filePath);
    })();
  }

  getFilePathsForLastDiscard() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    let lastSnapshots = this.props.repository.getLastHistorySnapshots(partialDiscardFilePath);
    if (partialDiscardFilePath) {
      lastSnapshots = lastSnapshots ? [lastSnapshots] : [];
    }
    return lastSnapshots.map(snapshot => snapshot.filePath);
  }

  undoLastDiscard() {
    var _this10 = this;

    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
    return _asyncToGenerator(function* () {
      const filePaths = _this10.getFilePathsForLastDiscard(partialDiscardFilePath);
      try {
        const results = yield _this10.props.repository.restoreLastDiscardInTempFiles(function () {
          return _this10.ensureNoUnsavedFiles(filePaths, 'Cannot undo last discard.');
        }, partialDiscardFilePath);
        if (results.length === 0) {
          return;
        }
        yield _this10.proceedOrPromptBasedOnResults(results, partialDiscardFilePath);
      } catch (e) {
        if (e instanceof _gitShellOutStrategy.GitError && e.stdErr.match(/fatal: Not a valid object name/)) {
          _this10.cleanUpHistoryForFilePaths(filePaths, partialDiscardFilePath);
        } else {
          // eslint-disable-next-line no-console
          console.error(e);
        }
      }
    })();
  }

  proceedOrPromptBasedOnResults(results) {
    var _this11 = this;

    let partialDiscardFilePath = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    return _asyncToGenerator(function* () {
      const conflicts = results.filter(function (_ref8) {
        let conflict = _ref8.conflict;
        return conflict;
      });
      if (conflicts.length === 0) {
        yield _this11.proceedWithLastDiscardUndo(results, partialDiscardFilePath);
      } else {
        yield _this11.promptAboutConflicts(results, conflicts, partialDiscardFilePath);
      }
    })();
  }

  promptAboutConflicts(results, conflicts) {
    var _this12 = this;

    let partialDiscardFilePath = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
    return _asyncToGenerator(function* () {
      const conflictedFiles = conflicts.map(function (_ref9) {
        let filePath = _ref9.filePath;
        return `\t${filePath}`;
      }).join('\n');
      const choice = _this12.props.confirm({
        message: 'Undoing will result in conflicts...',
        detailedMessage: `for the following files:\n${conflictedFiles}\n` + 'Would you like to apply the changes with merge conflict markers, ' + 'or open the text with merge conflict markers in a new file?',
        buttons: ['Merge with conflict markers', 'Open in new file', 'Cancel undo']
      });
      if (choice === 0) {
        yield _this12.proceedWithLastDiscardUndo(results, partialDiscardFilePath);
      } else if (choice === 1) {
        yield _this12.openConflictsInNewEditors(conflicts.map(function (_ref10) {
          let resultPath = _ref10.resultPath;
          return resultPath;
        }));
      }
    })();
  }

  cleanUpHistoryForFilePaths(filePaths) {
    let partialDiscardFilePath = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

    this.props.repository.clearDiscardHistory(partialDiscardFilePath);
    const filePathsStr = filePaths.map(filePath => `\`${filePath}\``).join('<br>');
    this.props.notificationManager.addError('Discard history has expired.', {
      description: `Cannot undo discard for<br>${filePathsStr}<br>Stale discard history has been deleted.`,
      dismissable: true
    });
  }

  proceedWithLastDiscardUndo(results) {
    var _this13 = this;

    let partialDiscardFilePath = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    return _asyncToGenerator(function* () {
      const promises = results.map((() => {
        var _ref11 = _asyncToGenerator(function* (result) {
          const filePath = result.filePath,
                resultPath = result.resultPath,
                deleted = result.deleted,
                conflict = result.conflict,
                theirsSha = result.theirsSha,
                commonBaseSha = result.commonBaseSha,
                currentSha = result.currentSha;

          const absFilePath = _path2.default.join(_this13.props.repository.getWorkingDirectoryPath(), filePath);
          if (deleted && resultPath === null) {
            yield (0, _helpers.deleteFileOrFolder)(absFilePath);
          } else {
            yield (0, _helpers.copyFile)(resultPath, absFilePath);
          }
          if (conflict) {
            yield _this13.props.repository.writeMergeConflictToIndex(filePath, commonBaseSha, currentSha, theirsSha);
          }
        });

        return function (_x11) {
          return _ref11.apply(this, arguments);
        };
      })());
      yield Promise.all(promises);
      yield _this13.props.repository.popDiscardHistory(partialDiscardFilePath);
    })();
  }

  openConflictsInNewEditors(resultPaths) {
    var _this14 = this;

    return _asyncToGenerator(function* () {
      const editorPromises = resultPaths.map(function (resultPath) {
        return _this14.props.workspace.open(resultPath);
      });
      return yield Promise.all(editorPromises);
    })();
  }

  /*
   * Asynchronously count the conflict markers present in a file specified by full path.
   */

  refreshResolutionProgress(fullPath) {
    const readStream = _fs2.default.createReadStream(fullPath, { encoding: 'utf8' });
    return new Promise(resolve => {
      _conflict2.default.countFromStream(readStream).then(count => {
        this.props.resolutionProgress.reportMarkerCount(fullPath, count);
      });
    });
  }

  /*
   * Display the credential entry dialog. Return a Promise that will resolve with the provided credentials on accept
   * or reject on cancel.
   */
  promptForCredentials(query) {
    return new Promise((resolve, reject) => {
      this.setState({
        credentialDialogQuery: _extends({}, query, {
          onSubmit: response => this.setState({ credentialDialogQuery: null }, () => resolve(response)),
          onCancel: () => this.setState({ credentialDialogQuery: null }, reject)
        })
      });
    });
  }
}, _class2.propTypes = {
  workspace: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired,
  notificationManager: _propTypes2.default.object.isRequired,
  tooltips: _propTypes2.default.object.isRequired,
  config: _propTypes2.default.object.isRequired,
  confirm: _propTypes2.default.func.isRequired,
  activeWorkingDirectory: _propTypes2.default.string,
  createRepositoryForProjectPath: _propTypes2.default.func,
  cloneRepositoryForProjectPath: _propTypes2.default.func,
  repository: _propTypes2.default.object.isRequired,
  resolutionProgress: _propTypes2.default.object.isRequired,
  statusBar: _propTypes2.default.object,
  switchboard: _propTypes2.default.instanceOf(_switchboard2.default),
  savedState: _propTypes2.default.object,
  useLegacyPanels: _propTypes2.default.bool,
  startOpen: _react2.default.PropTypes.bool
}, _class2.defaultProps = {
  switchboard: new _switchboard2.default(),
  savedState: {},
  useLegacyPanels: false,
  startOpen: true
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'initializeRepo', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'initializeRepo'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'showOpenIssueishDialog', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'showOpenIssueishDialog'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'showWaterfallDiagnostics', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'showWaterfallDiagnostics'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'acceptClone', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'acceptClone'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'cancelClone', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'cancelClone'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'acceptInit', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'acceptInit'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'cancelInit', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'cancelInit'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'acceptOpenIssueish', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'acceptOpenIssueish'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'cancelOpenIssueish', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'cancelOpenIssueish'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'showFilePatchForPath', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'showFilePatchForPath'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'diveIntoFilePatchForPath', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'diveIntoFilePatchForPath'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'surfaceFromFileAtPath', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'surfaceFromFileAtPath'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'onRepoRefresh', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'onRepoRefresh'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'showMergeConflictFileForPath', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'showMergeConflictFileForPath'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'diveIntoMergeConflictFileForPath', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'diveIntoMergeConflictFileForPath'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'didChangeAmending', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'didChangeAmending'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'openCloneDialog', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'openCloneDialog'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'handlePanelResize', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handlePanelResize'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'handleChangeTab', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleChangeTab'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'quietlySelectItem', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'quietlySelectItem'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'focusFilePatchView', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'focusFilePatchView'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'viewUnstagedChangesForCurrentFile', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'viewUnstagedChangesForCurrentFile'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'viewStagedChangesForCurrentFile', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'viewStagedChangesForCurrentFile'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'goToDiffLine', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'goToDiffLine'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'openFiles', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'openFiles'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getUnsavedFiles', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'getUnsavedFiles'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'ensureNoUnsavedFiles', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'ensureNoUnsavedFiles'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'discardWorkDirChangesForPaths', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'discardWorkDirChangesForPaths'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'discardLines', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'discardLines'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'undoLastDiscard', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'undoLastDiscard'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'refreshResolutionProgress', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'refreshResolutionProgress'), _class.prototype)), _class);
exports.default = RootController;
let TabTracker = (_class3 = class TabTracker {
  constructor(name, _ref12) {
    let useLegacyPanels = _ref12.useLegacyPanels,
        getState = _ref12.getState,
        setState = _ref12.setState,
        getController = _ref12.getController,
        getDockItem = _ref12.getDockItem,
        getWorkspace = _ref12.getWorkspace;

    this.name = name;

    this.useLegacyPanels = useLegacyPanels;
    this.getState = getState;
    this.getWorkspace = getWorkspace;
    this.getController = getController;
    this.getDockItem = getDockItem;

    this.setStateKey = function (value) {
      let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : { activateTab: false };

      return new Promise(resolve => setState(value, options, resolve));
    };
  }

  getControllerComponent() {
    const controller = this.getController();

    if (!controller.getWrappedComponent) {
      return controller;
    }

    return controller.getWrappedComponent();
  }

  toggle() {
    var _this15 = this;

    return _asyncToGenerator(function* () {
      const focusToRestore = document.activeElement;
      let shouldRestoreFocus = false;

      // Rendered => the dock item is being rendered, whether or not the dock is visible or the item
      //   is visible within its dock.
      // Visible => the item is active and the dock item is active within its dock.
      const wasRendered = _this15.getState();
      const wasVisible = _this15.isVisible();

      if (!wasRendered) {
        // Not rendered.
        yield _this15.setStateKey(true, { activateTab: true });
        yield _this15.reveal();
        shouldRestoreFocus = true;
      } else if (!wasVisible) {
        // Rendered, but not an active item in a visible dock.
        yield _this15.reveal();
        shouldRestoreFocus = true;
      } else {
        // Rendered and an active item within a visible dock.
        if (_this15.useLegacyPanels) {
          yield _this15.setStateKey(false);
        } else {
          yield _this15.hide();
        }
        shouldRestoreFocus = false;
      }

      if (shouldRestoreFocus) {
        process.nextTick(function () {
          return focusToRestore.focus();
        });
      }
    })();
  }

  toggleFocus() {
    var _this16 = this;

    return _asyncToGenerator(function* () {
      yield _this16.ensureVisible();

      if (_this16.hasFocus()) {
        let workspace = _this16.getWorkspace();
        if (workspace.getCenter) {
          workspace = workspace.getCenter();
        }
        workspace.getActivePane().activate();
      } else {
        _this16.focus();
      }
    })();
  }

  ensureVisible() {
    var _this17 = this;

    return _asyncToGenerator(function* () {
      if (!_this17.isVisible()) {
        yield _this17.setStateKey(true, { activateTab: true });
        yield _this17.reveal();
        return true;
      }
      return false;
    })();
  }

  reveal() {
    const dockItem = this.getDockItem();
    return dockItem ? dockItem.reveal() : Promise.resolve(null);
  }

  hide() {
    const dockItem = this.getDockItem();
    return dockItem ? dockItem.hide() : Promise.resolve(null);
  }

  focus() {
    this.getControllerComponent().restoreFocus();
  }

  isVisible() {
    if (!this.getState()) {
      return false;
    }

    const item = this.getDockItem();
    if (!item) {
      // Legacy panels active. Use getState(), which is true.
      return true;
    }

    const workspace = this.getWorkspace();
    return workspace.getPaneContainers().filter(container => container === workspace.getCenter() || container.isVisible()).some(container => container.getPanes().some(pane => pane.getActiveItem() === item.getDockItem()));
  }

  hasFocus() {
    return this.getControllerComponent().hasFocus();
  }
}, (_applyDecoratedDescriptor(_class3.prototype, 'toggle', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class3.prototype, 'toggle'), _class3.prototype), _applyDecoratedDescriptor(_class3.prototype, 'toggleFocus', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class3.prototype, 'toggleFocus'), _class3.prototype), _applyDecoratedDescriptor(_class3.prototype, 'ensureVisible', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class3.prototype, 'ensureVisible'), _class3.prototype)), _class3);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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