'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _dec, _class, _class2, _temp;

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _yubikiri = require('yubikiri');

var _yubikiri2 = _interopRequireDefault(_yubikiri);

var _eventKit = require('event-kit');

var _observeModel = require('../decorators/observe-model');

var _observeModel2 = _interopRequireDefault(_observeModel);

var _resolutionProgress = require('../models/conflicts/resolution-progress');

var _resolutionProgress2 = _interopRequireDefault(_resolutionProgress);

var _editorConflictController = require('./editor-conflict-controller');

var _editorConflictController2 = _interopRequireDefault(_editorConflictController);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Render an `EditorConflictController` for each `TextEditor` open on a file that contains git conflict markers.
 */
let RepositoryConflictController = (_dec = (0, _observeModel2.default)({
  getModel: props => props.repository,
  fetchData: (r, props) => {
    return (0, _yubikiri2.default)({
      workingDirectoryPath: r.getWorkingDirectoryPath(),
      mergeConflictPaths: r.getMergeConflicts().then(conflicts => conflicts.map(conflict => conflict.filePath)),
      isRebasing: r.isRebasing()
    });
  }
}), _dec(_class = (_temp = _class2 = class RepositoryConflictController extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.state = { openEditors: this.props.workspace.getTextEditors() };
    this.subscriptions = new _eventKit.CompositeDisposable();
  }

  componentDidMount() {
    this.subscriptions.add(this.props.workspace.observeTextEditors(() => {
      this.setState({
        openEditors: this.props.workspace.getTextEditors()
      });
    }));
  }

  render() {
    const conflictingEditors = this.getConflictingEditors();

    return _react2.default.createElement(
      'div',
      null,
      conflictingEditors.map(editor => _react2.default.createElement(_editorConflictController2.default, {
        key: editor.id,
        commandRegistry: this.props.commandRegistry,
        resolutionProgress: this.props.resolutionProgress,
        editor: editor,
        isRebase: this.props.isRebasing,
        refreshResolutionProgress: this.props.refreshResolutionProgress
      }))
    );
  }

  getConflictingEditors() {
    if (this.props.mergeConflictPaths.length === 0 || this.state.openEditors.length === 0) {
      return [];
    }

    const commonBasePath = this.props.repository.getWorkingDirectoryPath();
    const fullMergeConflictPaths = new Set(this.props.mergeConflictPaths.map(relativePath => _path2.default.join(commonBasePath, relativePath)));

    return this.state.openEditors.filter(editor => fullMergeConflictPaths.has(editor.getPath()));
  }

  componentWillUnmount() {
    this.subscriptions.dispose();
  }
}, _class2.propTypes = {
  workspace: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired,
  resolutionProgress: _propTypes2.default.object.isRequired,
  repository: _propTypes2.default.object.isRequired,
  mergeConflictPaths: _propTypes2.default.arrayOf(_propTypes2.default.string),
  isRebasing: _propTypes2.default.bool,
  refreshResolutionProgress: _propTypes2.default.func
}, _class2.defaultProps = {
  resolutionProgress: new _resolutionProgress2.default(),
  mergeConflictPaths: [],
  isRebasing: false,
  refreshResolutionProgress: () => {}
}, _temp)) || _class);
exports.default = RepositoryConflictController;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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