'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _class, _temp, _desc, _value, _class2, _class3, _temp2;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _yubikiri = require('yubikiri');

var _yubikiri2 = _interopRequireDefault(_yubikiri);

var _remotePrController = require('./remote-pr-controller');

var _remotePrController2 = _interopRequireDefault(_remotePrController);

var _githubLoginModel = require('../models/github-login-model');

var _githubLoginModel2 = _interopRequireDefault(_githubLoginModel);

var _observeModel = require('../views/observe-model');

var _observeModel2 = _interopRequireDefault(_observeModel);

var _propTypes3 = require('../prop-types');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let RemoteSelector = (_temp = _class = class RemoteSelector extends _react2.default.Component {

  render() {
    var _props = this.props;
    const remotes = _props.remotes,
          currentBranchName = _props.currentBranchName,
          selectRemote = _props.selectRemote;

    return _react2.default.createElement(
      'div',
      { className: 'github-RemoteSelector' },
      _react2.default.createElement(
        'p',
        null,
        'This repository has multiple remotes hosted at GitHub.com. Select a remote to see pull requests associated with the ',
        _react2.default.createElement(
          'strong',
          null,
          currentBranchName
        ),
        ' branch.'
      ),
      _react2.default.createElement(
        'ul',
        null,
        remotes.map(remote => _react2.default.createElement(
          'li',
          { key: remote.getName() },
          _react2.default.createElement(
            'a',
            { href: '#', onClick: e => selectRemote(e, remote) },
            remote.getName(),
            ' (',
            remote.getOwner(),
            '/',
            remote.getRepo(),
            ')'
          )
        ))
      )
    );
  }
}, _class.propTypes = {
  remotes: _propTypes2.default.arrayOf(_propTypes3.RemotePropType).isRequired,
  currentBranchName: _propTypes2.default.string.isRequired,
  selectRemote: _propTypes2.default.func.isRequired
}, _temp);
let GithubTabController = (_class2 = (_temp2 = _class3 = class GithubTabController extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    this.loginModel = _githubLoginModel2.default.get();
  }

  fetchModelData(repo) {
    return (0, _yubikiri2.default)({
      remotes: repo.getRemotes().then(remotes => remotes.filter(remote => remote.isGithubRepo())),
      currentBranch: repo.getCurrentBranch(),
      selectedRemoteName: repo.getConfig('atomGithub.currentRemote'),
      selectedPrUrl: (() => {
        var _ref = _asyncToGenerator(function* (query) {
          const branch = yield query.currentBranch;
          if (!branch.isPresent() || branch.isDetached()) {
            return null;
          }
          return repo.getConfig(`branch.${branch.getName()}.atomPrUrl`);
        });

        return function selectedPrUrl(_x) {
          return _ref.apply(this, arguments);
        };
      })()
    });
  }

  serialize() {
    return {
      deserializer: 'GithubTabControllerStub'
    };
  }

  render() {
    return _react2.default.createElement(
      _observeModel2.default,
      { model: this.props.repository, fetchData: this.fetchModelData },
      data => {
        return data ? this.renderWithData(data) : null;
      }
    );
  }

  renderWithData(_ref2) {
    let remotes = _ref2.remotes,
        currentBranch = _ref2.currentBranch,
        selectedRemoteName = _ref2.selectedRemoteName,
        selectedPrUrl = _ref2.selectedPrUrl;

    if (!this.props.repository.isPresent() || !remotes) {
      return null;
    }

    if (!currentBranch.isPresent() || currentBranch.isDetached()) {
      return null;
    }

    let remote = remotes.find(r => r.getName() === selectedRemoteName);
    let manyRemotesAvailable = false;
    if (!remote && remotes.length === 1) {
      remote = remotes[0];
    } else if (!remote && remotes.length > 1) {
      manyRemotesAvailable = true;
    }

    return _react2.default.createElement(
      'div',
      { ref: c => {
          this.root = c;
        }, className: 'github-GithubTabController' },
      _react2.default.createElement(
        'div',
        { className: 'github-GithubTabController-content' },
        remote && _react2.default.createElement(_remotePrController2.default, {
          host: 'https://api.github.com',
          loginModel: this.loginModel,
          onSelectPr: prUrl => this.handleSelectPrByUrl(prUrl, currentBranch),
          selectedPrUrl: selectedPrUrl,
          onUnpinPr: () => this.handleUnpinPr(currentBranch),
          remote: remote,
          currentBranchName: currentBranch.getName()
        }),
        !remote && manyRemotesAvailable && _react2.default.createElement(RemoteSelector, {
          remotes: remotes,
          currentBranchName: currentBranch.getName(),
          selectRemote: this.handleRemoteSelect
        }),
        !remote && !manyRemotesAvailable && this.renderNoRemotes()
      )
    );
  }

  handleSelectPrByUrl(prUrl, currentBranch) {
    return this.props.repository.setConfig(`branch.${currentBranch.getName()}.atomPrUrl`, prUrl);
  }

  handleUnpinPr(currentBranch) {
    return this.props.repository.unsetConfig(`branch.${currentBranch.getName()}.atomPrUrl`);
  }

  getTitle() {
    return 'GitHub (preview)';
  }

  getIconName() {
    return 'octoface';
  }

  getDefaultLocation() {
    return 'right';
  }

  getPreferredWidth() {
    return 400;
  }

  getURI() {
    return 'atom-github://stub-uri/github-tab-controller';
  }

  getWorkingDirectory() {
    return this.props.repository.getWorkingDirectoryPath();
  }

  renderNoRemotes() {
    return _react2.default.createElement(
      'div',
      { className: 'github-GithubTabController-no-remotes' },
      'This repository does not have any remotes hosted at GitHub.com.'
    );
  }

  handleRemoteSelect(e, remote) {
    e.preventDefault();
    this.props.repository.setConfig('atomGithub.currentRemote', remote.getName());
  }

  hasFocus() {
    return this.root && this.root.contains(document.activeElement);
  }

  restoreFocus() {
    // No-op
  }
}, _class3.propTypes = {
  repository: _propTypes2.default.object
}, _temp2), (_applyDecoratedDescriptor(_class2.prototype, 'handleSelectPrByUrl', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class2.prototype, 'handleSelectPrByUrl'), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, 'handleUnpinPr', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class2.prototype, 'handleUnpinPr'), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, 'handleRemoteSelect', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class2.prototype, 'handleRemoteSelect'), _class2.prototype)), _class2);
exports.default = GithubTabController;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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