'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Commits = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../../views/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _commitContainer = require('./commit-container');

var _commitContainer2 = _interopRequireDefault(_commitContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let Commits = exports.Commits = (_temp = _class = class Commits extends _react2.default.Component {

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'commits' },
      this.renderSummary(),
      this.renderCommits()
    );
  }

  renderSummary() {
    if (this.props.nodes.length > 1) {
      const namesString = this.calculateNames(this.props.nodes);
      return _react2.default.createElement(
        'div',
        { className: 'info-row' },
        _react2.default.createElement(_octicon2.default, { className: 'pre-timeline-item-icon', icon: 'repo-push' }),
        _react2.default.createElement(
          'span',
          { className: 'comment-message-header' },
          namesString,
          ' added some commits...'
        )
      );
    } else {
      return null;
    }
  }

  renderCommits() {
    return this.props.nodes.map(node => {
      return _react2.default.createElement(_commitContainer2.default, { key: node.id, item: node });
    });
  }

  calculateNames(commits) {
    let names = new Set();
    commits.forEach(commit => {
      let name = null;
      if (commit.author.user) {
        name = commit.author.user.login;
      } else if (commit.author.name) {
        name = commit.author.name;
      }

      if (name && !names.has(name)) {
        names.add(name);
      }
    });

    names = Array.from(names);
    if (names.length === 1) {
      return names[0];
    } else if (names.length === 2) {
      return `${names[0]} and ${names[1]}`;
    } else if (names.length > 2) {
      return `${names[0]}, ${names[1]}, and others`;
    } else {
      return 'Someone';
    }
  }

}, _class.propTypes = {
  nodes: _propTypes2.default.arrayOf(_propTypes2.default.shape({
    author: _propTypes2.default.shape({
      name: _propTypes2.default.string,
      user: _propTypes2.default.shape({
        login: _propTypes2.default.string.isRequired
      })
    }).isRequired
  }).isRequired).isRequired
}, _temp);
exports.default = _reactRelay2.default.createContainer(Commits, {
  fragments: {
    nodes: () => function (RQL_0) {
      return {
        children: [].concat.apply([], [{
          fieldName: 'id',
          kind: 'Field',
          metadata: {
            isRequisite: true
          },
          type: 'ID'
        }, {
          children: [{
            fieldName: 'name',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            children: [{
              fieldName: 'login',
              kind: 'Field',
              metadata: {},
              type: 'String'
            }, {
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }],
            fieldName: 'user',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              inferredRootCallName: 'node',
              inferredPrimaryKey: 'id'
            },
            type: 'User'
          }],
          fieldName: 'author',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true
          },
          type: 'GitActor'
        }, _reactRelay2.default.QL.__frag(RQL_0)]),
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {
          plural: true
        },
        name: 'Commits_NodesRelayQL',
        type: 'Commit'
      };
    }(_commitContainer2.default.getFragment('item'))
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNvbW1pdHMtY29udGFpbmVyLmpzIl0sIm5hbWVzIjpbIkNvbW1pdHMiLCJDb21wb25lbnQiLCJyZW5kZXIiLCJyZW5kZXJTdW1tYXJ5IiwicmVuZGVyQ29tbWl0cyIsInByb3BzIiwibm9kZXMiLCJsZW5ndGgiLCJuYW1lc1N0cmluZyIsImNhbGN1bGF0ZU5hbWVzIiwibWFwIiwibm9kZSIsImlkIiwiY29tbWl0cyIsIm5hbWVzIiwiU2V0IiwiZm9yRWFjaCIsImNvbW1pdCIsIm5hbWUiLCJhdXRob3IiLCJ1c2VyIiwibG9naW4iLCJoYXMiLCJhZGQiLCJBcnJheSIsImZyb20iLCJwcm9wVHlwZXMiLCJhcnJheU9mIiwic2hhcGUiLCJzdHJpbmciLCJpc1JlcXVpcmVkIiwiY3JlYXRlQ29udGFpbmVyIiwiZnJhZ21lbnRzIiwiZ2V0RnJhZ21lbnQiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7OztBQUFBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUVBOzs7O0FBQ0E7Ozs7OztJQUVhQSxPLFdBQUFBLE8scUJBQU4sTUFBTUEsT0FBTixTQUFzQixnQkFBTUMsU0FBNUIsQ0FBc0M7O0FBYzNDQyxXQUFTO0FBQ1AsV0FDRTtBQUFBO0FBQUEsUUFBSyxXQUFVLFNBQWY7QUFDRyxXQUFLQyxhQUFMLEVBREg7QUFFRyxXQUFLQyxhQUFMO0FBRkgsS0FERjtBQU1EOztBQUVERCxrQkFBZ0I7QUFDZCxRQUFJLEtBQUtFLEtBQUwsQ0FBV0MsS0FBWCxDQUFpQkMsTUFBakIsR0FBMEIsQ0FBOUIsRUFBaUM7QUFDL0IsWUFBTUMsY0FBYyxLQUFLQyxjQUFMLENBQW9CLEtBQUtKLEtBQUwsQ0FBV0MsS0FBL0IsQ0FBcEI7QUFDQSxhQUNFO0FBQUE7QUFBQSxVQUFLLFdBQVUsVUFBZjtBQUNFLDJEQUFTLFdBQVUsd0JBQW5CLEVBQTRDLE1BQUssV0FBakQsR0FERjtBQUVFO0FBQUE7QUFBQSxZQUFNLFdBQVUsd0JBQWhCO0FBQ0dFLHFCQURIO0FBQUE7QUFBQTtBQUZGLE9BREY7QUFRRCxLQVZELE1BVU87QUFDTCxhQUFPLElBQVA7QUFDRDtBQUNGOztBQUVESixrQkFBZ0I7QUFDZCxXQUFPLEtBQUtDLEtBQUwsQ0FBV0MsS0FBWCxDQUFpQkksR0FBakIsQ0FBcUJDLFFBQVE7QUFDbEMsYUFBTywyREFBUSxLQUFLQSxLQUFLQyxFQUFsQixFQUFzQixNQUFNRCxJQUE1QixHQUFQO0FBQ0QsS0FGTSxDQUFQO0FBR0Q7O0FBRURGLGlCQUFlSSxPQUFmLEVBQXdCO0FBQ3RCLFFBQUlDLFFBQVEsSUFBSUMsR0FBSixFQUFaO0FBQ0FGLFlBQVFHLE9BQVIsQ0FBZ0JDLFVBQVU7QUFDeEIsVUFBSUMsT0FBTyxJQUFYO0FBQ0EsVUFBSUQsT0FBT0UsTUFBUCxDQUFjQyxJQUFsQixFQUF3QjtBQUN0QkYsZUFBT0QsT0FBT0UsTUFBUCxDQUFjQyxJQUFkLENBQW1CQyxLQUExQjtBQUNELE9BRkQsTUFFTyxJQUFJSixPQUFPRSxNQUFQLENBQWNELElBQWxCLEVBQXdCO0FBQzdCQSxlQUFPRCxPQUFPRSxNQUFQLENBQWNELElBQXJCO0FBQ0Q7O0FBRUQsVUFBSUEsUUFBUSxDQUFDSixNQUFNUSxHQUFOLENBQVVKLElBQVYsQ0FBYixFQUE4QjtBQUM1QkosY0FBTVMsR0FBTixDQUFVTCxJQUFWO0FBQ0Q7QUFDRixLQVhEOztBQWFBSixZQUFRVSxNQUFNQyxJQUFOLENBQVdYLEtBQVgsQ0FBUjtBQUNBLFFBQUlBLE1BQU1QLE1BQU4sS0FBaUIsQ0FBckIsRUFBd0I7QUFDdEIsYUFBT08sTUFBTSxDQUFOLENBQVA7QUFDRCxLQUZELE1BRU8sSUFBSUEsTUFBTVAsTUFBTixLQUFpQixDQUFyQixFQUF3QjtBQUM3QixhQUFRLEdBQUVPLE1BQU0sQ0FBTixDQUFTLFFBQU9BLE1BQU0sQ0FBTixDQUFTLEVBQW5DO0FBQ0QsS0FGTSxNQUVBLElBQUlBLE1BQU1QLE1BQU4sR0FBZSxDQUFuQixFQUFzQjtBQUMzQixhQUFRLEdBQUVPLE1BQU0sQ0FBTixDQUFTLEtBQUlBLE1BQU0sQ0FBTixDQUFTLGNBQWhDO0FBQ0QsS0FGTSxNQUVBO0FBQ0wsYUFBTyxTQUFQO0FBQ0Q7QUFDRjs7QUF0RTBDLEMsU0FDcENZLFMsR0FBWTtBQUNqQnBCLFNBQU8sb0JBQVVxQixPQUFWLENBQ0wsb0JBQVVDLEtBQVYsQ0FBZ0I7QUFDZFQsWUFBUSxvQkFBVVMsS0FBVixDQUFnQjtBQUN0QlYsWUFBTSxvQkFBVVcsTUFETTtBQUV0QlQsWUFBTSxvQkFBVVEsS0FBVixDQUFnQjtBQUNwQlAsZUFBTyxvQkFBVVEsTUFBVixDQUFpQkM7QUFESixPQUFoQjtBQUZnQixLQUFoQixFQUtMQTtBQU5XLEdBQWhCLEVBT0dBLFVBUkUsRUFTTEE7QUFWZSxDO2tCQTBFTixxQkFBTUMsZUFBTixDQUFzQi9CLE9BQXRCLEVBQStCO0FBQzVDZ0MsYUFBVztBQUNUMUIsV0FBTztBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQSxNQUdELDBCQUFPMkIsV0FBUCxDQUFtQixNQUFuQixDQUhDO0FBREU7QUFEaUMsQ0FBL0IsQyIsImZpbGUiOiJjb21taXRzLWNvbnRhaW5lci5qcyIsInNvdXJjZVJvb3QiOiIvaG9tZS90cmF2aXMvYnVpbGQvYXRvbS9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XG5pbXBvcnQgUmVsYXkgZnJvbSAncmVhY3QtcmVsYXknO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcblxuaW1wb3J0IE9jdGljb24gZnJvbSAnLi4vLi4vdmlld3Mvb2N0aWNvbic7XG5pbXBvcnQgQ29tbWl0IGZyb20gJy4vY29tbWl0LWNvbnRhaW5lcic7XG5cbmV4cG9ydCBjbGFzcyBDb21taXRzIGV4dGVuZHMgUmVhY3QuQ29tcG9uZW50IHtcbiAgc3RhdGljIHByb3BUeXBlcyA9IHtcbiAgICBub2RlczogUHJvcFR5cGVzLmFycmF5T2YoXG4gICAgICBQcm9wVHlwZXMuc2hhcGUoe1xuICAgICAgICBhdXRob3I6IFByb3BUeXBlcy5zaGFwZSh7XG4gICAgICAgICAgbmFtZTogUHJvcFR5cGVzLnN0cmluZyxcbiAgICAgICAgICB1c2VyOiBQcm9wVHlwZXMuc2hhcGUoe1xuICAgICAgICAgICAgbG9naW46IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICAgICAgICB9KSxcbiAgICAgICAgfSkuaXNSZXF1aXJlZCxcbiAgICAgIH0pLmlzUmVxdWlyZWQsXG4gICAgKS5pc1JlcXVpcmVkLFxuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIHJldHVybiAoXG4gICAgICA8ZGl2IGNsYXNzTmFtZT1cImNvbW1pdHNcIj5cbiAgICAgICAge3RoaXMucmVuZGVyU3VtbWFyeSgpfVxuICAgICAgICB7dGhpcy5yZW5kZXJDb21taXRzKCl9XG4gICAgICA8L2Rpdj5cbiAgICApO1xuICB9XG5cbiAgcmVuZGVyU3VtbWFyeSgpIHtcbiAgICBpZiAodGhpcy5wcm9wcy5ub2Rlcy5sZW5ndGggPiAxKSB7XG4gICAgICBjb25zdCBuYW1lc1N0cmluZyA9IHRoaXMuY2FsY3VsYXRlTmFtZXModGhpcy5wcm9wcy5ub2Rlcyk7XG4gICAgICByZXR1cm4gKFxuICAgICAgICA8ZGl2IGNsYXNzTmFtZT1cImluZm8tcm93XCI+XG4gICAgICAgICAgPE9jdGljb24gY2xhc3NOYW1lPVwicHJlLXRpbWVsaW5lLWl0ZW0taWNvblwiIGljb249XCJyZXBvLXB1c2hcIiAvPlxuICAgICAgICAgIDxzcGFuIGNsYXNzTmFtZT1cImNvbW1lbnQtbWVzc2FnZS1oZWFkZXJcIj5cbiAgICAgICAgICAgIHtuYW1lc1N0cmluZ30gYWRkZWQgc29tZSBjb21taXRzLi4uXG4gICAgICAgICAgPC9zcGFuPlxuICAgICAgICA8L2Rpdj5cbiAgICAgICk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiBudWxsO1xuICAgIH1cbiAgfVxuXG4gIHJlbmRlckNvbW1pdHMoKSB7XG4gICAgcmV0dXJuIHRoaXMucHJvcHMubm9kZXMubWFwKG5vZGUgPT4ge1xuICAgICAgcmV0dXJuIDxDb21taXQga2V5PXtub2RlLmlkfSBpdGVtPXtub2RlfSAvPjtcbiAgICB9KTtcbiAgfVxuXG4gIGNhbGN1bGF0ZU5hbWVzKGNvbW1pdHMpIHtcbiAgICBsZXQgbmFtZXMgPSBuZXcgU2V0KCk7XG4gICAgY29tbWl0cy5mb3JFYWNoKGNvbW1pdCA9PiB7XG4gICAgICBsZXQgbmFtZSA9IG51bGw7XG4gICAgICBpZiAoY29tbWl0LmF1dGhvci51c2VyKSB7XG4gICAgICAgIG5hbWUgPSBjb21taXQuYXV0aG9yLnVzZXIubG9naW47XG4gICAgICB9IGVsc2UgaWYgKGNvbW1pdC5hdXRob3IubmFtZSkge1xuICAgICAgICBuYW1lID0gY29tbWl0LmF1dGhvci5uYW1lO1xuICAgICAgfVxuXG4gICAgICBpZiAobmFtZSAmJiAhbmFtZXMuaGFzKG5hbWUpKSB7XG4gICAgICAgIG5hbWVzLmFkZChuYW1lKTtcbiAgICAgIH1cbiAgICB9KTtcblxuICAgIG5hbWVzID0gQXJyYXkuZnJvbShuYW1lcyk7XG4gICAgaWYgKG5hbWVzLmxlbmd0aCA9PT0gMSkge1xuICAgICAgcmV0dXJuIG5hbWVzWzBdO1xuICAgIH0gZWxzZSBpZiAobmFtZXMubGVuZ3RoID09PSAyKSB7XG4gICAgICByZXR1cm4gYCR7bmFtZXNbMF19IGFuZCAke25hbWVzWzFdfWA7XG4gICAgfSBlbHNlIGlmIChuYW1lcy5sZW5ndGggPiAyKSB7XG4gICAgICByZXR1cm4gYCR7bmFtZXNbMF19LCAke25hbWVzWzFdfSwgYW5kIG90aGVyc2A7XG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiAnU29tZW9uZSc7XG4gICAgfVxuICB9XG5cbn1cblxuXG5leHBvcnQgZGVmYXVsdCBSZWxheS5jcmVhdGVDb250YWluZXIoQ29tbWl0cywge1xuICBmcmFnbWVudHM6IHtcbiAgICBub2RlczogKCkgPT4gUmVsYXkuUUxgXG4gICAgICBmcmFnbWVudCBvbiBDb21taXQgQHJlbGF5KHBsdXJhbDogdHJ1ZSkge1xuICAgICAgICBpZCBhdXRob3IgeyBuYW1lIHVzZXIgeyBsb2dpbiB9IH1cbiAgICAgICAgJHtDb21taXQuZ2V0RnJhZ21lbnQoJ2l0ZW0nKX1cbiAgICAgIH1cbiAgICBgLFxuICB9LFxufSk7XG4iXX0=