'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class;

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _eventKit = require('event-kit');

var _url = require('url');

var _url2 = _interopRequireDefault(_url);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _coreDecorators = require('core-decorators');

var _issueishPaneItemController = require('../controllers/issueish-pane-item-controller');

var _issueishPaneItemController2 = _interopRequireDefault(_issueishPaneItemController);

var _githubLoginModel = require('../models/github-login-model');

var _githubLoginModel2 = _interopRequireDefault(_githubLoginModel);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

function getPropsFromUri(uri) {
  // atom-github://issueish/https://github-host.tld/owner/repo/issueishNumber
  var _url$parse = _url2.default.parse(uri);

  const protocol = _url$parse.protocol,
        hostname = _url$parse.hostname,
        pathname = _url$parse.pathname;

  if (protocol === 'atom-github:' && hostname === 'issueish') {
    var _pathname$split$filte = pathname.split('/').filter(s => s),
        _pathname$split$filte2 = _slicedToArray(_pathname$split$filte, 5);

    const scheme = _pathname$split$filte2[0],
          host = _pathname$split$filte2[1],
          owner = _pathname$split$filte2[2],
          repo = _pathname$split$filte2[3],
          issueishNum = _pathname$split$filte2[4];

    if (!scheme || !host || !owner || !repo || !issueishNum) {
      return null;
    }
    const issueishNumber = parseInt(issueishNum, 10);
    if (isNaN(issueishNumber)) {
      return null;
    }
    return { owner, repo, issueishNumber, host: `${scheme}//${host}` };
  }
  return null;
}

let IssueishPaneItem = (_class = class IssueishPaneItem {
  static opener(uri) {
    const props = getPropsFromUri(uri);
    if (props) {
      return IssueishPaneItem.create(props, uri);
    } else {
      return null;
    }
  }

  static create(_ref, uri) {
    let owner = _ref.owner,
        repo = _ref.repo,
        issueishNumber = _ref.issueishNumber,
        host = _ref.host;

    return new IssueishPaneItem({ owner, repo, issueishNumber, host }, uri);
  }

  constructor(_ref2, uri) {
    let owner = _ref2.owner,
        repo = _ref2.repo,
        issueishNumber = _ref2.issueishNumber,
        host = _ref2.host;

    this.emitter = new _eventKit.Emitter();

    this.owner = owner;
    this.repo = repo;
    this.issueishNumber = issueishNumber;
    this.host = host;
    this.uri = uri;
    this.title = `${this.owner}/${this.repo}#${this.issueishNumber}`;

    this.createComponent();
  }

  createComponent() {
    this.element = document.createElement('div');
    const loginModel = _githubLoginModel2.default.get();
    const props = {
      owner: this.owner,
      repo: this.repo,
      issueishNumber: this.issueishNumber,
      host: this.host,
      onTitleChange: this.handleTitleChanged,
      loginModel
    };
    this.component = _reactDom2.default.render(_react2.default.createElement(_issueishPaneItemController2.default, props), this.element);
  }

  handleTitleChanged(title) {
    if (this.title !== title) {
      this.title = title;
      this.emitter.emit('did-change-title', title);
    }
  }

  onDidChangeTitle(cb) {
    return this.emitter.on('did-change-title', cb);
  }

  getElement() {
    return this.element;
  }

  serialize() {
    return {
      uri: this.uri,
      deserializer: 'IssueishPaneItem'
    };
  }

  getURI() {
    return this.uri;
  }

  getTitle() {
    return this.title;
  }

  destroy() {
    // TODO: is this right?
    this.emitter.dispose();
    _reactDom2.default.unmountComponentAtNode(this.getElement());
  }
}, (_applyDecoratedDescriptor(_class.prototype, 'handleTitleChanged', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleTitleChanged'), _class.prototype)), _class);
exports.default = IssueishPaneItem;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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