"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

let Task = class Task {
  constructor(fn) {
    let parallel = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

    this.fn = fn;
    this.parallel = parallel;
    this.promise = new Promise((resolve, reject) => {
      this.resolve = resolve;
      this.reject = reject;
    });
  }

  execute() {
    var _this = this;

    return _asyncToGenerator(function* () {
      try {
        const value = yield _this.fn.call(undefined);
        _this.resolve(value);
      } catch (err) {
        _this.reject(err);
      }
    })();
  }

  runsInParallel() {
    return this.parallel;
  }

  runsInSerial() {
    return !this.parallel;
  }

  getPromise() {
    return this.promise;
  }
};
let AsyncQueue = class AsyncQueue {
  constructor() {
    let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    this.parallelism = options.parallelism || 1;
    this.nonParallelizableOperation = false;
    this.tasksInProgress = 0;
    this.queue = [];
  }

  push(fn) {
    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : { parallel: true };

    let parallel = _ref.parallel;

    const task = new Task(fn, parallel);
    this.queue.push(task);
    this.processQueue();
    return task.getPromise();
  }

  processQueue() {
    if (!this.queue.length || this.nonParallelizableOperation || this.disposed) {
      return;
    }

    const task = this.queue[0];
    const canRunParallelOp = task.runsInParallel() && this.tasksInProgress < this.parallelism;
    const canRunSerialOp = task.runsInSerial() && this.tasksInProgress === 0;
    if (canRunSerialOp || canRunParallelOp) {
      this.processTask(task, task.runsInParallel());
      this.queue.shift();
      this.processQueue();
    }
  }

  processTask(task, runsInParallel) {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      if (_this2.disposed) {
        return;
      }

      _this2.tasksInProgress++;
      if (!runsInParallel) {
        _this2.nonParallelizableOperation = true;
      }

      try {
        yield task.execute();
      } finally {
        _this2.tasksInProgress--;
        _this2.nonParallelizableOperation = false;
        _this2.processQueue();
      }
    })();
  }

  dispose() {
    this.queue = [];
    this.disposed = true;
  }
};
exports.default = AsyncQueue;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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