(function() {
  var DiffListView, GitDiffView, diffListView;

  GitDiffView = require('./git-diff-view');

  DiffListView = require('./diff-list-view');

  diffListView = null;

  module.exports = {
    activate: function() {
      return atom.workspace.observeTextEditors(function(editor) {
        new GitDiffView(editor);
        return atom.commands.add(atom.views.getView(editor), 'git-diff:toggle-diff-list', function() {
          if (diffListView == null) {
            diffListView = new DiffListView();
          }
          return diffListView.toggle();
        });
      });
    },
    deactivate: function() {
      if (diffListView != null) {
        diffListView.destroy();
      }
      return diffListView = null;
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2hvbWUvdHJhdmlzL2J1aWxkL2F0b20vYXRvbS9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXQtZGlmZi9saWIvbWFpbi5jb2ZmZWUiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQSxNQUFBOztFQUFBLFdBQUEsR0FBYyxPQUFBLENBQVEsaUJBQVI7O0VBQ2QsWUFBQSxHQUFlLE9BQUEsQ0FBUSxrQkFBUjs7RUFFZixZQUFBLEdBQWU7O0VBRWYsTUFBTSxDQUFDLE9BQVAsR0FDRTtJQUFBLFFBQUEsRUFBVSxTQUFBO2FBQ1IsSUFBSSxDQUFDLFNBQVMsQ0FBQyxrQkFBZixDQUFrQyxTQUFDLE1BQUQ7UUFDNUIsSUFBQSxXQUFBLENBQVksTUFBWjtlQUNKLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBZCxDQUFrQixJQUFJLENBQUMsS0FBSyxDQUFDLE9BQVgsQ0FBbUIsTUFBbkIsQ0FBbEIsRUFBOEMsMkJBQTlDLEVBQTJFLFNBQUE7O1lBQ3pFLGVBQW9CLElBQUEsWUFBQSxDQUFBOztpQkFDcEIsWUFBWSxDQUFDLE1BQWIsQ0FBQTtRQUZ5RSxDQUEzRTtNQUZnQyxDQUFsQztJQURRLENBQVY7SUFPQSxVQUFBLEVBQVksU0FBQTs7UUFDVixZQUFZLENBQUUsT0FBZCxDQUFBOzthQUNBLFlBQUEsR0FBZTtJQUZMLENBUFo7O0FBTkYiLCJzb3VyY2VzQ29udGVudCI6WyJHaXREaWZmVmlldyA9IHJlcXVpcmUgJy4vZ2l0LWRpZmYtdmlldydcbkRpZmZMaXN0VmlldyA9IHJlcXVpcmUgJy4vZGlmZi1saXN0LXZpZXcnXG5cbmRpZmZMaXN0VmlldyA9IG51bGxcblxubW9kdWxlLmV4cG9ydHMgPVxuICBhY3RpdmF0ZTogLT5cbiAgICBhdG9tLndvcmtzcGFjZS5vYnNlcnZlVGV4dEVkaXRvcnMgKGVkaXRvcikgLT5cbiAgICAgIG5ldyBHaXREaWZmVmlldyhlZGl0b3IpXG4gICAgICBhdG9tLmNvbW1hbmRzLmFkZCBhdG9tLnZpZXdzLmdldFZpZXcoZWRpdG9yKSwgJ2dpdC1kaWZmOnRvZ2dsZS1kaWZmLWxpc3QnLCAtPlxuICAgICAgICBkaWZmTGlzdFZpZXcgPz0gbmV3IERpZmZMaXN0VmlldygpXG4gICAgICAgIGRpZmZMaXN0Vmlldy50b2dnbGUoKVxuXG4gIGRlYWN0aXZhdGU6IC0+XG4gICAgZGlmZkxpc3RWaWV3Py5kZXN0cm95KClcbiAgICBkaWZmTGlzdFZpZXcgPSBudWxsXG4iXX0=
