Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atom = require('atom');

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _fuzzaldrin = require('fuzzaldrin');

var _fuzzaldrin2 = _interopRequireDefault(_fuzzaldrin);

var _fuzzaldrinPlus = require('fuzzaldrin-plus');

var _fuzzaldrinPlus2 = _interopRequireDefault(_fuzzaldrinPlus);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var _helpers = require('./helpers');

var _fileIcons = require('./file-icons');

var _fileIcons2 = _interopRequireDefault(_fileIcons);

var FuzzyFinderView = (function () {
  function FuzzyFinderView() {
    var _this = this;

    _classCallCheck(this, FuzzyFinderView);

    this.previousQueryWasLineJump = false;
    this.items = [];
    this.selectListView = new _atomSelectList2['default']({
      items: this.items,
      maxResults: 10,
      emptyMessage: this.getEmptyMessage(),
      filterKeyForItem: function filterKeyForItem(item) {
        return item.projectRelativePath;
      },
      filterQuery: function filterQuery(query) {
        var colon = query.indexOf(':');
        if (colon !== -1) {
          query = query.slice(0, colon);
        }
        // Normalize to backslashes on Windows
        if (process.platform === 'win32') {
          query = query.replace(/\//g, '\\');
        }

        return query;
      },
      didCancelSelection: function didCancelSelection() {
        _this.cancel();
      },
      didConfirmSelection: function didConfirmSelection(item) {
        _this.confirm(item, { searchAllPanes: atom.config.get('fuzzy-finder.searchAllPanes') });
      },
      didConfirmEmptySelection: function didConfirmEmptySelection() {
        _this.confirm();
      },
      didChangeQuery: function didChangeQuery() {
        var isLineJump = _this.isQueryALineJump();
        if (!_this.previousQueryWasLineJump && isLineJump) {
          _this.previousQueryWasLineJump = true;
          _this.selectListView.update({
            items: [],
            emptyMessage: 'Jump to line in active editor'
          });
        } else if (_this.previousQueryWasLineJump && !isLineJump) {
          _this.previousQueryWasLineJump = false;
          _this.selectListView.update({
            items: _this.items,
            emptyMessage: _this.getEmptyMessage()
          });
        }
      },
      elementForItem: function elementForItem(_ref) {
        var _primaryLine$classList;

        var filePath = _ref.filePath;
        var projectRelativePath = _ref.projectRelativePath;

        var filterQuery = _this.selectListView.getFilterQuery();
        var matches = _this.useAlternateScoring ? _fuzzaldrinPlus2['default'].match(projectRelativePath, filterQuery) : _fuzzaldrin2['default'].match(projectRelativePath, filterQuery);

        var li = document.createElement('li');
        li.classList.add('two-lines');

        var repository = (0, _helpers.repositoryForPath)(filePath);
        if (repository) {
          var _status = repository.getCachedPathStatus(filePath);
          if (repository.isStatusNew(_status)) {
            var div = document.createElement('div');
            div.classList.add('status', 'status-added', 'icon', 'icon-diff-added');
            li.appendChild(div);
          } else if (repository.isStatusModified(_status)) {
            var div = document.createElement('div');
            div.classList.add('status', 'status-modified', 'icon', 'icon-diff-modified');
            li.appendChild(div);
          }
        }

        var iconClasses = _fileIcons2['default'].getService().iconClassForPath(filePath, 'fuzzy-finder');
        var classList = undefined;
        if (Array.isArray(iconClasses)) {
          classList = iconClasses;
        } else if (iconClasses) {
          classList = iconClasses.toString().split(/\s+/g);
        } else {
          classList = [];
        }

        var fileBasename = _path2['default'].basename(filePath);
        var baseOffset = projectRelativePath.length - fileBasename.length;
        var primaryLine = document.createElement('div');
        (_primaryLine$classList = primaryLine.classList).add.apply(_primaryLine$classList, ['primary-line', 'file', 'icon'].concat(_toConsumableArray(classList)));
        primaryLine.dataset.name = fileBasename;
        primaryLine.dataset.path = projectRelativePath;
        primaryLine.appendChild(highlight(fileBasename, matches, baseOffset));
        li.appendChild(primaryLine);

        var secondaryLine = document.createElement('div');
        secondaryLine.classList.add('secondary-line', 'path', 'no-icon');
        secondaryLine.appendChild(highlight(projectRelativePath, matches, 0));
        li.appendChild(secondaryLine);

        return li;
      }
    });
    this.selectListView.element.classList.add('fuzzy-finder');

    var splitLeft = function splitLeft() {
      _this.splitOpenPath(function (pane) {
        return pane.splitLeft.bind(pane);
      });
    };
    var splitRight = function splitRight() {
      _this.splitOpenPath(function (pane) {
        return pane.splitRight.bind(pane);
      });
    };
    var splitUp = function splitUp() {
      _this.splitOpenPath(function (pane) {
        return pane.splitUp.bind(pane);
      });
    };
    var splitDown = function splitDown() {
      _this.splitOpenPath(function (pane) {
        return pane.splitDown.bind(pane);
      });
    };
    atom.commands.add(this.selectListView.element, {
      'pane:split-left': splitLeft,
      'pane:split-left-and-copy-active-item': splitLeft,
      'pane:split-left-and-move-active-item': splitLeft,
      'pane:split-right': splitRight,
      'pane:split-right-and-copy-active-item': splitRight,
      'pane:split-right-and-move-active-item': splitRight,
      'pane:split-up': splitUp,
      'pane:split-up-and-copy-active-item': splitUp,
      'pane:split-up-and-move-active-item': splitUp,
      'pane:split-down': splitDown,
      'pane:split-down-and-copy-active-item': splitDown,
      'pane:split-down-and-move-active-item': splitDown,
      'fuzzy-finder:invert-confirm': function fuzzyFinderInvertConfirm() {
        _this.confirm(_this.selectListView.getSelectedItem(), { searchAllPanes: !atom.config.get('fuzzy-finder.searchAllPanes') });
      }
    });

    this.subscriptions = new _atom.CompositeDisposable();
    this.subscriptions.add(atom.config.observe('fuzzy-finder.useAlternateScoring', function (newValue) {
      _this.useAlternateScoring = newValue;
      if (_this.useAlternateScoring) {
        _this.selectListView.update({
          filter: function filter(items, query) {
            return query ? _fuzzaldrinPlus2['default'].filter(items, query, { key: 'projectRelativePath' }) : items;
          }
        });
      } else {
        _this.selectListView.update({ filter: null });
      }
    }));
  }

  _createClass(FuzzyFinderView, [{
    key: 'destroy',
    value: function destroy() {
      if (this.panel) {
        this.panel.destroy();
      }

      if (this.subscriptions) {
        this.subscriptions.dispose();
        this.subscriptions = null;
      }

      return this.selectListView.destroy();
    }
  }, {
    key: 'cancel',
    value: function cancel() {
      if (atom.config.get('fuzzy-finder.preserveLastSearch')) {
        this.selectListView.refs.queryEditor.selectAll();
      } else {
        this.selectListView.reset();
      }

      this.hide();
    }
  }, {
    key: 'confirm',
    value: function confirm(_x, openOptions) {
      var _this2 = this;

      var _ref2 = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

      var filePath = _ref2.filePath;

      if (atom.workspace.getActiveTextEditor() && this.isQueryALineJump()) {
        var lineNumber = this.getLineNumber();
        this.cancel();
        this.moveToLine(lineNumber);
      } else if (!filePath) {
        this.cancel();
      } else if (_fsPlus2['default'].isDirectorySync(filePath)) {
        this.selectListView.update({ errorMessage: 'Selected path is a directory' });
        setTimeout(function () {
          _this2.selectListView.update({ errorMessage: null });
        }, 2000);
      } else {
        var lineNumber = this.getLineNumber();
        this.cancel();
        this.openPath(filePath, lineNumber, openOptions);
      }
    }
  }, {
    key: 'show',
    value: function show() {
      this.previouslyFocusedElement = document.activeElement;
      if (!this.panel) {
        this.panel = atom.workspace.addModalPanel({ item: this });
      }
      this.panel.show();
      this.selectListView.focus();
    }
  }, {
    key: 'hide',
    value: function hide() {
      if (this.panel) {
        this.panel.hide();
      }

      if (this.previouslyFocusedElement) {
        this.previouslyFocusedElement.focus();
        this.previouslyFocusedElement = null;
      }
    }
  }, {
    key: 'openPath',
    value: _asyncToGenerator(function* (filePath, lineNumber, openOptions) {
      if (filePath) {
        yield atom.workspace.open(filePath, openOptions);
        this.moveToLine(lineNumber);
      }
    })
  }, {
    key: 'moveToLine',
    value: function moveToLine() {
      var lineNumber = arguments.length <= 0 || arguments[0] === undefined ? -1 : arguments[0];

      if (lineNumber < 0) {
        return;
      }

      var editor = atom.workspace.getActiveTextEditor();
      if (editor) {
        var position = new _atom.Point(lineNumber, 0);
        editor.scrollToBufferPosition(position, { center: true });
        editor.setCursorBufferPosition(position);
        editor.moveToFirstCharacterOfLine();
      }
    }
  }, {
    key: 'splitOpenPath',
    value: function splitOpenPath(splitFn) {
      var _ref3 = this.selectListView.getSelectedItem() || {};

      var filePath = _ref3.filePath;

      var lineNumber = this.getLineNumber();
      var editor = atom.workspace.getActiveTextEditor();
      var activePane = atom.workspace.getActivePane();

      if (this.isQueryALineJump() && editor) {
        this.previouslyFocusedElement = null;
        splitFn(activePane)({ copyActiveItem: true });
        this.moveToLine(lineNumber);
      } else if (!filePath) {
        return;
      } else if (activePane) {
        this.previouslyFocusedElement = null;
        splitFn(activePane)();
        this.openPath(filePath, lineNumber);
      } else {
        this.previouslyFocusedElement = null;
        this.openPath(filePath, lineNumber);
      }
    }
  }, {
    key: 'isQueryALineJump',
    value: function isQueryALineJump() {
      return this.selectListView.getFilterQuery().trim() == '' && this.selectListView.getQuery().indexOf(':') !== -1;
    }
  }, {
    key: 'getLineNumber',
    value: function getLineNumber() {
      var query = this.selectListView.getQuery();
      var colon = query.indexOf(':');
      if (colon === -1) {
        return -1;
      } else {
        return parseInt(query.slice(colon + 1)) - 1;
      }
    }
  }, {
    key: 'setItems',
    value: function setItems(filePaths) {
      this.items = this.projectRelativePathsForFilePaths(filePaths);
      if (this.isQueryALineJump()) {
        return this.selectListView.update({ items: [], loadingMessage: null, loadingBadge: null });
      } else {
        return this.selectListView.update({ items: this.items, loadingMessage: null, loadingBadge: null });
      }
    }
  }, {
    key: 'projectRelativePathsForFilePaths',
    value: function projectRelativePathsForFilePaths(filePaths) {
      var _this3 = this;

      // Don't regenerate project relative paths unless the file paths have changed
      if (filePaths !== this.filePaths) {
        (function () {
          var projectHasMultipleDirectories = atom.project.getDirectories().length > 1;
          _this3.filePaths = filePaths;
          _this3.projectRelativePaths = _this3.filePaths.map(function (filePath) {
            var _atom$project$relativizePath = atom.project.relativizePath(filePath);

            var _atom$project$relativizePath2 = _slicedToArray(_atom$project$relativizePath, 2);

            var rootPath = _atom$project$relativizePath2[0];
            var projectRelativePath = _atom$project$relativizePath2[1];

            if (rootPath && projectHasMultipleDirectories) {
              projectRelativePath = _path2['default'].join(_path2['default'].basename(rootPath), projectRelativePath);
            }
            return { filePath: filePath, projectRelativePath: projectRelativePath };
          });
        })();
      }

      return this.projectRelativePaths;
    }
  }, {
    key: 'element',
    get: function get() {
      return this.selectListView.element;
    }
  }]);

  return FuzzyFinderView;
})();

exports['default'] = FuzzyFinderView;

function highlight(path, matches, offsetIndex) {
  var lastIndex = 0;
  var matchedChars = [];
  var fragment = document.createDocumentFragment();
  for (var matchIndex of matches) {
    matchIndex -= offsetIndex;
    // If marking up the basename, omit path matches
    if (matchIndex < 0) {
      continue;
    }
    var unmatched = path.substring(lastIndex, matchIndex);
    if (unmatched) {
      if (matchedChars.length > 0) {
        var span = document.createElement('span');
        span.classList.add('character-match');
        span.textContent = matchedChars.join('');
        fragment.appendChild(span);
        matchedChars = [];
      }

      fragment.appendChild(document.createTextNode(unmatched));
    }

    matchedChars.push(path[matchIndex]);
    lastIndex = matchIndex + 1;
  }

  if (matchedChars.length > 0) {
    var span = document.createElement('span');
    span.classList.add('character-match');
    span.textContent = matchedChars.join('');
    fragment.appendChild(span);
  }

  // Remaining characters are plain text
  fragment.appendChild(document.createTextNode(path.substring(lastIndex)));
  return fragment;
}
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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