"use strict";
var parser_public_1 = require("./parse/parser_public");
var lexer_public_1 = require("./scan/lexer_public");
var tokens_public_1 = require("./scan/tokens_public");
var exceptions_public_1 = require("./parse/exceptions_public");
var gast_public_1 = require("./parse/grammar/gast_public");
var cache_public_1 = require("./parse/cache_public");
var interpreter_1 = require("./parse/grammar/interpreter");
/**
 * defines the public API of
 * changes here may require major version change. (semVer)
 */
var API = {};
// semantic version
API.VERSION = "0.18.0";
// runtime API
API.Parser = parser_public_1.Parser;
API.ParserDefinitionErrorType = parser_public_1.ParserDefinitionErrorType;
API.Lexer = lexer_public_1.Lexer;
API.LexerDefinitionErrorType = lexer_public_1.LexerDefinitionErrorType;
API.Token = tokens_public_1.Token;
API.LazyToken = tokens_public_1.LazyToken;
API.SimpleLazyToken = tokens_public_1.SimpleLazyToken;
// TODO: remove this, does not belong on the API.
API.VirtualToken = tokens_public_1.VirtualToken;
API.EOF = tokens_public_1.EOF;
// Tokens utilities
API.extendToken = tokens_public_1.extendToken;
API.extendLazyToken = tokens_public_1.extendLazyToken;
API.extendSimpleLazyToken = tokens_public_1.extendSimpleLazyToken;
API.tokenName = tokens_public_1.tokenName;
API.tokenLabel = tokens_public_1.tokenLabel;
API.tokenMatcher = tokens_public_1.tokenMatcher;
// Tokens getters
API.getImage = tokens_public_1.getImage;
API.getStartOffset = tokens_public_1.getStartOffset;
API.getStartLine = tokens_public_1.getStartLine;
API.getStartColumn = tokens_public_1.getStartColumn;
API.getEndOffset = tokens_public_1.getEndOffset;
API.getEndLine = tokens_public_1.getEndLine;
API.getEndColumn = tokens_public_1.getEndColumn;
API.getTokenConstructor = tokens_public_1.getTokenConstructor;
// Other Utilities
API.EMPTY_ALT = parser_public_1.EMPTY_ALT;
API.exceptions = {};
API.exceptions.isRecognitionException = exceptions_public_1.exceptions.isRecognitionException;
API.exceptions.EarlyExitException = exceptions_public_1.exceptions.EarlyExitException;
API.exceptions.MismatchedTokenException = exceptions_public_1.exceptions.MismatchedTokenException;
API.exceptions.NotAllInputParsedException = exceptions_public_1.exceptions.NotAllInputParsedException;
API.exceptions.NoViableAltException = exceptions_public_1.exceptions.NoViableAltException;
// grammar reflection API
API.gast = {};
API.gast.GAstVisitor = gast_public_1.gast.GAstVisitor;
API.gast.Flat = gast_public_1.gast.Flat;
API.gast.Repetition = gast_public_1.gast.Repetition;
API.gast.RepetitionWithSeparator = gast_public_1.gast.RepetitionWithSeparator;
API.gast.RepetitionMandatory = gast_public_1.gast.RepetitionMandatory;
API.gast.RepetitionMandatoryWithSeparator = gast_public_1.gast.RepetitionMandatoryWithSeparator;
API.gast.Option = gast_public_1.gast.Option;
API.gast.Alternation = gast_public_1.gast.Alternation;
API.gast.NonTerminal = gast_public_1.gast.NonTerminal;
API.gast.Terminal = gast_public_1.gast.Terminal;
API.gast.Rule = gast_public_1.gast.Rule;
API.gast.serializeGrammar = gast_public_1.gast.serializeGrammar;
API.gast.serializeProduction = gast_public_1.gast.serializeProduction;
API.interperter = {};
API.interperter.NextAfterTokenWalker = interpreter_1.NextAfterTokenWalker;
API.clearCache = cache_public_1.clearCache;
module.exports = API;
