(function() {
  var PropertiesURL, fetchPropertyDescriptions, fs, path, propertiesPromise, propertyDescriptionsPromise, request;

  path = require('path');

  fs = require('fs');

  request = require('request');

  fetchPropertyDescriptions = require('./fetch-property-docs');

  PropertiesURL = 'https://raw.githubusercontent.com/adobe/brackets/master/src/extensions/default/CSSCodeHints/CSSProperties.json';

  propertiesPromise = new Promise(function(resolve) {
    return request({
      json: true,
      url: PropertiesURL
    }, function(error, response, properties) {
      if (error != null) {
        console.error(error.message);
        resolve(null);
      }
      if (response.statusCode !== 200) {
        console.error("Request for CSSProperties.json failed: " + response.statusCode);
        resolve(null);
      }
      return resolve(properties);
    });
  });

  propertyDescriptionsPromise = fetchPropertyDescriptions();

  Promise.all([propertiesPromise, propertyDescriptionsPromise]).then(function(values) {
    var completions, i, len, metadata, properties, propertiesRaw, propertyDescriptions, propertyName, pseudoSelectors, sortedPropertyNames, tags;
    properties = {};
    propertiesRaw = values[0];
    propertyDescriptions = values[1];
    sortedPropertyNames = JSON.parse(fs.readFileSync(path.join(__dirname, 'sorted-property-names.json')));
    for (i = 0, len = sortedPropertyNames.length; i < len; i++) {
      propertyName = sortedPropertyNames[i];
      if (!(metadata = propertiesRaw[propertyName])) {
        continue;
      }
      metadata.description = propertyDescriptions[propertyName];
      properties[propertyName] = metadata;
      if (propertyDescriptions[propertyName] == null) {
        console.warn("No description for property " + propertyName);
      }
    }
    for (propertyName in propertiesRaw) {
      if (sortedPropertyNames.indexOf(propertyName) < 0) {
        console.warn("Ignoring " + propertyName + "; not in sorted-property-names.json");
      }
    }
    tags = JSON.parse(fs.readFileSync(path.join(__dirname, 'html-tags.json')));
    pseudoSelectors = JSON.parse(fs.readFileSync(path.join(__dirname, 'pseudo-selectors.json')));
    completions = {
      tags: tags,
      properties: properties,
      pseudoSelectors: pseudoSelectors
    };
    return fs.writeFileSync(path.join(__dirname, 'completions.json'), (JSON.stringify(completions, null, '  ')) + "\n");
  });

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
